/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.util.concurrent.SettableFuture;
import java.lang.reflect.Type;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.jersey.internal.ContextResolverFactory;
import org.glassfish.jersey.internal.ExceptionMapperFactory;
import org.glassfish.jersey.internal.JaxrsProviders;
import org.glassfish.jersey.internal.ProviderBinder;
import org.glassfish.jersey.internal.ServiceFinderModule;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.internal.inject.ContextInjectionResolver;
import org.glassfish.jersey.internal.inject.Module;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.inject.Utilities;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.internal.MessageBodyFactory;
import org.glassfish.jersey.message.internal.MessagingModules;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.AsyncInflectorAdapter;
import org.glassfish.jersey.process.internal.DefaultRespondingContext;
import org.glassfish.jersey.process.internal.ExecutorsFactory;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.process.internal.ProcessingModule;
import org.glassfish.jersey.process.internal.RequestInvoker;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.server.ChunkedResponseWriter;
import org.glassfish.jersey.server.ContainerFilteringStage;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ReferencesInitializer;
import org.glassfish.jersey.server.SecurityContextModule;
import org.glassfish.jersey.server.internal.ServerExecutorsFactory;
import org.glassfish.jersey.server.internal.inject.CloseableServiceModule;
import org.glassfish.jersey.server.internal.inject.ParameterInjectionModule;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.glassfish.jersey.server.internal.routing.SingletonResourceBinder;
import org.glassfish.jersey.server.model.ResourceModelModule;
import org.glassfish.jersey.server.spi.ContainerProvider;
import org.glassfish.jersey.spi.ExceptionMappers;

public class ServerModule
extends AbstractModule {
    protected void configure() {
        this.install(new Module[]{new RequestScope.Module(), new ProcessingModule(), new ContextInjectionResolver.Module(), new MessagingModules.MessageBodyProviders(), new ProviderBinder.ProviderBinderModule(), new MessageBodyFactory.Module(Singleton.class), new ExceptionMapperFactory.Module(Singleton.class), new ContextResolverFactory.Module(Singleton.class), new JaxrsProviders.Module(), new ContainerFilteringStage.Module(), new SecurityContextModule(), new ParameterInjectionModule(), new ResourceModelModule(), new RouterModule(), new ServiceFinderModule(ContainerProvider.class), new CloseableServiceModule(), new SingletonResourceBinder.SingletonResourceBinderModule(), new ServerExecutorsFactory.ServerExecutorModule()});
        this.bind(BuilderHelper.link(RequestReferencingFactory.class).to(Request.class).in(PerLookup.class).buildFactory());
        this.bind(Utilities.createConstantFactoryDescriptor((Factory)ReferencingFactory.referenceFactory(), RequestScoped.class, null, null, null, (Type[])new Type[]{new TypeLiteral<Ref<Request>>(){}.getType()}));
        this.bind(BuilderHelper.link(HttpHeadersReferencingFactory.class).to(HttpHeaders.class).in(PerLookup.class).buildFactory());
        this.bind(Utilities.createConstantFactoryDescriptor((Factory)ReferencingFactory.referenceFactory(), RequestScoped.class, null, null, null, (Type[])new Type[]{new TypeLiteral<Ref<HttpHeaders>>(){}.getType()}));
        this.bind(BuilderHelper.link(RequestContextInjectionFactory.class).to(ContainerRequest.class).in(RequestScoped.class).buildFactory());
        this.bind(BuilderHelper.link(RequestContextInjectionFactory.class).to(ContainerRequestContext.class).in(RequestScoped.class).buildFactory());
        this.bind(Utilities.createConstantFactoryDescriptor((Factory)ReferencingFactory.referenceFactory(), RequestScoped.class, null, null, null, (Type[])new Type[]{new TypeLiteral<Ref<ContainerRequest>>(){}.getType()}));
        this.bind((Descriptor)BuilderHelper.activeLink(DefaultRespondingContext.class).to(new TypeLiteral<ResponseProcessor.RespondingContext<ContainerResponse>>(){}.getType()).in(RequestScoped.class).build());
        this.bind((Descriptor)BuilderHelper.activeLink(ResponseProcessorBuilder.class).to(new TypeLiteral<ResponseProcessor.Builder<ContainerResponse>>(){}.getType()).in(Singleton.class).build());
        this.bind((Descriptor)BuilderHelper.link(ChunkedResponseWriter.class).to(MessageBodyWriter.class).in(Singleton.class).build());
        this.bind((Descriptor)BuilderHelper.link(RequestInvokerBuilder.class).build());
        this.bind((Descriptor)BuilderHelper.link(ReferencesInitializer.class).build());
    }

    static class ResponseProcessorBuilder
    implements ResponseProcessor.Builder<ContainerResponse> {
        @Inject
        private RequestScope requestScope;
        @Inject
        private Provider<ResponseProcessor.RespondingContext<ContainerResponse>> respondingCtxProvider;
        @Inject
        private Provider<ExceptionMappers> exceptionMappersProvider;
        @Inject
        private Provider<ContainerRequest> requestContextFactory;

        public ResponseProcessor<ContainerResponse> build(Future<ContainerResponse> inflectedResponse, SettableFuture<ContainerResponse> processedResponse, InvocationCallback<ContainerResponse> callback, RequestScope.Instance scopeInstance) {
            return new ResponseProcessor<ContainerResponse>(callback, inflectedResponse, processedResponse, this.respondingCtxProvider, scopeInstance, this.requestScope, this.exceptionMappersProvider){

                protected ContainerResponse convertResponse(Response exceptionResponse) {
                    return exceptionResponse == null ? null : new ContainerResponse((ContainerRequest)((Object)ResponseProcessorBuilder.this.requestContextFactory.get()), exceptionResponse);
                }
            };
        }
    }

    static final class RequestInvokerBuilder {
        @Inject
        private RequestScope requestScope;
        @Inject
        private ResponseProcessor.Builder<ContainerResponse> responseProcessorBuilder;
        @Inject
        private Provider<Ref<InvocationContext>> invocationContextReferenceFactory;
        @Inject
        private ExecutorsFactory<ContainerRequest> executorsFactory;

        RequestInvokerBuilder() {
        }

        public RequestInvoker<ContainerRequest, ContainerResponse> build(Stage<ContainerRequest> rootStage) {
            return new RequestInvoker(rootStage, this.requestScope, (AsyncInflectorAdapter.Builder)new AsyncInflectorAdapter.Builder<ContainerRequest, ContainerResponse>(){

                public AsyncInflectorAdapter<ContainerRequest, ContainerResponse> create(Inflector<ContainerRequest, ContainerResponse> wrapped, InvocationCallback<ContainerResponse> callback) {
                    return new AsyncInflectorAdapter<ContainerRequest, ContainerResponse>(wrapped, callback){

                        protected ContainerResponse convertResponse(ContainerRequest requestContext, Response response) {
                            return new ContainerResponse(requestContext, response);
                        }
                    };
                }
            }, this.responseProcessorBuilder, this.invocationContextReferenceFactory, this.executorsFactory);
        }
    }

    private static class RequestContextInjectionFactory
    extends ReferencingFactory<ContainerRequest> {
        @Inject
        public RequestContextInjectionFactory(Provider<Ref<ContainerRequest>> referenceFactory) {
            super(referenceFactory);
        }

        @RequestScoped
        public ContainerRequest provide() {
            return (ContainerRequest)((Object)super.provide());
        }
    }

    private static class HttpHeadersReferencingFactory
    extends ReferencingFactory<HttpHeaders> {
        @Inject
        public HttpHeadersReferencingFactory(Provider<Ref<HttpHeaders>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class RequestReferencingFactory
    extends ReferencingFactory<Request> {
        @Inject
        public RequestReferencingFactory(Provider<Ref<Request>> referenceFactory) {
            super(referenceFactory);
        }
    }
}

