/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import org.glassfish.jersey.spi.StringValueReader;

abstract class AbstractStringReaderExtractor<T> {
    private final StringValueReader<T> valueReader;
    private final String parameterName;
    private final String defaultValueString;

    protected AbstractStringReaderExtractor(StringValueReader<T> valueReader, String parameterName, String defaultValueString) {
        StringValueReader.ValidateDefaultValue validate;
        this.valueReader = valueReader;
        this.parameterName = parameterName;
        this.defaultValueString = defaultValueString;
        if (defaultValueString != null && ((validate = valueReader.getClass().getAnnotation(StringValueReader.ValidateDefaultValue.class)) == null || validate.value())) {
            valueReader.fromString(defaultValueString);
        }
    }

    public String getName() {
        return this.parameterName;
    }

    public String getDefaultValueString() {
        return this.defaultValueString;
    }

    protected final T fromString(String value) {
        Object result = this.valueReader.fromString(value);
        if (result == null) {
            return this.defaultValue();
        }
        return (T)result;
    }

    protected final boolean isDefaultValueRegistered() {
        return this.defaultValueString != null;
    }

    protected final T defaultValue() {
        return (T)(this.defaultValueString == null ? null : this.valueReader.fromString(this.defaultValueString));
    }
}

