/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.WeakHashMap;
import javax.inject.Provider;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.glassfish.jersey.internal.ExtractorException;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.spi.StringValueReader;
import org.glassfish.jersey.spi.StringValueReaderProvider;
import org.xml.sax.InputSource;

public class JaxbStringReaderProvider {
    private static final Map<Class, JAXBContext> jaxbContexts = new WeakHashMap<Class, JAXBContext>();
    private final Supplier<ContextResolver<JAXBContext>> mtContext;
    private final Supplier<ContextResolver<Unmarshaller>> mtUnmarshaller;

    public JaxbStringReaderProvider(final Providers ps) {
        this.mtContext = Suppliers.memoize((Supplier)new Supplier<ContextResolver<JAXBContext>>(){

            public ContextResolver<JAXBContext> get() {
                return ps.getContextResolver(JAXBContext.class, null);
            }
        });
        this.mtUnmarshaller = Suppliers.memoize((Supplier)new Supplier<ContextResolver<Unmarshaller>>(){

            public ContextResolver<Unmarshaller> get() {
                return ps.getContextResolver(Unmarshaller.class, null);
            }
        });
    }

    protected final Unmarshaller getUnmarshaller(Class type) throws JAXBException {
        Unmarshaller u;
        ContextResolver unmarshallerContextResolver = (ContextResolver)this.mtUnmarshaller.get();
        if (unmarshallerContextResolver != null && (u = (Unmarshaller)unmarshallerContextResolver.getContext(type)) != null) {
            return u;
        }
        return this.getJAXBContext(type).createUnmarshaller();
    }

    private JAXBContext getJAXBContext(Class type) throws JAXBException {
        JAXBContext c;
        ContextResolver jaxbContextContextResolver = (ContextResolver)this.mtContext.get();
        if (jaxbContextContextResolver != null && (c = (JAXBContext)jaxbContextContextResolver.getContext(type)) != null) {
            return c;
        }
        return this.getStoredJAXBContext(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JAXBContext getStoredJAXBContext(Class type) throws JAXBException {
        Map<Class, JAXBContext> map = jaxbContexts;
        synchronized (map) {
            JAXBContext c = jaxbContexts.get(type);
            if (c == null) {
                c = JAXBContext.newInstance((Class[])new Class[]{type});
                jaxbContexts.put(type, c);
            }
            return c;
        }
    }

    public static class RootElementProvider
    extends JaxbStringReaderProvider
    implements StringValueReaderProvider {
        private Provider<SAXParserFactory> spfProvider;

        public RootElementProvider(@Context Provider<SAXParserFactory> spfProvider, @Context Providers ps) {
            super(ps);
            this.spfProvider = spfProvider;
        }

        public <T> StringValueReader<T> getStringReader(final Class<T> type, Type genericType, Annotation[] annotations) {
            boolean supported;
            boolean bl = supported = type.getAnnotation(XmlRootElement.class) != null || type.getAnnotation(XmlType.class) != null;
            if (!supported) {
                return null;
            }
            return new StringValueReader<T>(){

                public T fromString(String value) {
                    try {
                        SAXSource source = new SAXSource(((SAXParserFactory)RootElementProvider.this.spfProvider.get()).newSAXParser().getXMLReader(), new InputSource(new StringReader(value)));
                        Unmarshaller u = RootElementProvider.this.getUnmarshaller(type);
                        if (type.isAnnotationPresent(XmlRootElement.class)) {
                            return type.cast(u.unmarshal((Source)source));
                        }
                        return u.unmarshal((Source)source, type).getValue();
                    }
                    catch (UnmarshalException ex) {
                        throw new ExtractorException(LocalizationMessages.ERROR_UNMARSHALLING_JAXB(type), (Throwable)ex);
                    }
                    catch (JAXBException ex) {
                        throw new ProcessingException(LocalizationMessages.ERROR_UNMARSHALLING_JAXB(type), (Throwable)ex);
                    }
                    catch (Exception ex) {
                        throw new ProcessingException(LocalizationMessages.ERROR_UNMARSHALLING_JAXB(type), (Throwable)ex);
                    }
                }
            };
        }
    }
}

