/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.ClassTypePair;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.inject.CollectionExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.PrimitiveMapper;
import org.glassfish.jersey.server.internal.inject.PrimitiveValueOfExtractor;
import org.glassfish.jersey.server.internal.inject.SingleStringValueExtractor;
import org.glassfish.jersey.server.internal.inject.SingleValueExtractor;
import org.glassfish.jersey.server.internal.inject.StringCollectionExtractor;
import org.glassfish.jersey.server.internal.inject.StringReaderFactory;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.spi.StringValueReader;

@Singleton
final class MultivaluedParameterExtractorFactory
implements MultivaluedParameterExtractorProvider {
    private final StringReaderFactory stringReaderFactory;

    @Inject
    public MultivaluedParameterExtractorFactory(StringReaderFactory stringReaderFactory) {
        this.stringReaderFactory = stringReaderFactory;
    }

    @Override
    public MultivaluedParameterExtractor<?> getWithoutDefaultValue(Parameter p) {
        return this.process(this.stringReaderFactory, null, p.getRawType(), p.getType(), p.getAnnotations(), p.getSourceName());
    }

    @Override
    public MultivaluedParameterExtractor<?> get(Parameter p) {
        return this.process(this.stringReaderFactory, p.getDefaultValue(), p.getRawType(), p.getType(), p.getAnnotations(), p.getSourceName());
    }

    private MultivaluedParameterExtractor<?> process(StringReaderFactory stringReaderFactory, String defaultValue, Class<?> rawType, Type type, Annotation[] annotations, String parameterName) {
        if (rawType == List.class || rawType == Set.class || rawType == SortedSet.class) {
            ClassTypePair ctp;
            List ctps = ReflectionHelper.getTypeArgumentAndClass((Type)type);
            ClassTypePair classTypePair = ctp = ctps.size() == 1 ? (ClassTypePair)ctps.get(0) : null;
            if (ctp == null || ctp.rawClass() == String.class) {
                return StringCollectionExtractor.getInstance(rawType, parameterName, defaultValue);
            }
            StringValueReader sr = stringReaderFactory.getStringReader(ctp.rawClass(), ctp.type(), annotations);
            if (sr == null) {
                return null;
            }
            try {
                return CollectionExtractor.getInstance(rawType, sr, parameterName, defaultValue);
            }
            catch (Exception e) {
                throw new ProcessingException("Could not process parameter type " + rawType, (Throwable)e);
            }
        }
        if (rawType == String.class) {
            return new SingleStringValueExtractor(parameterName, defaultValue);
        }
        if (rawType.isPrimitive()) {
            if ((rawType = PrimitiveMapper.primitiveToClassMap.get(rawType)) == null) {
                return null;
            }
            Method valueOf = ReflectionHelper.getValueOfStringMethod((Class)rawType);
            if (valueOf != null) {
                try {
                    Object defaultDefaultValue = PrimitiveMapper.primitiveToDefaultValueMap.get(rawType);
                    return new PrimitiveValueOfExtractor(valueOf, parameterName, defaultValue, defaultDefaultValue);
                }
                catch (Exception e) {
                    throw new ProcessingException(LocalizationMessages.DEFAULT_COULD_NOT_PROCESS_METHOD(defaultValue, valueOf));
                }
            }
        } else {
            StringValueReader sr = stringReaderFactory.getStringReader(rawType, type, annotations);
            if (sr == null) {
                return null;
            }
            try {
                return new SingleValueExtractor(sr, parameterName, defaultValue);
            }
            catch (Exception e) {
                throw new ProcessingException("Could not process parameter type " + rawType, (Throwable)e);
            }
        }
        return null;
    }
}

