/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Set;
import javax.inject.Inject;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;
import org.jvnet.tigertypes.Types;

public abstract class ParamInjectionResolver<A extends Annotation>
implements InjectionResolver<A> {
    @Inject
    private ServiceLocator services;
    final Predicate<ValueFactoryProvider> concreteValueFactoryClassFilter;

    public ParamInjectionResolver(Class<A> injectionAnnotationClass, final Class<? extends AbstractValueFactoryProvider<A>> valueFactoryProviderClass) {
        this.concreteValueFactoryClassFilter = new Predicate<ValueFactoryProvider>(){

            public boolean apply(ValueFactoryProvider input) {
                return valueFactoryProviderClass.isInstance(input);
            }
        };
    }

    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        Parameter parameter;
        AnnotatedElement annotated = injectee.getParent();
        Class componentClass = injectee.getInjecteeClass();
        Type genericType = injectee.getRequiredType();
        boolean isHk2Factory = Types.isSubClassOf((Type)genericType, Factory.class);
        Type targetGenericType = isHk2Factory ? Types.getTypeArgument((Type)genericType, (int)0) : genericType;
        Class targetType = Types.erasure((Type)targetGenericType);
        Set providers = Sets.filter((Set)Providers.getProviders((ServiceLocator)this.services, ValueFactoryProvider.class), this.concreteValueFactoryClassFilter);
        ValueFactoryProvider valueFactoryProvider = (ValueFactoryProvider)providers.iterator().next();
        Factory<?> valueFactory = valueFactoryProvider.getValueFactory(parameter = Parameter.create(componentClass, componentClass, false, targetType, targetGenericType, annotated.getDeclaredAnnotations()));
        if (valueFactory != null) {
            if (isHk2Factory) {
                return valueFactory;
            }
            return valueFactory.provide();
        }
        return null;
    }

    public boolean isConstructorParameterIndicator() {
        return true;
    }

    public boolean isMethodParameterIndicator() {
        return false;
    }
}

