/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.model.MethodHandler;

class PushMethodHandlerRouter
implements Router {
    private final ServiceLocator services;
    private final Provider<RoutingContext> routingContextFactory;
    private final MethodHandler methodHandler;
    private final Router next;

    private PushMethodHandlerRouter(Provider<RoutingContext> routingContextFactory, ServiceLocator services, MethodHandler methodHandler, Router next) {
        this.services = services;
        this.routingContextFactory = routingContextFactory;
        this.methodHandler = methodHandler;
        this.next = next;
    }

    @Override
    public Router.Continuation apply(ContainerRequest request) {
        Object handlerInstance = this.methodHandler.getInstance(this.services);
        ((RoutingContext)this.routingContextFactory.get()).pushMatchedResource(handlerInstance);
        return Router.Continuation.of(request, this.next);
    }

    static class Builder {
        @Inject
        private Provider<RoutingContext> routingContextFactory;
        @Inject
        private ServiceLocator injector;
        @Inject
        private ServiceLocator services;

        Builder() {
        }

        public PushMethodHandlerRouter build(MethodHandler methodHandler, Router next) {
            return new PushMethodHandlerRouter(this.routingContextFactory, this.services, methodHandler, next);
        }
    }
}

