/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.jersey.internal.inject.AbstractModule;

public class SingletonResourceBinder {
    private Set<Class<?>> registeredClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Object lock = new Object();
    @Inject
    private ServiceLocator locator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void bindResourceClassAsSingleton(Class<T> resourceClass) {
        if (this.registeredClasses.contains(resourceClass)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.registeredClasses.contains(resourceClass)) {
                return;
            }
            if (resourceClass.isAnnotationPresent(Singleton.class)) {
                DynamicConfigurationService dcs = (DynamicConfigurationService)this.locator.getService(DynamicConfigurationService.class, new Annotation[0]);
                DynamicConfiguration dc = dcs.createDynamicConfiguration();
                Object instance = this.locator.createAndInitialize(resourceClass);
                AbstractActiveDescriptor descriptor = BuilderHelper.createConstantDescriptor((Object)instance);
                descriptor.addContractType(resourceClass);
                dc.bind((Descriptor)descriptor);
                dc.commit();
            }
            this.registeredClasses.add(resourceClass);
        }
    }

    public static class SingletonResourceBinderModule
    extends AbstractModule {
        protected void configure() {
            this.bind((Descriptor)BuilderHelper.link(SingletonResourceBinder.class).in(Singleton.class).build());
        }
    }
}

