/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.scanning;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ResourceFinder;
import org.glassfish.jersey.server.internal.scanning.JarFileScanner;
import org.glassfish.jersey.server.internal.scanning.ResourceFinderException;
import org.glassfish.jersey.server.internal.scanning.ResourceFinderStack;

public class FilesScanner
implements ResourceFinder {
    private ResourceFinderStack resourceFinderStack = new ResourceFinderStack();
    private final File[] files;

    public FilesScanner(String files) {
        this(new String[]{files});
    }

    public FilesScanner(String[] fileNames) {
        this.files = new File[ResourceConfig.getElements(fileNames, " ,;\n").length];
        for (int i = 0; i < this.files.length; ++i) {
            this.files[i] = new File(fileNames[i]);
        }
        for (File f : this.files) {
            this.processFile(f);
        }
    }

    private void processFile(final File f) {
        if (f.getName().endsWith(".jar") || f.getName().endsWith(".zip")) {
            try {
                this.resourceFinderStack.push(new JarFileScanner(new FileInputStream(f), ""));
            }
            catch (IOException e) {
                throw new ResourceFinderException(e);
            }
        } else {
            this.resourceFinderStack.push(new ResourceFinder(){
                Stack<File> files = new Stack<File>(){
                    {
                        if (f.isDirectory()) {
                            for (File file : f.listFiles()) {
                                this.push(file);
                            }
                        } else {
                            this.push(f);
                        }
                    }
                };
                private File current;
                private File next;

                @Override
                public boolean hasNext() {
                    while (this.next == null && !this.files.empty()) {
                        this.next = this.files.pop();
                        if (!this.next.isDirectory() && !this.next.getName().endsWith(".jar") && !this.next.getName().endsWith(".zip")) continue;
                        FilesScanner.this.processFile(this.next);
                        this.next = null;
                    }
                    return this.next != null;
                }

                @Override
                public String next() {
                    if (this.next != null || this.hasNext()) {
                        this.current = this.next;
                        this.next = null;
                        return this.current.getName();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public InputStream open() {
                    try {
                        return new FileInputStream(this.current);
                    }
                    catch (FileNotFoundException e) {
                        throw new ResourceFinderException(e);
                    }
                }

                @Override
                public void reset() {
                }
            });
        }
    }

    @Override
    public boolean hasNext() {
        return this.resourceFinderStack.hasNext();
    }

    @Override
    public String next() {
        return this.resourceFinderStack.next();
    }

    @Override
    public void remove() {
        this.resourceFinderStack.remove();
    }

    @Override
    public InputStream open() {
        return this.resourceFinderStack.open();
    }

    @Override
    public void reset() {
        this.resourceFinderStack = new ResourceFinderStack();
        for (File f : this.files) {
            this.processFile(f);
        }
    }
}

