/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.lang.reflect.InvocationHandler;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;

@Singleton
final class ResourceMethodDispatcherFactory
implements ResourceMethodDispatcher.Provider {
    private static final Logger LOGGER = Logger.getLogger(ResourceMethodDispatcherFactory.class.getName());
    private final Set<ResourceMethodDispatcher.Provider> providers;

    @Inject
    ResourceMethodDispatcherFactory(ServiceLocator services) {
        this.providers = Providers.getProviders((ServiceLocator)services, ResourceMethodDispatcher.Provider.class);
    }

    @Override
    public ResourceMethodDispatcher create(Invocable resourceMethod, InvocationHandler handler) {
        for (ResourceMethodDispatcher.Provider provider : this.providers) {
            try {
                ResourceMethodDispatcher dispatcher = provider.create(resourceMethod, handler);
                if (dispatcher == null) continue;
                return dispatcher;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_PROCESSING_METHOD(resourceMethod, provider.getClass().getName()), e);
            }
        }
        return null;
    }
}

