/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.NameBinding;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicBinder;
import javax.ws.rs.container.PostMatching;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.jersey.Config;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.BindingBuilder;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.ProviderBinder;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.HeaderValueException;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.InflectorNotFoundException;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.process.internal.PriorityComparator;
import org.glassfish.jersey.process.internal.RequestInvoker;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.server.ChunkedResponse;
import org.glassfish.jersey.server.CloseableService;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerFilteringStage;
import org.glassfish.jersey.server.ContainerMessageBodyWorkersInitializer;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ContainerResponseWriterCallback;
import org.glassfish.jersey.server.ReferencesInitializer;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerBinder;
import org.glassfish.jersey.server.TimingOutInvocationCallback;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.routing.RoutedInflectorExtractorStage;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingStage;
import org.glassfish.jersey.server.internal.routing.RuntimeModelBuilder;
import org.glassfish.jersey.server.internal.routing.SingletonResourceBinder;
import org.glassfish.jersey.server.model.BasicValidator;
import org.glassfish.jersey.server.model.MethodHandler;
import org.glassfish.jersey.server.model.ModelValidationException;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModelIssue;
import org.glassfish.jersey.server.model.ResourceModelValidator;
import org.glassfish.jersey.server.spi.ComponentProvider;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

public final class ApplicationHandler {
    private static final Logger LOGGER = Logger.getLogger(ApplicationHandler.class.getName());
    private static final SecurityContext DEFAULT_SECURITY_CONTEXT = new SecurityContext(){

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public String getAuthenticationScheme() {
            return null;
        }
    };
    @Inject
    private Factory<CloseableService> closeableServiceFactory;
    private ServiceLocator locator;
    private RequestInvoker<ContainerRequest, ContainerResponse> invoker;
    private final ResourceConfig configuration;

    public ApplicationHandler() {
        this.initServiceLocator();
        this.configuration = new ResourceConfig();
        this.initialize();
    }

    public ApplicationHandler(Class<? extends Application> jaxrsApplicationClass) {
        this.initServiceLocator();
        this.configuration = ResourceConfig.class.isAssignableFrom(jaxrsApplicationClass) ? (ResourceConfig)this.createApplication(jaxrsApplicationClass) : ResourceConfig.forApplicationClass(jaxrsApplicationClass);
        this.initialize();
    }

    public ApplicationHandler(Application application) {
        this.initServiceLocator();
        this.configuration = ResourceConfig.forApplication(application);
        this.initialize();
    }

    private void initServiceLocator() {
        this.locator = Injections.createLocator((Binder[])new Binder[]{new ServerBinder(), new ApplicationBinder()});
    }

    private void initialize() {
        this.registerAdditionalBinders(this.configuration.getCustomBinders());
        Class<? extends Application> applicationClass = this.configuration.getApplicationClass();
        if (applicationClass != null) {
            Application application = this.createApplication(applicationClass);
            if (application instanceof ResourceConfig) {
                this.registerAdditionalBinders(((ResourceConfig)application).getCustomBinders());
            }
            this.configuration.setApplication(application);
        }
        this.configuration.lock();
        LinkedList resourceModelIssues = Lists.newLinkedList();
        HashMap pathToResourceBuilderMap = Maps.newHashMap();
        LinkedList<Resource.Builder> resourcesBuilders = new LinkedList<Resource.Builder>();
        for (Class<?> c : this.configuration.getClasses()) {
            Path path = Resource.getPath(c);
            if (path == null) continue;
            try {
                String pathValue = path.value();
                Resource.Builder builder = Resource.builder(c, (List<ResourceModelIssue>)resourceModelIssues);
                Resource.Builder existing = (Resource.Builder)pathToResourceBuilderMap.get(pathValue);
                if (existing != null) {
                    existing.mergeWith(builder);
                    continue;
                }
                resourcesBuilders.add(builder);
                pathToResourceBuilderMap.put(pathValue, builder);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warning(ex.getMessage());
            }
        }
        for (Resource programmaticResource : this.configuration.getResources()) {
            Resource.Builder builder = (Resource.Builder)pathToResourceBuilderMap.get(programmaticResource.getPath());
            if (builder != null) {
                builder.mergeWith(programmaticResource);
                continue;
            }
            resourcesBuilders.add(Resource.builder(programmaticResource));
        }
        HashSet<ComponentProvider> componentProviders = new HashSet<ComponentProvider>();
        for (ComponentProvider provider : ServiceFinder.find(ComponentProvider.class)) {
            provider.initialize(this.locator);
            componentProviders.add(provider);
        }
        this.registerProvidersAndSingletonResources(componentProviders);
        Collection applicationNameBindings = ReflectionHelper.getAnnotationTypes(this.configuration.getApplication().getClass(), NameBinding.class);
        List responseFilters = Providers.getAllProviders((ServiceLocator)this.locator, ContainerResponseFilter.class);
        MultivaluedMap nameBoundResponseFilters = ApplicationHandler.filterNameBound(responseFilters, null, applicationNameBindings);
        List preMatchFilters = Providers.getAllProviders((ServiceLocator)this.locator, ContainerRequestFilter.class, (Comparator)new PriorityComparator(PriorityComparator.Order.ASCENDING));
        ArrayList<ContainerRequestFilter> requestFilters = new ArrayList<ContainerRequestFilter>();
        MultivaluedMap nameBoundRequestFilters = ApplicationHandler.filterNameBound(preMatchFilters, requestFilters, applicationNameBindings);
        List readerInterceptors = this.locator.getAllServices(ReaderInterceptor.class, new Annotation[0]);
        MultivaluedMap nameBoundReaderInterceptors = ApplicationHandler.filterNameBound(readerInterceptors, null, applicationNameBindings);
        List writerInterceptors = this.locator.getAllServices(WriterInterceptor.class, new Annotation[0]);
        MultivaluedMap nameBoundWriterInterceptors = ApplicationHandler.filterNameBound(writerInterceptors, null, applicationNameBindings);
        List dynamicBinders = Providers.getAllProviders((ServiceLocator)this.locator, DynamicBinder.class);
        MessageBodyWorkers workers = (MessageBodyWorkers)this.locator.getService(MessageBodyWorkers.class, new Annotation[0]);
        List<Resource> resources = this.buildAndValidate(resourcesBuilders, resourceModelIssues, workers);
        RuntimeModelBuilder runtimeModelBuilder = (RuntimeModelBuilder)this.locator.getService(RuntimeModelBuilder.class, new Annotation[0]);
        runtimeModelBuilder.setWorkers(workers);
        runtimeModelBuilder.setGlobalInterceptors(readerInterceptors, writerInterceptors);
        runtimeModelBuilder.setBoundProviders(nameBoundRequestFilters, nameBoundResponseFilters, nameBoundReaderInterceptors, nameBoundWriterInterceptors, dynamicBinders);
        for (Resource resource : resources) {
            runtimeModelBuilder.process(resource, false);
        }
        Router resourceRoutingRoot = runtimeModelBuilder.buildModel(false);
        ContainerFilteringStage preMatchRequestFilteringStage = ((ContainerFilteringStage.Builder)this.locator.createAndInitialize(ContainerFilteringStage.Builder.class)).build(preMatchFilters, responseFilters);
        RoutingStage routingStage = ((RoutingStage.Builder)this.locator.createAndInitialize(RoutingStage.Builder.class)).build(resourceRoutingRoot);
        ContainerFilteringStage resourceFilteringStage = ((ContainerFilteringStage.Builder)this.locator.createAndInitialize(ContainerFilteringStage.Builder.class)).build(requestFilters, null);
        RoutedInflectorExtractorStage routedInflectorExtractorStage = (RoutedInflectorExtractorStage)this.locator.createAndInitialize(RoutedInflectorExtractorStage.class);
        Stage rootStage = Stages.chain((Function)((Function)this.locator.createAndInitialize(ReferencesInitializer.class))).to((Function)this.locator.createAndInitialize(ContainerMessageBodyWorkersInitializer.class)).to((ChainableStage)preMatchRequestFilteringStage).to((ChainableStage)routingStage).to((ChainableStage)resourceFilteringStage).build((Stage)routedInflectorExtractorStage);
        this.invoker = ((ServerBinder.RequestInvokerBuilder)this.locator.createAndInitialize(ServerBinder.RequestInvokerBuilder.class)).build((Stage<ContainerRequest>)rootStage);
        this.locator.inject((Object)this);
    }

    private static <T> MultivaluedMap<Class<? extends Annotation>, T> filterNameBound(Collection<T> all, Collection<ContainerRequestFilter> postMatching, Collection<Class<? extends Annotation>> applicationNameBindings) {
        MultivaluedHashMap result = new MultivaluedHashMap();
        Iterator<T> it = all.iterator();
        block0: while (it.hasNext()) {
            T filter = it.next();
            boolean post = false;
            HashSet<Class<? extends Annotation>> nameBindings = new HashSet<Class<? extends Annotation>>();
            for (Annotation annotation : filter.getClass().getAnnotations()) {
                if (postMatching != null && (annotation instanceof PostMatching || applicationNameBindings.contains(annotation.annotationType()))) {
                    post = true;
                    continue;
                }
                if (postMatching == null && applicationNameBindings.contains(annotation.annotationType())) continue block0;
                for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                    if (!(metaAnnotation instanceof NameBinding)) continue;
                    nameBindings.add(annotation.annotationType());
                }
            }
            if (post) {
                it.remove();
                postMatching.add((ContainerRequestFilter)filter);
                continue;
            }
            if (nameBindings.isEmpty()) continue;
            it.remove();
            for (Class clazz : nameBindings) {
                result.add((Object)clazz, filter);
            }
        }
        return result;
    }

    private void registerProvidersAndSingletonResources(Set<ComponentProvider> componentProviders) {
        HashSet cleanProviders = new HashSet();
        HashSet cleanResources = new HashSet();
        HashSet resourcesAndProviders = new HashSet();
        for (Class<?> clazz : this.configuration.getClasses()) {
            boolean bl;
            if (this.bindWithComponentProvider(clazz, componentProviders)) continue;
            if (!Resource.isAcceptable(clazz)) {
                LOGGER.warning(LocalizationMessages.NON_INSTANTIABLE_CLASS(clazz));
                continue;
            }
            boolean isProvider = Providers.isProvider(clazz);
            boolean bl2 = bl = Resource.getPath(clazz) != null;
            if (isProvider && bl) {
                resourcesAndProviders.add(clazz);
                continue;
            }
            if (isProvider) {
                cleanProviders.add(clazz);
                continue;
            }
            if (!bl) continue;
            cleanResources.add(clazz);
        }
        for (Resource programmaticResource : this.configuration.getResources()) {
            if (programmaticResource.getResourceMethods().isEmpty()) continue;
            for (ResourceMethod resourceMethod : programmaticResource.getResourceMethods()) {
                Class<?> handlerClass;
                MethodHandler handler = resourceMethod.getInvocable().getHandler();
                if (!handler.isClassBased() || (handlerClass = handler.getHandlerClass()) == null) continue;
                if (cleanProviders.contains(handlerClass)) {
                    cleanProviders.remove(handlerClass);
                    resourcesAndProviders.add(handlerClass);
                    continue;
                }
                if (cleanResources.contains(handlerClass) || resourcesAndProviders.contains(handlerClass)) continue;
                cleanResources.add(handlerClass);
            }
        }
        ProviderBinder providerBinder = new ProviderBinder(this.locator);
        providerBinder.bindClasses(cleanProviders);
        providerBinder.bindClasses(resourcesAndProviders, true);
        SingletonResourceBinder singletonResourceBinder = (SingletonResourceBinder)this.locator.getService(SingletonResourceBinder.class, new Annotation[0]);
        for (Class clazz : cleanResources) {
            if (!clazz.isAnnotationPresent(Singleton.class)) {
                DynamicConfiguration dc = Injections.getConfiguration((ServiceLocator)this.locator);
                Injections.addBinding((BindingBuilder)Injections.newBinder((Class)clazz).in(PerLookup.class), (DynamicConfiguration)dc);
                dc.commit();
                continue;
            }
            singletonResourceBinder.bindResourceClassAsSingleton(clazz);
        }
        providerBinder.bindInstances(this.configuration.getSingletons());
        for (ComponentProvider componentProvider : componentProviders) {
            componentProvider.done();
        }
    }

    private Application createApplication(Class<? extends Application> applicationClass) {
        if (applicationClass == ResourceConfig.class) {
            return new ResourceConfig();
        }
        if (applicationClass == Application.class) {
            return new Application();
        }
        return (Application)this.locator.createAndInitialize(applicationClass);
    }

    public void registerAdditionalBinders(Set<Binder> binders) {
        DynamicConfiguration dc = Injections.getConfiguration((ServiceLocator)this.locator);
        for (Binder binder : binders) {
            binder.bind(dc);
        }
        dc.commit();
    }

    private List<Resource> buildAndValidate(List<Resource.Builder> resources, List<ResourceModelIssue> modelIssues, MessageBodyWorkers workers) {
        ArrayList<Resource> result = new ArrayList<Resource>(resources.size());
        BasicValidator validator = new BasicValidator(modelIssues, workers);
        for (Resource.Builder rb : resources) {
            Resource r = rb.build();
            result.add(r);
            validator.validate(r);
        }
        this.processIssues(validator);
        return result;
    }

    private void processIssues(ResourceModelValidator validator) {
        List<ResourceModelIssue> issueList = validator.getIssueList();
        if (!issueList.isEmpty()) {
            String allIssueMessages = this.allIssueLogMessages(validator.getIssueList());
            if (validator.fatalIssuesFound()) {
                LOGGER.severe(LocalizationMessages.ERRORS_AND_WARNINGS_DETECTED_WITH_RESOURCE_CLASSES(allIssueMessages));
            } else {
                LOGGER.warning(LocalizationMessages.WARNINGS_DETECTED_WITH_RESOURCE_CLASSES(allIssueMessages));
            }
        }
        if (validator.fatalIssuesFound()) {
            throw new ModelValidationException(issueList);
        }
    }

    private String allIssueLogMessages(List<ResourceModelIssue> issueList) {
        StringBuilder errors = new StringBuilder("\n");
        StringBuilder warnings = new StringBuilder();
        for (ResourceModelIssue issue : issueList) {
            if (issue.isFatal()) {
                errors.append(LocalizationMessages.ERROR_MSG(issue.getMessage())).append('\n');
                continue;
            }
            warnings.append(LocalizationMessages.WARNING_MSG(issue.getMessage())).append('\n');
        }
        return errors.append((CharSequence)warnings).toString();
    }

    public Future<ContainerResponse> apply(ContainerRequest requestContext) {
        return this.apply(requestContext, new OutputStream(){

            @Override
            public void write(int i) throws IOException {
            }
        });
    }

    public Future<ContainerResponse> apply(final ContainerRequest requestContext, final OutputStream outputStream) {
        requestContext.setSecurityContext(DEFAULT_SECURITY_CONTEXT);
        requestContext.setWriter(new ContainerResponseWriter(){

            @Override
            public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse responseContext) throws ContainerException {
                if (contentLength >= 0L) {
                    responseContext.getHeaders().putSingle((Object)"Content-Length", (Object)Long.toString(contentLength));
                }
                return outputStream;
            }

            @Override
            public void suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) throws IllegalStateException {
            }

            @Override
            public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            }

            @Override
            public void cancel() {
            }

            @Override
            public void commit() {
            }
        });
        TimingOutInvocationCallback callback = new TimingOutInvocationCallback(){
            private ContainerResponse responseContext;

            @Override
            protected ContainerResponse handleResponse(ContainerResponse responseContext) {
                this.responseContext = ApplicationHandler.this.writeResponse(requestContext, responseContext);
                if ("HEAD".equals(requestContext.getMethod())) {
                    ApplicationHandler.this.stripEntity(responseContext);
                }
                return responseContext;
            }

            @Override
            protected ContainerResponse handleFailure(Throwable exception) {
                this.responseContext = ApplicationHandler.this.writeResponse(requestContext, ApplicationHandler.handleFailure(exception, requestContext));
                return this.responseContext;
            }

            @Override
            protected ContainerResponse handleTimeout(InvocationContext context) {
                this.responseContext = ApplicationHandler.this.writeResponse(requestContext, ApplicationHandler.prepareTimeoutResponse(context, requestContext));
                return this.responseContext;
            }

            @Override
            protected void release() {
                ApplicationHandler.this.releaseRequestProcessing(requestContext, this.responseContext);
            }
        };
        this.invoker.apply((Object)requestContext, (InvocationCallback)callback);
        return callback;
    }

    private ContainerResponse stripEntity(ContainerResponse responseContext) {
        if (responseContext.hasEntity()) {
            responseContext.setEntity(null);
        }
        return responseContext;
    }

    public void handle(ContainerRequest requestContext) {
        this.checkContainerRequestContext(requestContext);
        ContainerResponseWriterCallback callback = new ContainerResponseWriterCallback(requestContext){
            private ContainerResponse responseContext;

            @Override
            protected void writeResponse(ContainerResponse response) {
                this.responseContext = ApplicationHandler.this.writeResponse(this.requestContext, response);
            }

            @Override
            protected void writeResponse(Throwable exception) {
                this.responseContext = ApplicationHandler.this.writeResponse(this.requestContext, ApplicationHandler.handleFailure(exception, this.requestContext));
            }

            @Override
            protected void writeTimeoutResponse(InvocationContext context) {
                this.responseContext = ApplicationHandler.this.writeResponse(this.requestContext, ApplicationHandler.prepareTimeoutResponse(context, this.requestContext));
            }

            @Override
            protected void release() {
                ApplicationHandler.this.releaseRequestProcessing(this.requestContext, this.responseContext);
            }
        };
        this.invoker.apply((Object)requestContext, (InvocationCallback)callback);
        callback.suspendWriterIfRunning();
    }

    private void releaseRequestProcessing(ContainerRequest requestContext, ContainerResponse responseContext) {
        ((CloseableService)this.closeableServiceFactory.provide()).close();
        if (responseContext != null && !responseContext.isChunked()) {
            responseContext.close();
        }
    }

    private void checkContainerRequestContext(ContainerRequest requestContext) {
        if (requestContext.getSecurityContext() == null) {
            throw new IllegalArgumentException("SecurityContext from ContainerRequestContext must not be null.");
        }
        if (requestContext.getRequest() == null) {
            throw new IllegalArgumentException("Request from ContainerRequestContext must not be null.");
        }
        if (requestContext.getResponseWriter() == null) {
            throw new IllegalArgumentException("ResponseWriter from ContainerRequestContext must not be null.");
        }
    }

    private static ContainerResponse prepareTimeoutResponse(InvocationContext context, ContainerRequest requestContext) {
        Response response = context.getResponse();
        if (response == null) {
            response = Response.serverError().entity((Object)"Request processing has timed out.").type("text/plain").build();
        }
        return new ContainerResponse(requestContext, response);
    }

    private static ContainerResponse handleFailure(Throwable failure, ContainerRequest requestContext) {
        Response.Status statusCode = Response.Status.INTERNAL_SERVER_ERROR;
        String message = failure.getMessage();
        if (failure instanceof ProcessingException) {
            if (failure instanceof HeaderValueException) {
                statusCode = Response.Status.BAD_REQUEST;
            } else if (failure instanceof InflectorNotFoundException) {
                statusCode = Response.Status.NOT_FOUND;
                message = "Requested resource not found.";
            }
        } else if (failure instanceof WebApplicationException) {
            WebApplicationException wae = (WebApplicationException)failure;
            return new ContainerResponse(requestContext, wae.getResponse());
        }
        if (statusCode == Response.Status.INTERNAL_SERVER_ERROR) {
            LOGGER.log(Level.SEVERE, message, failure);
        } else {
            LOGGER.log(Level.FINE, message, failure);
        }
        return new ContainerResponse(requestContext, Response.status((Response.StatusType)statusCode).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContainerResponse writeResponse(ContainerRequest requestContext, final ContainerResponse responseContext) {
        block17: {
            final ContainerResponseWriter writer = requestContext.getResponseWriter();
            final MessageBodySizeCallback messageBodySizeCallback = new MessageBodySizeCallback();
            if (!responseContext.hasEntity()) {
                writer.writeResponseStatusAndHeaders(0L, responseContext);
                return responseContext;
            }
            Object entity = responseContext.getEntity();
            boolean skipFinally = false;
            try {
                responseContext.setStreamProvider(new OutboundMessageContext.StreamProvider(){
                    private OutputStream output;

                    public void commit() throws IOException {
                        long size = responseContext.getHeaders().getFirst((Object)"Content-Encoding") != null ? -1L : messageBodySizeCallback.getSize();
                        this.output = writer.writeResponseStatusAndHeaders(size, responseContext);
                    }

                    public OutputStream getOutputStream() throws IOException {
                        return this.output;
                    }
                });
                responseContext.setEntityStream(requestContext.getWorkers().writeTo(entity, entity.getClass(), responseContext.getEntityType(), responseContext.getEntityAnnotations(), responseContext.getMediaType(), responseContext.getHeaders(), requestContext.getPropertiesDelegate(), responseContext.getEntityStream(), (MessageBodyWorkers.MessageBodySizeCallback)messageBodySizeCallback, true, !requestContext.getMethod().equals("HEAD")));
            }
            catch (Exception ex) {
                if (responseContext.isCommitted()) {
                    LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_WRITING_RESPONSE_ENTITY(), ex);
                    break block17;
                }
                skipFinally = true;
                ContainerResponse containerResponse = this.writeResponse(requestContext, ApplicationHandler.handleFailure(ex, requestContext));
                return containerResponse;
            }
            finally {
                if (!skipFinally) {
                    responseContext.commitStream();
                    if (responseContext.isChunked()) {
                        try {
                            ((ChunkedResponse)entity).setContext(requestContext, responseContext);
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_WRITING_RESPONSE_ENTITY_CHUNK(), ex);
                        }
                        writer.suspend(0L, TimeUnit.SECONDS, null);
                    }
                }
            }
        }
        return responseContext;
    }

    public ServiceLocator getServiceLocator() {
        return this.locator;
    }

    public ResourceConfig getConfiguration() {
        return this.configuration;
    }

    private boolean bindWithComponentProvider(Class<?> component, Collection<ComponentProvider> componentProviders) {
        Set contracts = Providers.getProviderContracts(component);
        for (ComponentProvider provider : componentProviders) {
            if (!provider.bind(component, contracts)) continue;
            return true;
        }
        return false;
    }

    private class MessageBodySizeCallback
    implements MessageBodyWorkers.MessageBodySizeCallback {
        private long size = -1L;

        private MessageBodySizeCallback() {
        }

        public void onRequestEntitySize(long size) throws IOException {
            this.size = size;
        }

        public long getSize() {
            return this.size;
        }
    }

    private class ApplicationBinder
    extends AbstractBinder {
        private ApplicationBinder() {
        }

        protected void configure() {
            this.bindFactory(new ResourceConfigProvider()).to(ResourceConfig.class).to(Config.class).in(Singleton.class);
            this.bindFactory(new JaxrsApplicationProvider()).to(Application.class).in(Singleton.class);
            this.bind(ApplicationHandler.this).to(ApplicationHandler.class);
        }

        private class ResourceConfigProvider
        implements Factory<ResourceConfig> {
            private ResourceConfigProvider() {
            }

            public ResourceConfig provide() {
                return ApplicationHandler.this.configuration;
            }

            public void dispose(ResourceConfig instance) {
            }
        }

        private class JaxrsApplicationProvider
        implements Factory<Application> {
            private JaxrsApplicationProvider() {
            }

            public Application provide() {
                return ApplicationHandler.this.configuration.getApplication();
            }

            public void dispose(Application instance) {
            }
        }
    }
}

