/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.process.internal.ExecutorsFactory;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.spi.RequestExecutorsProvider;
import org.glassfish.jersey.spi.ResponseExecutorsProvider;

public class ServerExecutorsFactory
extends ExecutorsFactory<ContainerRequest> {
    private final ExecutorService requestingExecutor = this.getInitialRequestingExecutor(new RequestExecutorsProvider(){

        public ExecutorService getRequestingExecutor() {
            return MoreExecutors.sameThreadExecutor();
        }
    });
    private final ExecutorService respondingExecutor = this.getInitialRespondingExecutor(new ResponseExecutorsProvider(){

        public ExecutorService getRespondingExecutor() {
            return MoreExecutors.sameThreadExecutor();
        }
    });

    @Inject
    public ServerExecutorsFactory(ServiceLocator locator) {
        super(locator);
    }

    public ExecutorService getRequestingExecutor(ContainerRequest request) {
        return this.requestingExecutor;
    }

    public ExecutorService getRespondingExecutor(ContainerRequest containerRequest) {
        return this.respondingExecutor;
    }

    public static class ServerExecutorBinder
    extends AbstractBinder {
        protected void configure() {
            this.bind(ServerExecutorsFactory.class).to((TypeLiteral)new TypeLiteral<ExecutorsFactory<ContainerRequest>>(){}).in(Singleton.class);
        }
    }
}

