/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Path;
import org.glassfish.jersey.server.model.IntrospectionModeller;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModelComponent;
import org.glassfish.jersey.server.model.ResourceModelIssue;
import org.glassfish.jersey.server.model.ResourceModelVisitor;
import org.glassfish.jersey.server.model.Routed;
import org.glassfish.jersey.uri.PathPattern;

public final class Resource
implements Routed,
ResourceModelComponent {
    private final List<String> names;
    private transient String name;
    private final String path;
    private final PathPattern pathPattern;
    private final boolean isRoot;
    private final List<ResourceMethod> resourceMethods;
    private final List<ResourceMethod> subResourceMethods;
    private final List<ResourceMethod> subResourceLocators;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String path) {
        return new Builder(path);
    }

    public static Builder builder(Class<?> resourceClass, List<ResourceModelIssue> issueList) throws IllegalArgumentException {
        return new IntrospectionModeller(resourceClass, issueList).createResourceBuilder(false);
    }

    public static Builder builder(Object resource, List<ResourceModelIssue> issueList) {
        return new IntrospectionModeller(resource.getClass(), issueList).createResourceBuilder(true);
    }

    public static boolean isAcceptable(Class<?> c) {
        return (c.getModifiers() & 0x400) == 0 && !c.isPrimitive() && !c.isAnnotation() && !c.isInterface() && !c.isLocalClass() && (!c.isMemberClass() || (c.getModifiers() & 8) != 0);
    }

    public static Path getPath(Class<?> resourceClass) {
        return IntrospectionModeller.getAnnotatedResourceClass(resourceClass).getAnnotation(Path.class);
    }

    public static Builder builder(Resource resource) {
        Builder b = new Builder(resource.path);
        b.resourceMethods.addAll(resource.resourceMethods);
        b.subResourceMethods.addAll(resource.subResourceMethods);
        b.locators.addAll(resource.subResourceLocators);
        return b;
    }

    private Resource(List<String> names, String path, boolean isRoot, List<ResourceMethod> resourceMethods, List<ResourceMethod> subResourceMethods, List<ResourceMethod> subResourceLocators) {
        this.names = names;
        this.path = path;
        this.isRoot = isRoot;
        this.pathPattern = !isRoot || path == null || path.isEmpty() ? PathPattern.OPEN_ROOT_PATH_PATTERN : new PathPattern(path, PathPattern.RightHandPath.capturingZeroOrMoreSegments);
        this.resourceMethods = resourceMethods;
        this.subResourceMethods = subResourceMethods;
        this.subResourceLocators = subResourceLocators;
    }

    public boolean isRootResource() {
        return this.isRoot;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public PathPattern getPathPattern() {
        return this.pathPattern;
    }

    public String getName() {
        if (this.name == null) {
            if (this.names.size() == 1) {
                this.name = this.names.get(0);
            } else {
                StringBuilder nameBuilder = new StringBuilder("Merge of ");
                nameBuilder.append(this.names.toString());
                this.name = nameBuilder.toString();
            }
        }
        return this.name;
    }

    public List<ResourceMethod> getResourceMethods() {
        return this.resourceMethods;
    }

    public List<ResourceMethod> getSubResourceMethods() {
        return this.subResourceMethods;
    }

    public List<ResourceMethod> getSubResourceLocators() {
        return this.subResourceLocators;
    }

    @Override
    public void accept(ResourceModelVisitor visitor) {
        visitor.visitResourceClass(this);
    }

    public String toString() {
        return "Resource {" + (this.path == null ? "[unbound], " : "\"" + this.path + "\", ") + this.resourceMethods.size() + " resource methods, " + this.subResourceMethods.size() + " sub-resource methods, " + this.subResourceLocators + " sub-resource locators" + '}';
    }

    @Override
    public List<? extends ResourceModelComponent> getComponents() {
        LinkedList<ResourceMethod> components = new LinkedList<ResourceMethod>();
        components.addAll(this.getResourceMethods());
        components.addAll(this.getSubResourceMethods());
        components.addAll(this.getSubResourceLocators());
        return components;
    }

    public static final class Builder {
        private List<String> names;
        private String path;
        private boolean isRoot;
        private final Set<ResourceMethod.Builder> methodBuilders = Sets.newIdentityHashSet();
        private final List<ResourceMethod> resourceMethods = Lists.newLinkedList();
        private final List<ResourceMethod> subResourceMethods = Lists.newLinkedList();
        private final List<ResourceMethod> locators = Lists.newLinkedList();

        private Builder() {
            this.name("[unnamed]");
        }

        private Builder(String path) {
            this();
            this.path(path);
        }

        public Builder name(String name) {
            this.names = Lists.newArrayList((Object[])new String[]{name});
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.isRoot = true;
            return this;
        }

        public ResourceMethod.Builder addMethod(String httpMethod) {
            ResourceMethod.Builder builder = new ResourceMethod.Builder(this);
            this.methodBuilders.add(builder);
            return builder.httpMethod(httpMethod);
        }

        public ResourceMethod.Builder addMethod() {
            ResourceMethod.Builder builder = new ResourceMethod.Builder(this);
            this.methodBuilders.add(builder);
            return builder;
        }

        public Builder mergeWith(Resource resource) {
            this.resourceMethods.addAll(resource.getResourceMethods());
            this.subResourceMethods.addAll(resource.getSubResourceMethods());
            this.locators.addAll(resource.getSubResourceLocators());
            this.names.addAll(resource.names);
            return this;
        }

        public Builder mergeWith(Builder resourceBuilder) {
            resourceBuilder.processMethodBuilders();
            this.resourceMethods.addAll(resourceBuilder.resourceMethods);
            this.subResourceMethods.addAll(resourceBuilder.subResourceMethods);
            this.locators.addAll(resourceBuilder.locators);
            this.names.addAll(resourceBuilder.names);
            return this;
        }

        void onBuildMethod(ResourceMethod.Builder builder, ResourceMethod method) {
            Preconditions.checkState((boolean)this.methodBuilders.remove(builder), (Object)"Resource.Builder.onBuildMethod() invoked from a resource method builder that is not registered in the resource builder instance.");
            switch (method.getType()) {
                case RESOURCE_METHOD: {
                    this.resourceMethods.add(method);
                    break;
                }
                case SUB_RESOURCE_METHOD: {
                    this.subResourceMethods.add(method);
                    break;
                }
                case SUB_RESOURCE_LOCATOR: {
                    this.locators.add(method);
                }
            }
        }

        public Resource build() {
            this.processMethodBuilders();
            return new Resource(Collections.unmodifiableList(Lists.newArrayList(this.names)), this.path, this.isRoot, Collections.unmodifiableList(Lists.newArrayList(this.resourceMethods)), Collections.unmodifiableList(Lists.newArrayList(this.subResourceMethods)), Collections.unmodifiableList(Lists.newArrayList(this.locators)));
        }

        private void processMethodBuilders() {
            while (!this.methodBuilders.isEmpty()) {
                this.methodBuilders.iterator().next().build();
            }
        }
    }
}

