/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.model.internal.RankedComparator;
import org.glassfish.jersey.model.internal.RankedProvider;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.AbstractChainableStage;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.process.Endpoint;
import org.glassfish.jersey.server.internal.process.RespondingContext;
import org.glassfish.jersey.server.internal.routing.RoutingContext;

class ContainerFilteringStage
extends AbstractChainableStage<ContainerRequest> {
    private ServiceLocator locator;
    private final Iterable<RankedProvider<ContainerRequestFilter>> requestFilters;
    private final Iterable<RankedProvider<ContainerResponseFilter>> responseFilters;
    private final Provider<RespondingContext> respondingContextFactory;

    private ContainerFilteringStage(Provider<RespondingContext> respondingContextFactory, ServiceLocator locator, Iterable<RankedProvider<ContainerRequestFilter>> requestFilters, Iterable<RankedProvider<ContainerResponseFilter>> responseFilters) {
        this.respondingContextFactory = respondingContextFactory;
        this.locator = locator;
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
    }

    public Stage.Continuation<ContainerRequest> apply(ContainerRequest requestContext) {
        Iterable sortedRequestFilters;
        if (this.responseFilters == null) {
            RoutingContext rc = (RoutingContext)this.locator.getService(RoutingContext.class, new Annotation[0]);
            sortedRequestFilters = Providers.sortRankedProviders((RankedComparator)new RankedComparator(), (Iterable[])new Iterable[]{this.requestFilters, rc.getBoundRequestFilters()});
        } else {
            ((RespondingContext)this.respondingContextFactory.get()).push((ChainableStage<ContainerResponse>)new ResponseFilterStage(this.responseFilters, this.locator));
            sortedRequestFilters = Providers.sortRankedProviders((RankedComparator)new RankedComparator(), (Iterable[])new Iterable[]{this.requestFilters});
        }
        for (ContainerRequestFilter filter : sortedRequestFilters) {
            try {
                filter.filter((ContainerRequestContext)requestContext);
                final Response abortResponse = requestContext.getAbortResponse();
                if (abortResponse == null) continue;
                return Stage.Continuation.of((Object)((Object)requestContext), (Stage)Stages.asStage((Inflector)new Endpoint(){

                    public ContainerResponse apply(ContainerRequest requestContext) {
                        return new ContainerResponse(requestContext, abortResponse);
                    }
                }));
            }
            catch (IOException ex) {
                Response abortResponse = requestContext.getAbortResponse();
                if (abortResponse == null) {
                    throw new WebApplicationException((Throwable)ex);
                }
                throw new WebApplicationException((Throwable)ex, abortResponse);
            }
        }
        return Stage.Continuation.of((Object)((Object)requestContext), (Stage)this.getDefaultNext());
    }

    static class Binder
    extends AbstractBinder {
        Binder() {
        }

        protected void configure() {
            this.bindAsContract(Builder.class);
        }
    }

    private static class ResponseFilterStage
    extends AbstractChainableStage<ContainerResponse> {
        private final Iterable<RankedProvider<ContainerResponseFilter>> filters;
        private final ServiceLocator locator;

        private ResponseFilterStage(Iterable<RankedProvider<ContainerResponseFilter>> filters, ServiceLocator locator) {
            this.filters = filters;
            this.locator = locator;
        }

        public Stage.Continuation<ContainerResponse> apply(ContainerResponse responseContext) {
            try {
                RoutingContext rc = (RoutingContext)this.locator.getService(RoutingContext.class, new Annotation[0]);
                Iterable sortedResponseFilters = Providers.sortRankedProviders((RankedComparator)new RankedComparator(), (Iterable[])new Iterable[]{this.filters, rc.getBoundResponseFilters()});
                for (ContainerResponseFilter filter : sortedResponseFilters) {
                    filter.filter((ContainerRequestContext)responseContext.getRequestContext(), (ContainerResponseContext)responseContext);
                }
            }
            catch (IOException ex) {
                throw new WebApplicationException((Throwable)ex);
            }
            return Stage.Continuation.of((Object)responseContext, (Stage)this.getDefaultNext());
        }
    }

    static class Builder {
        @Inject
        private ServiceLocator locator;
        @Inject
        private Provider<RespondingContext> respondingContextFactory;

        Builder() {
        }

        public ContainerFilteringStage build(Iterable<RankedProvider<ContainerRequestFilter>> requestFilters, Iterable<RankedProvider<ContainerResponseFilter>> responseFilters) {
            return new ContainerFilteringStage(this.respondingContextFactory, this.locator, requestFilters, responseFilters);
        }
    }
}

