/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.BeanParam;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.server.internal.inject.AbstractHttpContextValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.HttpContext;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;

@Singleton
final class BeanParamValueFactoryProvider
extends AbstractValueFactoryProvider {
    @Inject
    private ServiceLocator locator;

    @Inject
    public BeanParamValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator injector) {
        super(mpep, injector, Parameter.Source.BEAN_PARAM);
    }

    public AbstractHttpContextValueFactory<?> createValueFactory(Parameter parameter) {
        BeanParamValueFactory valueFactory = new BeanParamValueFactory(this.locator, parameter);
        return valueFactory;
    }

    private static final class BeanParamValueFactory
    extends AbstractHttpContextValueFactory<Object> {
        private final Parameter parameter;
        private final ServiceLocator locator;

        private BeanParamValueFactory(ServiceLocator locator, Parameter parameter) {
            this.locator = locator;
            this.parameter = parameter;
        }

        @Override
        protected Object get(HttpContext context) {
            return Injections.getOrCreate((ServiceLocator)this.locator, this.parameter.getRawType());
        }
    }

    @Singleton
    static final class InjectionResolver
    extends ParamInjectionResolver<BeanParam> {
        public InjectionResolver() {
            super(BeanParamValueFactoryProvider.class);
        }
    }
}

