/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.jersey.model.internal.DefaultConfig;
import org.glassfish.jersey.server.internal.LocalizationMessages;

public class ResourceMethodConfig
extends DefaultConfig {
    private static final Logger LOGGER = Logger.getLogger(ResourceMethodConfig.class.getName());
    private static final Set<Class<?>> allowedContracts = Sets.newHashSet((Object[])new Class[]{ContainerRequestFilter.class, ContainerResponseFilter.class, ReaderInterceptor.class, WriterInterceptor.class});

    public ResourceMethodConfig(Map<String, Object> properties) {
        super(properties);
    }

    protected Set<Class<?>> checkContracts(Class<?> providerClass, Set<Class<?>> allProviderContracts, Set<Class<?>> bindingContracts) {
        bindingContracts = super.checkContracts(providerClass, allProviderContracts, bindingContracts);
        Set checkedContracts = Sets.newIdentityHashSet();
        for (Class contract : bindingContracts) {
            if (allowedContracts.contains(contract)) {
                checkedContracts.add(contract);
                continue;
            }
            LOGGER.warning(LocalizationMessages.CONTRACT_CANNOT_BE_BOUND_TO_RESOURCE_METHOD(contract, providerClass));
        }
        return checkedContracts;
    }
}

