/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.scanning;

import java.io.InputStream;
import java.util.Deque;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.glassfish.jersey.server.ResourceFinder;
import org.glassfish.jersey.server.internal.AbstractResourceFinderAdapter;

public class ResourceFinderStack
extends AbstractResourceFinderAdapter {
    private final Deque<ResourceFinder> stack = new LinkedList<ResourceFinder>();
    private ResourceFinder current = null;

    @Override
    public boolean hasNext() {
        if (this.current == null) {
            if (!this.stack.isEmpty()) {
                this.current = this.stack.pop();
            } else {
                return false;
            }
        }
        if (this.current.hasNext()) {
            return true;
        }
        if (!this.stack.isEmpty()) {
            this.current = this.stack.pop();
            return this.hasNext();
        }
        return false;
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            return (String)this.current.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public InputStream open() {
        return this.current.open();
    }

    public void push(ResourceFinder iterator) {
        this.stack.push(iterator);
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }
}

