/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.validation.internal;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.internal.inject.ConfiguredValidator;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.validation.internal.ValidateOnExecutionHandler;

class ConfiguredValidatorImpl
implements ConfiguredValidator {
    private final Validator delegate;
    private final Configuration configuration;
    private final ValidateOnExecutionHandler validateOnExecutionHandler;

    ConfiguredValidatorImpl(Validator delegate, Configuration configuration, ValidateOnExecutionHandler validateOnExecutionHandler) {
        this.delegate = delegate;
        this.configuration = configuration;
        this.validateOnExecutionHandler = validateOnExecutionHandler;
    }

    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        return this.delegate.validate(object, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        return this.delegate.validateProperty(object, propertyName, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        return this.delegate.validateValue(beanType, propertyName, value, (Class[])groups);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.delegate.getConstraintsForClass(clazz);
    }

    public <T> T unwrap(Class<T> type) {
        return (T)this.delegate.unwrap(type);
    }

    public ExecutableValidator forExecutables() {
        return this.delegate.forExecutables();
    }

    public void validateResourceAndInputParams(Object resource, Invocable resourceMethod, Object[] args) {
        HashSet constraintViolations = Sets.newHashSet();
        BeanDescriptor beanDescriptor = this.getConstraintsForClass(resource.getClass());
        if (beanDescriptor.isBeanConstrained()) {
            constraintViolations.addAll(this.validate(resource, new Class[0]));
        }
        if (this.configuration.getBootstrapConfiguration().isExecutableValidationEnabled()) {
            Method validationMethod = resourceMethod.getValidateMethod();
            Method handlingMethod = resourceMethod.getHandlingMethod();
            MethodDescriptor methodDescriptor = beanDescriptor.getConstraintsForMethod(validationMethod.getName(), (Class[])validationMethod.getParameterTypes());
            if (methodDescriptor != null && methodDescriptor.hasConstrainedParameters() && this.validateOnExecutionHandler.validateMethod(resource.getClass(), handlingMethod, validationMethod)) {
                constraintViolations.addAll(this.forExecutables().validateParameters(resource, validationMethod, args, new Class[0]));
            }
        }
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException((Set)constraintViolations);
        }
    }

    public void validateResult(Object resource, Invocable resourceMethod, Object result) {
        if (this.configuration.getBootstrapConfiguration().isExecutableValidationEnabled()) {
            HashSet constraintViolations = Sets.newHashSet();
            Method validationMethod = resourceMethod.getValidateMethod();
            BeanDescriptor beanDescriptor = this.getConstraintsForClass(resource.getClass());
            MethodDescriptor methodDescriptor = beanDescriptor.getConstraintsForMethod(validationMethod.getName(), (Class[])validationMethod.getParameterTypes());
            Method handlingMethod = resourceMethod.getHandlingMethod();
            if (methodDescriptor != null && methodDescriptor.hasConstrainedReturnValue() && this.validateOnExecutionHandler.validateMethod(resource.getClass(), handlingMethod, validationMethod)) {
                constraintViolations.addAll(this.forExecutables().validateReturnValue(resource, validationMethod, result, new Class[0]));
                if (result instanceof Response) {
                    constraintViolations.addAll(this.forExecutables().validateReturnValue(resource, validationMethod, ((Response)result).getEntity(), new Class[0]));
                }
            }
            if (!constraintViolations.isEmpty()) {
                throw new ConstraintViolationException((Set)constraintViolations);
            }
        }
    }
}

