/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.linking.contributing;

import jakarta.ws.rs.core.Context;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.linking.ProvideLink;
import org.glassfish.jersey.linking.ProvideLinkDescriptor;
import org.glassfish.jersey.linking.ProvideLinks;
import org.glassfish.jersey.linking.contributing.ResourceLinkContributionContext;
import org.glassfish.jersey.server.ExtendedResourceContext;
import org.glassfish.jersey.server.model.HandlerConstructor;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.MethodHandler;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.model.ResourceModelComponent;
import org.glassfish.jersey.server.model.ResourceModelVisitor;
import org.glassfish.jersey.server.model.RuntimeResource;

public class NaiveResourceLinkContributionContext
implements ResourceLinkContributionContext {
    private final ExtendedResourceContext erc;
    private Map<Class<?>, List<ProvideLinkDescriptor>> mappings;
    private Map<Class<?>, List<ProvideLinkDescriptor>> contributions = new ConcurrentHashMap();

    public NaiveResourceLinkContributionContext(@Context ExtendedResourceContext erc) {
        this.erc = erc;
    }

    @Override
    public List<ProvideLinkDescriptor> getContributorsFor(Class<?> entityClass) {
        this.buildMappings();
        return this.contributions.computeIfAbsent(entityClass, aClass -> Collections.unmodifiableList(this.collectContributors((Class<?>)aClass, (List<ProvideLinkDescriptor>)new ArrayList<ProvideLinkDescriptor>())));
    }

    private List<ProvideLinkDescriptor> collectContributors(Class<?> entityClass, List<ProvideLinkDescriptor> contributors) {
        contributors.addAll(this.mappings.getOrDefault(entityClass, Collections.emptyList()));
        Class<?> sc = entityClass.getSuperclass();
        if (sc != null && sc != Object.class) {
            this.collectContributors(sc, contributors);
        }
        return contributors;
    }

    private void buildMappings() {
        if (this.mappings != null) {
            return;
        }
        final HashMap newMappings = new HashMap();
        this.erc.getResourceModel().accept(new ResourceModelVisitor(){

            private void processComponents(ResourceModelComponent component) {
                List components = component.getComponents();
                if (components != null) {
                    for (ResourceModelComponent rc : components) {
                        rc.accept((ResourceModelVisitor)this);
                    }
                }
            }

            public void visitInvocable(Invocable invocable) {
                this.processComponents((ResourceModelComponent)invocable);
            }

            public void visitRuntimeResource(RuntimeResource runtimeResource) {
                this.processComponents((ResourceModelComponent)runtimeResource);
            }

            public void visitResourceModel(ResourceModel resourceModel) {
                this.processComponents((ResourceModelComponent)resourceModel);
            }

            public void visitResourceHandlerConstructor(HandlerConstructor handlerConstructor) {
                this.processComponents((ResourceModelComponent)handlerConstructor);
            }

            public void visitMethodHandler(MethodHandler methodHandler) {
                this.processComponents((ResourceModelComponent)methodHandler);
            }

            public void visitChildResource(Resource resource) {
                this.processComponents((ResourceModelComponent)resource);
            }

            public void visitResource(Resource resource) {
                this.processComponents((ResourceModelComponent)resource);
            }

            public void visitResourceMethod(ResourceMethod resourceMethod) {
                if (resourceMethod.isExtended()) {
                    return;
                }
                if (resourceMethod.getInvocable() != null) {
                    Invocable i = resourceMethod.getInvocable();
                    Method method = i.getDefinitionMethod();
                    ArrayList<ProvideLinkDescriptor> linkDescriptors = new ArrayList<ProvideLinkDescriptor>();
                    this.handleMetaAnnotations(resourceMethod, method, linkDescriptors);
                    this.handleAnnotations(resourceMethod, linkDescriptors, method, null);
                    for (ProvideLinkDescriptor linkDescriptor : linkDescriptors) {
                        for (Class<?> target : linkDescriptor.getProvideLink().value()) {
                            target = this.handleInheritedTarget(linkDescriptor, target);
                            newMappings.computeIfAbsent(target, aClass -> new ArrayList()).add(linkDescriptor);
                        }
                    }
                }
                this.processComponents((ResourceModelComponent)resourceMethod);
            }

            private Class<?> handleInheritedTarget(ProvideLinkDescriptor linkDescriptor, Class<?> target) {
                if (Objects.equals(ProvideLink.InheritFromAnnotation.class, target)) {
                    Annotation parentAnnotation = linkDescriptor.getParentAnnotation();
                    if (parentAnnotation == null) {
                        throw new IllegalArgumentException("InheritFromAnnotation can only be used for Annotations");
                    }
                    return this.findTarget(parentAnnotation);
                }
                return target;
            }

            private Class<?> findTarget(Annotation parentAnnotation) {
                Method[] methods;
                for (Method method : methods = parentAnnotation.annotationType().getDeclaredMethods()) {
                    if (!method.isAccessible() && !Class.class.isAssignableFrom(method.getReturnType())) continue;
                    try {
                        return (Class)method.invoke((Object)parentAnnotation, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                        Logger.getLogger(NaiveResourceLinkContributionContext.class.getName()).log(Level.FINE, null, ex);
                    }
                }
                throw new IllegalArgumentException("No suitable element of type Class<?> found on: " + parentAnnotation.getClass());
            }

            private void handleMetaAnnotations(ResourceMethod resourceMethod, Method method, List<ProvideLinkDescriptor> linkDescriptors) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = method.getDeclaredAnnotations()) {
                    this.handleAnnotations(resourceMethod, linkDescriptors, annotation.annotationType(), annotation);
                }
            }

            private void handleAnnotations(ResourceMethod resourceMethod, List<ProvideLinkDescriptor> linkDescriptors, AnnotatedElement element, Annotation parentAnnotation) {
                if (element.isAnnotationPresent(ProvideLink.class) || element.isAnnotationPresent(ProvideLinks.class)) {
                    ProvideLinks provideLinks;
                    ProvideLink provideLink = element.getAnnotation(ProvideLink.class);
                    if (provideLink != null) {
                        linkDescriptors.add(new ProvideLinkDescriptor(resourceMethod, provideLink, parentAnnotation));
                    }
                    if ((provideLinks = element.getAnnotation(ProvideLinks.class)) != null) {
                        for (ProvideLink link : provideLinks.value()) {
                            linkDescriptors.add(new ProvideLinkDescriptor(resourceMethod, link, parentAnnotation));
                        }
                    }
                }
            }
        });
        this.mappings = newMappings;
    }
}

