/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.spring;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.jersey.server.spring.LocalizationMessages;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;

@Singleton
public class AutowiredInjectResolver
implements InjectionResolver<Autowired> {
    private static final Logger LOGGER = Logger.getLogger(AutowiredInjectResolver.class.getName());
    private volatile ApplicationContext ctx;

    public AutowiredInjectResolver(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        Qualifier an;
        AnnotatedElement parent = injectee.getParent();
        String beanName = null;
        if (parent != null && (an = parent.getAnnotation(Qualifier.class)) != null) {
            beanName = an.value();
        }
        return this.getBeanFromSpringContext(beanName, injectee.getRequiredType());
    }

    private Object getBeanFromSpringContext(String beanName, Type beanType) {
        Class<?> bt = this.getClassFromType(beanType);
        if (beanName != null) {
            return this.ctx.getBean(beanName, bt);
        }
        Map beans = this.ctx.getBeansOfType(bt);
        if (beans == null || beans.size() != 1) {
            LOGGER.warning(LocalizationMessages.NO_BEANS_FOUND_FOR_TYPE(beanType));
            return null;
        }
        return beans.values().iterator().next();
    }

    private Class<?> getClassFromType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return (Class)pt.getRawType();
        }
        return null;
    }

    public boolean isConstructorParameterIndicator() {
        return false;
    }

    public boolean isMethodParameterIndicator() {
        return false;
    }
}

