/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.spring.scope;

import jakarta.ws.rs.container.ContainerRequestContext;
import java.util.Collection;
import org.glassfish.jersey.server.spring.LocalizationMessages;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.AbstractRequestAttributes;

class JaxrsRequestAttributes
extends AbstractRequestAttributes {
    private final ContainerRequestContext requestContext;

    public JaxrsRequestAttributes(ContainerRequestContext requestContext) {
        this.requestContext = requestContext;
    }

    protected void updateAccessedSessionAttributes() {
    }

    public Object getAttribute(String name, int scope) {
        return this.requestContext.getProperty(name);
    }

    public void setAttribute(String name, Object value, int scope) {
        this.requestContext.setProperty(name, value);
    }

    public void removeAttribute(String name, int scope) {
        this.requestContext.removeProperty(name);
    }

    public String[] getAttributeNames(int scope) {
        if (!this.isRequestActive()) {
            throw new IllegalStateException(LocalizationMessages.NOT_IN_REQUEST_SCOPE());
        }
        return StringUtils.toStringArray((Collection)this.requestContext.getPropertyNames());
    }

    public void registerDestructionCallback(String name, Runnable callback, int scope) {
        this.registerRequestDestructionCallback(name, callback);
    }

    public Object resolveReference(String key) {
        if ("request".equals(key)) {
            return this.requestContext;
        }
        return null;
    }

    public String getSessionId() {
        return null;
    }

    public Object getSessionMutex() {
        return null;
    }
}

