/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.wadl.doclet;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.DocTrees;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.xml.namespace.QName;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.AnnotationDocType;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.ClassDocType;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.MethodDocType;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.NamedValueType;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.ParamDocType;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.RepresentationDocType;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.RequestDocType;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.ResourceDocType;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.ResponseDocType;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.WadlParamType;
import org.glassfish.jersey.wadl.doclet.DocProcessor;
import org.glassfish.jersey.wadl.doclet.DocProcessorWrapper;
import org.glassfish.jersey.wadl.doclet.DocletUtils;
import org.glassfish.jersey.wadl.doclet.Loader;
import org.glassfish.jersey.wadl.doclet.OptionClasspath;
import org.glassfish.jersey.wadl.doclet.OptionDocprocessor;
import org.glassfish.jersey.wadl.doclet.OptionOutput;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ResourceDoclet
implements Doclet {
    private static final Logger LOG = Logger.getLogger(ResourceDoclet.class.getName());
    private static final Pattern PATTERN_RESPONSE_REPRESENTATION = Pattern.compile("@response\\.representation\\.([\\d]+)\\..*");
    private static final Pattern PATTERN_INLINE_TAG = Pattern.compile("(?!\\{)[\\w\\?\\!\\#\\<\\>\\.\\ \\/\\:\\\\-\\{\\}]+(?=\\})");
    private static final String COMA = ", ";
    private static final String EMPTY = "";
    private static final String SPACE = " ";
    private final OptionOutput optionOutput = new OptionOutput();
    private final OptionClasspath optionClasspath = new OptionClasspath();
    private final OptionDocprocessor optionDocprocessor = new OptionDocprocessor();

    @Override
    public void init(Locale locale, Reporter reporter) {
        reporter.print(Diagnostic.Kind.NOTE, "Doclet using locale: " + String.valueOf(locale));
    }

    private String getComments(DocCommentTree docCommentTree) {
        if (docCommentTree != null) {
            StringBuilder body = new StringBuilder();
            docCommentTree.getFullBody().forEach(doc -> body.append(doc.toString()));
            return body.toString();
        }
        return EMPTY;
    }

    private Map<DocTree.Kind, Map<String, String>> getTags(DocCommentTree docCommentTree) {
        HashMap<DocTree.Kind, Map<String, String>> tags = new HashMap<DocTree.Kind, Map<String, String>>();
        if (docCommentTree != null) {
            for (DocTree docTree : docCommentTree.getBlockTags()) {
                HashMap<String, String> tagsInKind = (HashMap<String, String>)tags.get((Object)docTree.getKind());
                if (tagsInKind == null) {
                    tagsInKind = new HashMap<String, String>();
                    tags.put(docTree.getKind(), tagsInKind);
                }
                String[] kindValuePair = this.getTagPair(docTree.toString());
                if (docTree.getKind() == DocTree.Kind.PARAM) {
                    String[] paramValuePair = this.getTagPair(kindValuePair[1]);
                    tagsInKind.put(paramValuePair[0], paramValuePair[1]);
                    continue;
                }
                tagsInKind.put(kindValuePair[0], kindValuePair[1]);
            }
        }
        return tags;
    }

    private String[] getTagPair(String tag) {
        String[] pair = tag.split(SPACE, 2);
        if (pair.length != 2) {
            pair = new String[]{pair[0], null};
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run(DocletEnvironment docEnv) {
        boolean success = true;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Loader ncl = new Loader(this.optionClasspath.getClasspathElements(), ResourceDoclet.class.getClassLoader());
            Thread.currentThread().setContextClassLoader(ncl);
            DocProcessorWrapper docProcessor = new DocProcessorWrapper();
            if (this.optionDocprocessor.getDocProcessors().length != 0) {
                try {
                    Class<?> clazz = Class.forName(this.optionDocprocessor.getDocProcessors()[0], true, Thread.currentThread().getContextClassLoader());
                    Class<DocProcessor> dpClazz = clazz.asSubclass(DocProcessor.class);
                    docProcessor.add((DocProcessor)dpClazz.getDeclaredConstructors()[0].newInstance(new Object[0]));
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Could not load docProcessors " + String.valueOf(Arrays.asList(this.optionDocprocessor.getDocProcessors())), e);
                }
            }
            ResourceDocType result = new ResourceDocType();
            for (TypeElement element : ElementFilter.typesIn(docEnv.getIncludedElements())) {
                DocTrees docTrees = docEnv.getDocTrees();
                DocCommentTree docCommentTree = docTrees.getDocCommentTree(element);
                if (docCommentTree == null) continue;
                ClassDocType classDocType = new ClassDocType();
                classDocType.setClassName(element.getQualifiedName().toString());
                classDocType.setCommentText(this.getComments(docCommentTree));
                docProcessor.processClassDocWithDocEnv(element, classDocType, docEnv);
                for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
                    Map<DocTree.Kind, Map<String, String>> tags = this.getTags(docTrees.getDocCommentTree(method));
                    MethodTree methodTree = docTrees.getTree(method);
                    MethodDocType methodDocType = new MethodDocType();
                    if (methodTree != null) {
                        methodDocType.setMethodName(methodTree.getName().toString());
                        methodDocType.setCommentText(this.getComments(docTrees.getDocCommentTree(method)));
                    }
                    this.getTags(docTrees.getDocCommentTree(method));
                    StringBuilder arguments = new StringBuilder("(");
                    Map<String, String> paramTags = tags.get((Object)DocTree.Kind.PARAM);
                    for (VariableElement variableElement : method.getParameters()) {
                        ParamDocType paramDocType = this.buildParamDocType(variableElement, paramTags);
                        arguments.append(variableElement.asType()).append(COMA);
                        if (paramDocType == null) continue;
                        methodDocType.getParamDocs().add(paramDocType);
                        docProcessor.processParamTagWithDocEnv(variableElement, paramDocType, docEnv);
                    }
                    if (arguments.length() != 1) {
                        arguments.delete(arguments.length() - COMA.length(), arguments.length());
                    }
                    arguments.append(")");
                    methodDocType.setMethodSignature(arguments.toString());
                    docProcessor.processMethodDocWithDocEnv(method, methodDocType, docEnv);
                    methodDocType.setRequestDoc(this.buildRequestDocType(tags));
                    methodDocType.setResponseDoc(this.buildResponseDocType(tags));
                    classDocType.getMethodDocs().add(methodDocType);
                }
                result.getDocs().add(classDocType);
                success = DocletUtils.createOutputFile(this.optionOutput.getValue(), docProcessor, result);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return success;
    }

    private ParamDocType buildParamDocType(VariableElement parameter, Map<String, String> paramTags) {
        if (paramTags != null) {
            ParamDocType paramDocType = new ParamDocType();
            paramDocType.setParamName(parameter.getSimpleName().toString());
            paramDocType.setCommentText(paramTags.get(paramDocType.getParamName()));
            for (AnnotationMirror annotationMirror : parameter.getAnnotationMirrors()) {
                AnnotationDocType annotationDocType = new AnnotationDocType();
                annotationDocType.setAnnotationTypeName(annotationMirror.getAnnotationType().toString());
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> pair : annotationMirror.getElementValues().entrySet()) {
                    NamedValueType namedValueType = new NamedValueType();
                    namedValueType.setName(pair.getKey().getSimpleName().toString());
                    namedValueType.setValue(pair.getValue().getValue().toString());
                    annotationDocType.getAttributeDocs().add(namedValueType);
                }
                paramDocType.getAnnotationDocs().add(annotationDocType);
            }
            return paramDocType;
        }
        return null;
    }

    private RequestDocType buildRequestDocType(Map<DocTree.Kind, Map<String, String>> tags) {
        Map<String, String> customTags = tags.get((Object)DocTree.Kind.UNKNOWN_BLOCK_TAG);
        if (customTags != null) {
            RequestDocType requestDoc = new RequestDocType();
            RepresentationDocType representationDoc = new RepresentationDocType();
            String qname = customTags.get("@request.representation.qname");
            String example = customTags.get("@request.representation.example");
            if (qname != null) {
                representationDoc.setElement(QName.valueOf(qname));
            }
            if (example != null) {
                representationDoc.setExample(this.getSerializedExample(example));
            }
            if (qname != null || example != null) {
                requestDoc.setRepresentationDoc(representationDoc);
                return requestDoc;
            }
        }
        return null;
    }

    private ResponseDocType buildResponseDocType(Map<DocTree.Kind, Map<String, String>> tags) {
        Map<String, String> customTags;
        ResponseDocType responseDoc = new ResponseDocType();
        Map<String, String> returnDoc = tags.get((Object)DocTree.Kind.RETURN);
        if (returnDoc != null) {
            responseDoc.setReturnDoc(returnDoc.get("@return"));
        }
        if ((customTags = tags.get((Object)DocTree.Kind.UNKNOWN_BLOCK_TAG)) != null) {
            String responseParam = customTags.remove("@response.param");
            if (responseParam != null) {
                Matcher matcher = PATTERN_INLINE_TAG.matcher(responseParam);
                WadlParamType wadlParam = new WadlParamType();
                block12: while (matcher.find()) {
                    String group = matcher.group();
                    String[] pair = this.getTagPair(group);
                    switch (pair[0]) {
                        case "name": {
                            wadlParam.setName(pair[1]);
                            continue block12;
                        }
                        case "style": {
                            wadlParam.setStyle(pair[1]);
                            continue block12;
                        }
                        case "type": {
                            wadlParam.setType(QName.valueOf(pair[1]));
                            continue block12;
                        }
                        case "doc": {
                            wadlParam.setDoc(pair[1]);
                            continue block12;
                        }
                    }
                    LOG.warning("Unknown inline tag of @response.param: @" + pair[0] + " (value: " + pair[1] + ")");
                }
                responseDoc.getWadlParams().add(wadlParam);
            }
            HashMap<Long, RepresentationDocType> groupedRepresentationDocType = new HashMap<Long, RepresentationDocType>();
            for (Map.Entry<String, String> entry : customTags.entrySet()) {
                if (!entry.getKey().startsWith("@response.representation")) continue;
                String[] keySplit = entry.getKey().split("\\.");
                long httpCode = Long.parseLong(keySplit[2]);
                RepresentationDocType representationDoc = (RepresentationDocType)groupedRepresentationDocType.get(httpCode);
                if (representationDoc == null) {
                    representationDoc = new RepresentationDocType();
                    representationDoc.setStatus(Long.valueOf(httpCode));
                    groupedRepresentationDocType.put(httpCode, representationDoc);
                }
                if ("qname".equals(keySplit[3])) {
                    representationDoc.setElement(QName.valueOf(entry.getValue()));
                    continue;
                }
                if ("mediaType".equals(keySplit[3])) {
                    representationDoc.setMediaType(entry.getValue());
                    continue;
                }
                if ("example".equals(this.getSerializedExample(keySplit[3]))) {
                    representationDoc.setExample(this.getSerializedExample(entry.getValue()));
                    continue;
                }
                if ("doc".equals(keySplit[3])) {
                    representationDoc.setDoc(entry.getValue());
                    continue;
                }
                LOG.warning("Unknown response representation tag " + entry.getKey());
            }
            responseDoc.getRepresentations().addAll(groupedRepresentationDocType.values());
        }
        return responseDoc;
    }

    @Override
    public String getName() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public Set<? extends Doclet.Option> getSupportedOptions() {
        return new HashSet<Doclet.Option>(Arrays.asList(this.optionOutput, this.optionClasspath, this.optionDocprocessor));
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private String getSerializedExample(String tag) {
        Matcher matcher;
        if (tag != null && (matcher = PATTERN_INLINE_TAG.matcher(tag)).find()) {
            String group = matcher.group();
            String[] pair = this.getTagPair(group);
            if ("link".equals(pair[0])) {
                String[] classAndField = pair[1].split("#");
                return DocletUtils.getLinkClass(classAndField[0], classAndField[1]);
            }
            return pair[1];
        }
        return tag;
    }
}

