/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.oauth2;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import org.glassfish.jersey.client.oauth2.AuthCodeGrantImpl;
import org.glassfish.jersey.client.oauth2.ClientIdentifier;
import org.glassfish.jersey.client.oauth2.OAuth2CodeGrantFlow;
import org.glassfish.jersey.client.oauth2.TokenResult;
import org.glassfish.jersey.message.internal.ReaderWriter;

class OAuth2FlowFacebookBuilder {
    OAuth2FlowFacebookBuilder() {
    }

    public static OAuth2CodeGrantFlow.Builder getFacebookAuthorizationBuilder(ClientIdentifier clientIdentifier, String redirectUri, Client client) {
        AuthCodeGrantImpl.Builder builder = new AuthCodeGrantImpl.Builder();
        builder.accessTokenUri("https://graph.facebook.com/oauth/access_token");
        builder.authorizationUri("https://www.facebook.com/dialog/oauth");
        builder.redirectUri(redirectUri);
        builder.clientIdentifier(clientIdentifier);
        client.register(FacebookTokenMessageBodyReader.class);
        builder.client(client);
        return builder;
    }

    @Consumes(value={"text/plain"})
    static class FacebookTokenMessageBodyReader
    implements MessageBodyReader<TokenResult> {
        FacebookTokenMessageBodyReader() {
        }

        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return type.equals(TokenResult.class);
        }

        public TokenResult readFrom(Class<TokenResult> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            String[] splitArray;
            HashMap<String, Object> map = new HashMap<String, Object>();
            String str = ReaderWriter.readFromAsString((InputStream)entityStream, (MediaType)mediaType);
            for (String s : splitArray = str.split("&")) {
                String[] keyValue = s.split("=");
                map.put(keyValue[0], keyValue[1]);
            }
            return new TokenResult(map);
        }
    }
}

