/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class UpgradeService
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Domain domain;
    @Inject
    @Named(value="gmsupgrade")
    @Optional
    ConfigurationUpgrade precondition = null;
    private static final Logger logger = Logger.getAnonymousLogger();
    private static final String MODULE_TYPE = "moduleType";
    private static final String APPCLIENT_SNIFFER_NAME = "appclient";
    private static final String V3_0_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME = "javaWebStartEnabled";
    private static final String GF3_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME = "java-web-start-enabled";

    public void postConstruct() {
        this.upgradeApplicationElements();
    }

    private void upgradeApplicationElements() {
        this.upgradeV3PreludeApplicationElements();
        this.upgradeV3_0_1_AppClientElements();
    }

    private void upgradeV3PreludeApplicationElements() {
        ArrayList allApps = new ArrayList();
        allApps.addAll(this.domain.getApplications().getApplications());
        allApps.addAll(this.domain.getSystemApplications().getApplications());
        for (Application app : allApps) {
            if (app.getEngine() == null || app.getEngine().size() <= 0 || app.getModule() != null && app.getModule().size() != 0) continue;
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Application>(){

                    public Object run(Application application) throws PropertyVetoException, TransactionFailure {
                        Module module = (Module)application.createChild(Module.class);
                        module.setName(application.getName());
                        for (Engine engine : application.getEngine()) {
                            module.getEngines().add(engine);
                        }
                        application.getModule().add(module);
                        application.getEngine().clear();
                        return null;
                    }
                }, (ConfigBeanProxy)app);
            }
            catch (TransactionFailure tf) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading application " + app.getName() + " please redeploy", tf);
                throw new RuntimeException(tf);
            }
        }
    }

    private <T extends PropertyBag & ConfigBeanProxy> Property addProperty(String propName, String propValue, T owner_w) throws TransactionFailure, PropertyVetoException {
        Property p = (Property)((ConfigBeanProxy)owner_w).createChild(Property.class);
        p.setName(propName);
        p.setValue(propValue);
        owner_w.getProperty().add(p);
        return p;
    }

    private void upgradeV3_0_1_AppClientElements() {
        Transaction t = new Transaction();
        try {
            for (Application app : this.domain.getApplications().getApplications()) {
                System.out.println("Checking app " + app.getName());
                Application app_w = null;
                Property oldSetting = app.getProperty(V3_0_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME);
                if (oldSetting != null) {
                    logger.log(Level.INFO, "For application {0} converting property {1} to {2}", new Object[]{app.getName(), V3_0_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME, GF3_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME});
                    app_w = (Application)t.enroll((ConfigBeanProxy)app);
                    this.addProperty(GF3_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME, oldSetting.getValue(), app_w);
                    app_w.getProperty().remove(oldSetting);
                }
                for (Module mod : app.getModule()) {
                    if (mod.getEngine(APPCLIENT_SNIFFER_NAME) == null || (oldSetting = mod.getProperty(V3_0_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME)) == null) continue;
                    logger.log(Level.INFO, "For application {0}/module {1} converting property {2} to {3}", new Object[]{app.getName(), mod.getName(), V3_0_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME, GF3_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME});
                    Module mod_w = (Module)t.enroll((ConfigBeanProxy)mod);
                    this.addProperty(GF3_1_JAVA_WEB_START_ENABLED_PROPERTY_NAME, oldSetting.getValue(), mod_w);
                    mod_w.getProperty().remove(oldSetting);
                }
            }
            t.commit();
        }
        catch (Exception ex) {
            t.rollback();
            throw new RuntimeException("Error upgrading application", ex);
        }
    }
}

