/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote;

import com.sun.enterprise.admin.event.AdminCommandEventBrokerImpl;
import com.sun.enterprise.admin.remote.Header;
import com.sun.enterprise.admin.remote.Metrix;
import com.sun.enterprise.admin.remote.RestPayloadImpl;
import com.sun.enterprise.admin.remote.reader.ActionReportJsonReader;
import com.sun.enterprise.admin.remote.reader.AdminCommandStateJsonReader;
import com.sun.enterprise.admin.remote.reader.CliActionReport;
import com.sun.enterprise.admin.remote.reader.ProgressStatusDTOJsonReader;
import com.sun.enterprise.admin.remote.reader.ProgressStatusEventJsonReader;
import com.sun.enterprise.admin.remote.sse.GfSseEventReceiver;
import com.sun.enterprise.admin.remote.sse.GfSseEventReceiverReader;
import com.sun.enterprise.admin.remote.sse.GfSseInboundEvent;
import com.sun.enterprise.admin.remote.writer.ParameterMapFormWriter;
import com.sun.enterprise.admin.remote.writer.PayloadPartProvider;
import com.sun.enterprise.admin.util.AsadminTrustManager;
import com.sun.enterprise.admin.util.AuthenticationInfo;
import com.sun.enterprise.admin.util.CachedCommandModel;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.admin.util.HttpConnectorAddress;
import com.sun.enterprise.admin.util.cache.AdminCacheUtils;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.net.NetUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.payload.PayloadFilesManager;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.AuthenticationException;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.InvalidCommandException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.common.util.admin.AuthTokenManager;
import org.glassfish.jersey.client.JerseyClientFactory;
import org.glassfish.jersey.client.SslConfig;
import org.glassfish.jersey.client.filter.CsrfProtectionFilter;
import org.glassfish.jersey.client.filter.HttpBasicAuthFilter;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.sse.SseFeature;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RemoteRestAdminCommand
extends AdminCommandEventBrokerImpl<GfSseInboundEvent> {
    private static final LocalStringsImpl strings = new LocalStringsImpl(RemoteRestAdminCommand.class);
    private static final String EOL = StringUtils.EOL;
    private static final String QUERY_STRING_INTRODUCER = "?";
    private static final String QUERY_STRING_SEPARATOR = "&";
    private static final String ADMIN_URI_PATH = "/__asadmin/";
    private static final String COMMAND_NAME_REGEXP = "^[a-zA-Z_][-a-zA-Z0-9_]*$";
    private static final String READ_TIMEOUT = "AS_ADMIN_READTIMEOUT";
    public static final String COMMAND_MODEL_MATCH_HEADER = "X-If-Command-Model-Match";
    private static final MediaType MEDIATYPE_ACTIONREPORT = new MediaType("application", "json", (Map)new HashMap<String, String>(1){
        {
            this.put("q", "0.8");
        }
    });
    private static final MediaType MEDIATYPE_MULTIPART = new MediaType("multipart", null, (Map)new HashMap<String, String>(1){
        {
            this.put("q", "0.9");
        }
    });
    private static final int defaultReadTimeout;
    private Client client;
    private String responseFormatType = "hk2-agent";
    private OutputStream userOut;
    protected String output;
    private ActionReport actionReport;
    private boolean doUpload = false;
    private boolean addedUploadOption = false;
    private RestPayloadImpl.Outbound outboundPayload;
    private String usage;
    private File fileOutputDir;
    protected String name;
    protected String host;
    private String canonicalHostCache;
    protected int port;
    protected boolean secure;
    protected String user;
    protected String password;
    protected Logger logger;
    protected String scope;
    protected String authToken = null;
    protected boolean prohibitDirectoryUploads = false;
    protected ParameterMap options;
    protected List<String> operands;
    private CommandModel commandModel;
    private boolean commandModelFromCache = false;
    private StringBuilder metadataErrors;
    private int readTimeout = defaultReadTimeout;
    private int connectTimeout = -1;
    private boolean interactive = true;
    private boolean omitCache = true;
    private List<Header> requestHeaders = new ArrayList<Header>();
    private boolean closeSse = false;
    private static final String FILE_PAYLOAD_MIME_TYPE = "application/octet-stream";

    public RemoteRestAdminCommand(String name, String host, int port) throws CommandException {
        this(name, host, port, false, "admin", null, Logger.getAnonymousLogger());
    }

    public RemoteRestAdminCommand(String name, String host, int port, boolean secure, String user, String password, Logger logger) throws CommandException {
        this(name, host, port, secure, user, password, logger, null, null, false);
    }

    public RemoteRestAdminCommand(String name, String host, int port, boolean secure, String user, String password, Logger logger, String scope, String authToken, boolean prohibitDirectoryUploads) throws CommandException {
        Metrix.event("RemoteRestAdminCommand constructed");
        this.name = name;
        this.host = host;
        this.port = port;
        this.secure = secure;
        this.user = user;
        this.password = password;
        this.logger = logger;
        this.scope = scope != null && scope.endsWith("/") ? scope.substring(0, scope.length() - 1) : scope;
        this.authToken = authToken;
        this.prohibitDirectoryUploads = prohibitDirectoryUploads;
        this.checkName();
    }

    private void checkName() throws CommandException {
        if (!this.name.matches(COMMAND_NAME_REGEXP)) {
            throw new CommandException("Illegal command name: " + this.name);
        }
    }

    public void closeSse(String message, ActionReport.ExitCode exitCode) {
        CliActionReport report = new CliActionReport();
        report.setMessage(message);
        report.setActionExitCode(exitCode);
        this.setActionReport(report);
        this.closeSse = true;
    }

    public void setResponseFormatType(String responseFormatType) {
        this.responseFormatType = responseFormatType;
    }

    public void setUserOut(OutputStream userOut) {
        this.userOut = userOut;
    }

    public void setCommandModel(CommandModel commandModel) {
        this.commandModel = commandModel;
        this.commandModelFromCache = false;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public static int getReadTimeout() {
        return defaultReadTimeout;
    }

    public ActionReport getActionReport() {
        return this.actionReport;
    }

    public String findPropertyInReport(String key) {
        if (this.actionReport == null) {
            return null;
        }
        return this.actionReport.findProperty(key);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setInteractive(boolean state) {
        this.interactive = state;
    }

    public void setOmitCache(boolean omitCache) {
        this.omitCache = omitCache;
    }

    public CommandModel getCommandModel() throws CommandException {
        block8: {
            Metrix.event("getCommandModel() - start");
            if (this.commandModel == null) {
                long startNanos = System.nanoTime();
                try {
                    this.commandModel = this.getCommandModelFromCache();
                    if (this.commandModel != null) {
                        this.commandModelFromCache = true;
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.log(Level.FINEST, "Command model for command {0} was successfully loaded from the cache. [Duration: {1} nanos]", new Object[]{this.name, System.nanoTime() - startNanos});
                        }
                    } else if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.log(Level.FINEST, "Command model for command {0} is not in cache. It must be fatched from server.", this.name);
                    }
                }
                catch (Exception ex) {
                    if (!this.logger.isLoggable(Level.FINEST)) break block8;
                    this.logger.log(Level.FINEST, "Can not get data from cache under key " + this.createCommandCacheKey(), ex);
                }
            }
        }
        if (this.commandModel == null) {
            this.fetchCommandModel();
        }
        Metrix.event("getCommandModel() - done");
        return this.commandModel;
    }

    private CommandModel getCommandModelFromCache() {
        Metrix.event("getCommandModelFromCahce() - start");
        String cachedModel = AdminCacheUtils.getCache().get(this.createCommandCacheKey(), String.class);
        if (cachedModel == null) {
            Metrix.event("getCommandModelFromCahce() - done");
            return null;
        }
        int ind = (cachedModel = cachedModel.trim()).indexOf(10);
        if (ind < 0) {
            Metrix.event("getCommandModelFromCahce() - done");
            return null;
        }
        String eTag = cachedModel.substring(0, ind);
        if (!eTag.startsWith("ETag:")) {
            Metrix.event("getCommandModelFromCahce() - done");
            return null;
        }
        eTag = eTag.substring(5).trim();
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "Cached command model ETag is {0}", eTag);
        }
        String content = cachedModel.substring(ind + 1).trim();
        CachedCommandModel result = this.parseMetadata(content, eTag);
        Metrix.event("getCommandModelFromCahce() - done");
        return result;
    }

    public boolean isCommandModelFromCache() {
        return this.commandModelFromCache;
    }

    public void setFileOutputDirectory(File dir) {
        this.fileOutputDir = dir;
    }

    public List<Header> headers() {
        return this.requestHeaders;
    }

    protected boolean useSse() throws CommandException {
        return this.getCommandModel().isManagedJob();
    }

    public String executeCommand(ParameterMap opts) throws CommandException {
        boolean retry;
        Metrix.event("executeCommand() - start");
        if (opts != null && opts.size() == 1 && opts.containsKey((Object)"help")) {
            Metrix.event("executeCommand() - done");
            return this.getManPage();
        }
        do {
            retry = false;
            try {
                ParameterMap preparedParams = this.processParams(opts);
                MediaType[] acceptMediaTypes = new MediaType[]{MEDIATYPE_MULTIPART, MEDIATYPE_ACTIONREPORT};
                if (this.useSse()) {
                    acceptMediaTypes = new MediaType[]{SseFeature.SERVER_SENT_EVENTS_TYPE};
                }
                Response response = this.doRestCommand(preparedParams, null, "POST", false, acceptMediaTypes);
                MediaType resultMediaType = response.getMediaType();
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Result type is {0}", resultMediaType);
                }
                if (MEDIATYPE_ACTIONREPORT.isCompatible(resultMediaType)) {
                    this.setActionReport((ActionReport)response.readEntity(ActionReport.class));
                    continue;
                }
                if (MEDIATYPE_MULTIPART.isCompatible(resultMediaType)) {
                    MultiPart mp = (MultiPart)response.readEntity(MultiPart.class);
                    RestPayloadImpl.Inbound inbound = new RestPayloadImpl.Inbound();
                    this.setActionReport(RestPayloadImpl.Inbound.fillFromMultipart(mp, inbound, this.logger));
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.log(Level.FINER, "------ PAYLOAD ------");
                        Iterator<Payload.Part> parts = inbound.parts();
                        while (parts.hasNext()) {
                            Payload.Part part = parts.next();
                            this.logger.log(Level.FINER, " - {0} [{1}]", new Object[]{part.getName(), part.getContentType()});
                        }
                        this.logger.log(Level.FINER, "---- END PAYLOAD ----");
                    }
                    PayloadFilesManager.Perm downloadedFilesMgr = new PayloadFilesManager.Perm(this.fileOutputDir, null, this.logger, null);
                    try {
                        downloadedFilesMgr.processParts((Payload.Inbound)inbound);
                        continue;
                    }
                    catch (CommandException cex) {
                        throw cex;
                    }
                    catch (Exception ex) {
                        throw new CommandException(ex.getMessage(), (Throwable)ex);
                    }
                }
                if (SseFeature.SERVER_SENT_EVENTS_TYPE.isCompatible(resultMediaType)) {
                    try {
                        GfSseInboundEvent event;
                        this.logger.log(Level.FINEST, "Response is SSE - about to read events");
                        this.closeSse = false;
                        GfSseEventReceiver eventReceiver = (GfSseEventReceiver)response.readEntity(GfSseEventReceiver.class);
                        String instanceId = null;
                        do {
                            if ((event = eventReceiver.readEvent()) == null) continue;
                            if (this.logger.isLoggable(Level.FINEST)) {
                                this.logger.log(Level.FINEST, "Event: {0}", event.getName());
                            }
                            this.fireEvent(event.getName(), event);
                            if (!"AdminCommandInstance/stateChanged".equals(event.getName())) continue;
                            AdminCommandState acs = event.getData(AdminCommandState.class, MediaType.APPLICATION_JSON_TYPE);
                            if (acs.getId() != null) {
                                instanceId = acs.getId();
                                if (this.logger.isLoggable(Level.FINEST)) {
                                    this.logger.log(Level.FINEST, "Command instance ID: {0}", instanceId);
                                }
                            }
                            if (acs.getState() != AdminCommandState.State.COMPLETED && acs.getState() != AdminCommandState.State.RECORDED) continue;
                            if (acs.getActionReport() != null) {
                                this.setActionReport(acs.getActionReport());
                            }
                            this.closeSse = true;
                            if (acs.isOutboundPayloadEmpty()) continue;
                            this.logger.log(Level.FINEST, "Romote command holds data. Must load it");
                            this.downloadPayloadFromManaged(instanceId);
                        } while (event != null && !eventReceiver.isClosed() && !this.closeSse);
                        if (this.closeSse) {
                            try {
                                eventReceiver.close();
                            }
                            catch (Exception exc) {}
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        throw new CommandException(ex.getMessage(), (Throwable)ex);
                    }
                }
                throw new CommandException(strings.get("unknownResponse", new Object[]{resultMediaType}));
            }
            catch (CommandValidationException mve) {
                if (this.refetchInvalidModel() && this.isCommandModelFromCache()) {
                    this.fetchCommandModel();
                    retry = true;
                    continue;
                }
                throw mve;
            }
        } while (retry);
        if (this.actionReport == null) {
            this.output = null;
            throw new CommandException(strings.get("emptyResponse"));
        }
        if (this.actionReport.getActionExitCode() == ActionReport.ExitCode.FAILURE) {
            throw new CommandException(strings.getString("remote.failure.prefix", "remote failure:") + " " + this.output);
        }
        Metrix.event("executeCommand() - done");
        return this.output;
    }

    private void downloadPayloadFromManaged(String jobId) {
        if (jobId == null) {
            return;
        }
        try {
            RemoteRestAdminCommand command = new RemoteRestAdminCommand("_get-payload", this.host, this.port, this.secure, this.user, this.password, this.logger, this.scope, this.authToken, this.prohibitDirectoryUploads);
            ParameterMap params = new ParameterMap();
            params.add((Object)"DEFAULT", (Object)jobId);
            command.executeCommand(params);
        }
        catch (CommandException ex) {
            this.logger.log(Level.WARNING, strings.getString("remote.sse.canNotGetPayload", "Cannot retrieve payload. {0}"), ex.getMessage());
        }
    }

    protected void setActionReport(ActionReport ar) {
        this.actionReport = ar;
        if (ar == null) {
            this.output = null;
        } else {
            StringBuilder sb = new StringBuilder();
            if (ar instanceof CliActionReport) {
                RemoteRestAdminCommand.addCombinedMessages((CliActionReport)ar, sb);
            } else if (ar.getMessage() != null) {
                sb.append(ar.getMessage());
            }
            RemoteRestAdminCommand.addSubMessages("", ar.getTopMessagePart(), sb);
            this.output = sb.toString();
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "------ ACTION REPORT ------");
                this.logger.log(Level.FINER, String.valueOf(this.actionReport));
                this.logger.log(Level.FINER, "---- END ACTION REPORT ----");
            }
        }
    }

    private static void addSubMessages(String indentPrefix, ActionReport.MessagePart mp, StringBuilder sb) {
        List children;
        if (mp == null || sb == null) {
            return;
        }
        if (indentPrefix == null) {
            indentPrefix = "";
        }
        if ((children = mp.getChildren()) != null) {
            for (ActionReport.MessagePart subPart : children) {
                if (sb.length() > 0) {
                    sb.append(EOL);
                }
                if (RemoteRestAdminCommand.ok(subPart.getMessage())) {
                    sb.append(subPart.getMessage());
                }
                RemoteRestAdminCommand.addSubMessages(indentPrefix + "    ", subPart, sb);
            }
        }
    }

    private static void addCombinedMessages(CliActionReport aReport, StringBuilder sb) {
        if (aReport == null || sb == null) {
            return;
        }
        String mainMsg = "";
        if (aReport.getMessage() != null && aReport.getMessage().length() != 0) {
            if (sb.length() > 0) {
                sb.append(EOL);
            }
            sb.append(aReport.getMessage());
        }
        if (aReport.getFailureCause() != null && aReport.getFailureCause().getMessage() != null && aReport.getFailureCause().getMessage().length() != 0) {
            String failMsg = aReport.getFailureCause().getMessage();
            if (!failMsg.equals(mainMsg) && sb.length() > 0) {
                sb.append(EOL);
            }
            sb.append(failMsg);
        }
        for (CliActionReport sub : aReport.getSubActionsReport()) {
            RemoteRestAdminCommand.addCombinedMessages(sub, sb);
        }
    }

    public ParameterMap processParams(ParameterMap opts) throws CommandException {
        if (opts == null) {
            opts = new ParameterMap();
        }
        this.getCommandModel();
        this.options = new ParameterMap();
        for (Map.Entry o : opts.entrySet()) {
            String key = (String)o.getKey();
            List value = (List)o.getValue();
            this.options.set((Object)key.toLowerCase(Locale.ENGLISH), (Collection)value);
        }
        this.operands = this.options.get((Object)"default");
        try {
            this.initializeDoUpload();
            if (this.doUpload) {
                this.outboundPayload = new RestPayloadImpl.Outbound(true);
            }
            ParameterMap result = new ParameterMap();
            CommandModel.ParamModel operandParam = null;
            for (CommandModel.ParamModel opt : this.commandModel.getParameters()) {
                String envValue;
                if (opt.getParam().primary()) {
                    operandParam = opt;
                    continue;
                }
                String paramName = opt.getName();
                ArrayList<String> paramValues = new ArrayList<String>(this.options.get((Object)paramName.toLowerCase(Locale.ENGLISH)));
                if (!opt.getParam().alias().isEmpty() && !paramName.equalsIgnoreCase(opt.getParam().alias())) {
                    paramValues.addAll(this.options.get((Object)opt.getParam().alias().toLowerCase(Locale.ENGLISH)));
                }
                if (!opt.getParam().multiple() && paramValues.size() > 1) {
                    throw new CommandException(strings.get("tooManyOptions", new Object[]{paramName}));
                }
                if (paramValues.isEmpty() && (envValue = this.getFromEnvironment(paramName)) != null) {
                    paramValues.add(envValue);
                }
                if (paramValues.isEmpty()) {
                    if (opt.getParam().optional()) continue;
                    throw new CommandException(strings.get("missingOption", new Object[]{paramName}));
                }
                for (String paramValue : paramValues) {
                    if (opt.getType() == File.class || opt.getType() == File[].class) {
                        this.addFileOption(result, paramName, paramValue);
                        continue;
                    }
                    if (opt.getParam().password()) {
                        this.addPasswordOption(result, paramName, paramValue);
                        continue;
                    }
                    this.addStringOption(result, paramName, paramValue);
                }
            }
            for (String operand : this.operands) {
                if (operandParam.getType() == File.class || operandParam.getType() == File[].class) {
                    this.addFileOption(result, "DEFAULT", operand);
                    continue;
                }
                this.addStringOption(result, "DEFAULT", operand);
            }
            return result;
        }
        catch (IOException ioex) {
            throw new CommandException("I/O Error", (Throwable)ioex);
        }
    }

    protected boolean updateAuthentication() {
        return false;
    }

    protected boolean refetchInvalidModel() {
        return true;
    }

    protected String getFromEnvironment(String name) {
        return null;
    }

    protected boolean retryUsingSecureConnection(String host, int port) {
        return false;
    }

    protected String reportAuthenticationException() {
        return strings.get("InvalidCredentials", new Object[]{this.user});
    }

    private URI createURI(boolean secure, String pathSufix) throws CommandException {
        StringBuilder path = new StringBuilder("/command/");
        if (RemoteRestAdminCommand.ok(this.scope)) {
            path.append(this.scope).append('/');
        }
        path.append(this.name);
        if (RemoteRestAdminCommand.ok(pathSufix)) {
            if (!pathSufix.startsWith("/")) {
                path.append('/');
            }
            path.append(pathSufix);
        }
        try {
            return new URI(secure ? "https" : "http", null, this.host, this.port, path.toString(), null, null);
        }
        catch (URISyntaxException e) {
            throw new CommandException(strings.get("internal", new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    private static Client createClient() {
        Client c = JerseyClientFactory.newClient();
        ((Client)((Client)((Client)((Client)((Client)((Client)((Client)((Client)c.register((Object)new MultiPartFeature())).register((Object)new CsrfProtectionFilter("CLI"))).register((Object)new ActionReportJsonReader())).register((Object)new ParameterMapFormWriter())).register((Object)new PayloadPartProvider())).register((Object)new AdminCommandStateJsonReader())).register((Object)new ProgressStatusDTOJsonReader())).register((Object)new ProgressStatusEventJsonReader())).register(GfSseEventReceiverReader.class);
        return c;
    }

    private WebTarget createTarget(URI uri) {
        if (this.client == null) {
            this.client = RemoteRestAdminCommand.createClient();
        }
        return this.client.target(uri);
    }

    private Response doRestCommand(ParameterMap options, String pathSufix, String method, boolean isForMetadata, MediaType ... acceptedResponseTypes) throws CommandException {
        boolean shouldTryCommandAgain;
        Metrix.event("doRestCommand() - start");
        boolean askedUserForCredentials = false;
        boolean shouldUseSecure = this.secure;
        boolean usedCallerProvidedCredentials = this.secure;
        URI uri = this.createURI(shouldUseSecure, pathSufix);
        do {
            Metrix.event("doRestCommand() - about to create target");
            WebTarget target = this.createTarget(uri);
            Metrix.event("doRestCommand() - about to configure security");
            target.setProperty("jersey.config.client.ssl.sslConfig", (Object)new SslConfig((HostnameVerifier)new HttpConnectorAddress.BasicHostnameVerifier(this.host), this.getSslContext()));
            shouldTryCommandAgain = false;
            try {
                Response response;
                AuthenticationInfo authInfo;
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "URI: {0}", uri.toString());
                    this.logger.log(Level.FINER, "Using auth info: User: {0}, Password: {1}", new Object[]{this.user, RemoteRestAdminCommand.ok(this.password) ? "<non-null>" : "<null>"});
                }
                if ((authInfo = this.authenticationInfo()) != null) {
                    HttpBasicAuthFilter besicAuth = new HttpBasicAuthFilter(authInfo.getUser(), authInfo.getPassword() == null ? "" : authInfo.getPassword());
                    target.register((Object)besicAuth);
                }
                Metrix.event("doRestCommand() - about to prepare request builder");
                Invocation.Builder request = target.request(acceptedResponseTypes);
                Metrix.event("doRestCommand() - about to add headers");
                if (this.authToken != null) {
                    request = request.header("X-GlassFish-authToken", (Object)(isForMetadata ? AuthTokenManager.markTokenForReuse((String)this.authToken) : this.authToken));
                }
                if (this.commandModel != null && this.isCommandModelFromCache() && this.commandModel instanceof CachedCommandModel) {
                    request = request.header(COMMAND_MODEL_MATCH_HEADER, (Object)((CachedCommandModel)this.commandModel).getETag());
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.log(Level.FINER, "CommandModel ETag: {0}", ((CachedCommandModel)this.commandModel).getETag());
                    }
                }
                for (Header h : this.requestHeaders) {
                    request = request.header(h.getName(), (Object)h.getValue());
                }
                request = this.addAdditionalHeaders(request);
                if (this.logger.isLoggable(Level.FINER)) {
                    request = request.header("X-Indent", (Object)"true");
                }
                Invocation invoc = null;
                Metrix.event("doRestCommand() - about to prepare invocation");
                if ("POST".equals(method)) {
                    if (this.outboundPayload != null && this.outboundPayload.size() > 0) {
                        FormDataMultiPart mp = new FormDataMultiPart();
                        for (Map.Entry entry : options.entrySet()) {
                            String key = (String)entry.getKey();
                            for (String val : (List)entry.getValue()) {
                                mp.field(key, val);
                            }
                        }
                        this.outboundPayload.addToMultipart((MultiPart)mp, this.logger);
                        Entity entity = Entity.entity((Object)mp, (MediaType)mp.getMediaType());
                        invoc = request.build(method, entity);
                    } else {
                        Entity entity = Entity.entity((Object)options, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
                        invoc = request.build(method, entity);
                    }
                } else {
                    invoc = request.build(method);
                }
                Metrix.event("doRestCommand() - about to invoke");
                try {
                    response = invoc.invoke();
                }
                catch (ClientException ex) {
                    if (ex.getCause() != null && ex.getCause() instanceof Exception) {
                        throw (Exception)ex.getCause();
                    }
                    throw ex;
                }
                Metrix.event("doRestCommand() - after invoke");
                String redirection = this.checkConnect(response, uri.getHost(), uri.getPort());
                if (RemoteRestAdminCommand.ok(redirection)) {
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.log(Level.FINER, "Following redirection to {0}", redirection);
                    }
                } else {
                    this.processHeaders(response);
                    this.logger.finer("doHttpCommand succeeds");
                    return response;
                }
                uri = new URI(redirection);
                shouldTryCommandAgain = true;
                shouldUseSecure = "https".equals(uri.getScheme());
                this.secure = true;
            }
            catch (AuthenticationException authEx) {
                this.logger.log(Level.FINER, "DAS has challenged for credentials");
                if (!usedCallerProvidedCredentials) {
                    this.logger.log(Level.FINER, "Have not tried caller-supplied credentials yet; will do that next");
                    usedCallerProvidedCredentials = true;
                    shouldTryCommandAgain = true;
                    continue;
                }
                this.logger.log(Level.FINER, "Already used caller-supplied credentials");
                if (askedUserForCredentials) {
                    this.logger.log(Level.FINER, "Already tried with updated credentials; cannot authenticate");
                    throw authEx;
                }
                this.logger.log(Level.FINER, "Have not yet tried to update credentials, so will try to update them");
                if (!this.updateAuthentication()) {
                    this.logger.log(Level.FINER, "Could not update credentials; cannot authenticate");
                    throw authEx;
                }
                this.logger.log(Level.FINER, "Was able to update the credentials so will retry with the updated ones");
                askedUserForCredentials = true;
                shouldTryCommandAgain = true;
            }
            catch (ConnectException ce) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "doHttpCommand: connect exception {0}", ce);
                }
                String msg = strings.get("ConnectException", new Object[]{this.host, this.port + ""});
                throw new CommandException(msg, (Throwable)ce);
            }
            catch (UnknownHostException he) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "doHttpCommand: host exception {0}", he);
                }
                String msg = strings.get("UnknownHostException", new Object[]{this.host});
                throw new CommandException(msg, (Throwable)he);
            }
            catch (SocketException se) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "doHttpCommand: socket exception {0}", se);
                }
                try {
                    boolean serverAppearsSecure = NetUtils.isSecurePort((String)this.host, (int)this.port);
                    if (!serverAppearsSecure || shouldUseSecure || !this.retryUsingSecureConnection(this.host, this.port)) {
                        throw new CommandException((Throwable)se);
                    }
                    shouldUseSecure = true;
                    usedCallerProvidedCredentials = true;
                    shouldTryCommandAgain = true;
                }
                catch (IOException io) {
                    throw new CommandException((Throwable)io);
                }
            }
            catch (SSLException se) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "doHttpCommand: SSL exception {0}", se);
                }
                try {
                    boolean serverAppearsSecure = NetUtils.isSecurePort((String)this.host, (int)this.port);
                    if (!serverAppearsSecure && this.secure) {
                        this.logger.log(Level.SEVERE, "NCLS-ADMIN-0010", new Object[]{this.host, this.port});
                    }
                    throw new CommandException((Throwable)se);
                }
                catch (IOException io) {
                    throw new CommandException((Throwable)io);
                }
            }
            catch (SocketTimeoutException e) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "doHttpCommand: read timeout {0}", e);
                }
                throw new CommandException(strings.get("ReadTimeout", new Object[]{Float.valueOf((float)this.readTimeout / 1000.0f)}), (Throwable)e);
            }
            catch (IOException e) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "doHttpCommand: IO exception {0}", e);
                }
                throw new CommandException(strings.get("IOError", new Object[]{e.getMessage()}), (Throwable)e);
            }
            catch (CommandException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "doHttpCommand: exception {0}", e);
                }
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(buf));
                this.logger.finer(buf.toString());
                throw new CommandException((Throwable)e);
            }
        } while (shouldTryCommandAgain);
        this.outboundPayload = null;
        return null;
    }

    protected SSLContext getSslContext() {
        return RemoteRestAdminCommand.createStandardSslContext(this.interactive);
    }

    protected static SSLContext createStandardSslContext(boolean interactive) {
        try {
            String protocol = "TLSv1";
            SSLContext cntxt = SSLContext.getInstance(protocol);
            AsadminTrustManager atm = new AsadminTrustManager();
            atm.setInteractive(interactive);
            cntxt.init(null, new TrustManager[]{atm}, null);
            return cntxt;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Invocation.Builder addAdditionalHeaders(Invocation.Builder request) {
        return request;
    }

    protected void processHeaders(Response headers) {
    }

    protected AuthenticationInfo authenticationInfo() {
        return this.user != null || this.password != null ? new AuthenticationInfo(this.user, this.password) : null;
    }

    private String checkConnect(Response response, String host, int port) throws IOException, CommandException {
        int code = response.getStatus();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "Response code: " + code);
        }
        if (code == -1) {
            throw new CommandException(strings.get("NotHttpResponse", new Object[]{host, port}));
        }
        if (code == 401) {
            throw new AuthenticationException(this.reportAuthenticationException());
        }
        if (code == 412) {
            throw new CommandValidationException("Code: 412: Cached CommandModel is invalid.");
        }
        if (code == 404) {
            throw new InvalidCommandException((String)response.readEntity(String.class));
        }
        if (this.isStatusRedirection(code)) {
            return response.getHeaderString("Location");
        }
        if (code != 200 && code != 500) {
            throw new CommandException(strings.get("BadResponse", new Object[]{String.valueOf(code), response.readEntity(String.class)}));
        }
        return null;
    }

    private boolean isStatusRedirection(int returnCode) {
        return returnCode == 302;
    }

    public String getUsage() {
        return this.usage;
    }

    private void addStringOption(ParameterMap params, String name, String option) {
        params.add((Object)name, (Object)option);
    }

    private void addPasswordOption(ParameterMap params, String name, String option) throws IOException {
        this.addStringOption(params, name, option);
    }

    private void addFileOption(ParameterMap params, String optionName, String filename) throws IOException, CommandException {
        boolean uploadThisFile;
        File f = SmartFile.sanitize((File)new File(filename));
        this.logger.finer("FILE PARAM: " + optionName + " = " + f);
        boolean bl = uploadThisFile = this.doUpload && !f.isDirectory();
        if (uploadThisFile) {
            this.logger.finer("Uploading file");
            try {
                this.outboundPayload.attachFile(FILE_PAYLOAD_MIME_TYPE, URI.create(optionName + "/" + f.getName() + (f.isDirectory() ? "/" : "")), optionName, null, f, true);
            }
            catch (FileNotFoundException fnfe) {
                throw new CommandException(strings.get("UploadedFileNotFound", new Object[]{f.getAbsolutePath()}));
            }
        }
        if (f != null) {
            String pathToPass = uploadThisFile ? f.getName() : f.getPath();
            this.addStringOption(params, optionName, pathToPass);
        }
    }

    public String getManPage() throws CommandException {
        this.logger.log(Level.FINEST, "getManPage()");
        Response res = this.doRestCommand(new ParameterMap(), "manpage", "GET", false, MediaType.TEXT_PLAIN_TYPE);
        if (res.getStatus() == 200) {
            return (String)res.readEntity(String.class);
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "get ManPege result status: {0}", res.getStatus());
        }
        throw new CommandException((String)res.readEntity(String.class));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fetchCommandModel() throws CommandException {
        block8: {
            Metrix.event("fetchCommandModel() - start");
            this.logger.log(Level.FINEST, "fetchCommandModel()");
            long startNanos = System.nanoTime();
            Response res = this.doRestCommand(new ParameterMap(), null, "GET", true, MediaType.APPLICATION_JSON_TYPE);
            if (res.getStatus() == 200) {
                EntityTag eTag;
                String str = (String)res.readEntity(String.class);
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.log(Level.FINEST, "Command model for {0} command fetched from remote server first part. [Duration: {1} nanos]", new Object[]{this.name, System.nanoTime() - startNanos});
                }
                this.commandModel = this.parseMetadata(str, (eTag = res.getEntityTag()) == null ? null : eTag.getValue());
                if (this.commandModel == null) {
                    Metrix.event("fetchCommandModel() - done");
                    throw new InvalidCommandException(strings.get("unknownError"));
                }
                this.commandModelFromCache = false;
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.log(Level.FINEST, "Command model for {0} command fetched from remote server. [Duration: {1} nanos]", new Object[]{this.name, System.nanoTime() - startNanos});
                }
                try {
                    StringBuilder forCache = new StringBuilder(str.length() + 40);
                    forCache.append("ETag: ").append(eTag == null ? "" : eTag.getValue());
                    forCache.append("\n");
                    forCache.append(str);
                    AdminCacheUtils.getCache().put(this.createCommandCacheKey(), forCache.toString());
                }
                catch (Exception ex) {
                    if (this.logger.isLoggable(Level.WARNING)) {
                        this.logger.log(Level.WARNING, "NCLS-ADMIN-0013", new Object[]{this.createCommandCacheKey()});
                    }
                    break block8;
                }
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Fatch command model result is {0}", res.getStatus());
            }
            Metrix.event("fetchCommandModel() - done");
            throw new InvalidCommandException(strings.get("unknownError"));
        }
        Metrix.event("fetchCommandModel() - done");
    }

    private String createCommandCacheKey() {
        StringBuilder result = new StringBuilder(this.getCanonicalHost().length() + this.name.length() + 12);
        result.append("cache/");
        result.append(this.getCanonicalHost()).append('_').append(this.port);
        result.append('/').append(this.name);
        return result.toString();
    }

    protected String getCanonicalHost() {
        block3: {
            if (this.canonicalHostCache == null) {
                try {
                    InetAddress address = InetAddress.getByName(this.host);
                    this.canonicalHostCache = address.getCanonicalHostName();
                }
                catch (UnknownHostException ex) {
                    this.canonicalHostCache = this.host;
                    if (this.canonicalHostCache == null) break block3;
                    this.canonicalHostCache = this.canonicalHostCache.trim().toLowerCase();
                }
            }
        }
        return this.canonicalHostCache;
    }

    private CachedCommandModel parseMetadata(String str, String etag) {
        Metrix.event("parseMetadata() = parse command model - start");
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("------- RAW METADATA RESPONSE ---------");
            this.logger.log(Level.FINER, "ETag: {0}", etag);
            this.logger.finer(str);
            this.logger.finer("------- RAW METADATA RESPONSE ---------");
        }
        if (str == null) {
            Metrix.event("parseMetadata() = parse command model - done");
            return null;
        }
        try {
            boolean sawFile = false;
            JSONObject obj = new JSONObject(str);
            obj = obj.getJSONObject("command");
            CachedCommandModel cm = new CachedCommandModel(obj.getString("@name"), etag);
            cm.dashOk = obj.optBoolean("@unknown-options-are-operands", false);
            cm.managedJob = obj.optBoolean("@managed-job", false);
            cm.setUsage(obj.optString("usage", null));
            Object optns = obj.opt("option");
            if (!JSONObject.NULL.equals(optns)) {
                JSONArray jsonOptions;
                if (optns instanceof JSONArray) {
                    jsonOptions = (JSONArray)optns;
                } else {
                    jsonOptions = new JSONArray();
                    jsonOptions.put(optns);
                }
                for (int i = 0; i < jsonOptions.length(); ++i) {
                    JSONObject jsOpt = jsonOptions.getJSONObject(i);
                    String type = jsOpt.getString("@type");
                    CommandModelData.ParamModelData opt = new CommandModelData.ParamModelData(jsOpt.getString("@name"), this.typeOf(type), jsOpt.optBoolean("@optional", false), jsOpt.optString("@default"), jsOpt.optString("@short"), jsOpt.optBoolean("@obsolete", false), jsOpt.optString("@alias"));
                    opt.param._acceptableValues = jsOpt.optString("@acceptable-values");
                    if ("PASSWORD".equals(type)) {
                        opt.param._password = true;
                        opt.prompt = jsOpt.optString("@prompt");
                        opt.promptAgain = jsOpt.optString("@prompt-again");
                    } else if ("FILE".equals(type)) {
                        sawFile = true;
                    }
                    if (jsOpt.optBoolean("@primary", false)) {
                        opt.param._primary = true;
                    }
                    if (jsOpt.optBoolean("@multiple", false)) {
                        opt.type = opt.type == File.class ? File[].class : List.class;
                        opt.param._multiple = true;
                    }
                    cm.add(opt);
                }
            }
            if (sawFile) {
                cm.add(new CommandModelData.ParamModelData("upload", Boolean.class, true, null));
                this.addedUploadOption = true;
                cm.setAddedUploadOption(true);
            }
            this.usage = cm.getUsage();
            Metrix.event("parseMetadata() = parse command model - done");
            return cm;
        }
        catch (JSONException ex) {
            this.logger.log(Level.FINER, "Can not parse command metadata", ex);
            Metrix.event("parseMetadata() = parse command model - done");
            return null;
        }
    }

    private Class<?> typeOf(String type) {
        if (type.equals("STRING")) {
            return String.class;
        }
        if (type.equals("BOOLEAN")) {
            return Boolean.class;
        }
        if (type.equals("FILE")) {
            return File.class;
        }
        if (type.equals("PASSWORD")) {
            return String.class;
        }
        if (type.equals("PROPERTIES")) {
            return Properties.class;
        }
        return String.class;
    }

    private static String getAttr(NamedNodeMap attributes, String name) {
        Node n = attributes.getNamedItem(name);
        if (n != null) {
            return n.getNodeValue();
        }
        return null;
    }

    private void initializeDoUpload() throws CommandException {
        boolean sawFile = false;
        boolean sawDirectory = false;
        boolean sawUploadableFile = false;
        for (Map.Entry param : this.options.entrySet()) {
            CommandModel.ParamModel opt;
            String paramName = (String)param.getKey();
            if (paramName.equals("DEFAULT") || (opt = this.commandModel.getModelFor(paramName)) == null || opt.getType() != File.class && opt.getType() != File[].class) continue;
            sawFile = true;
            for (String fname : this.options.get((Object)opt.getName())) {
                File optionFile = new File(fname);
                sawDirectory |= optionFile.isDirectory();
                sawUploadableFile |= optionFile.isFile();
            }
        }
        CommandModel.ParamModel operandParam = this.getOperandModel();
        if (operandParam != null && (operandParam.getType() == File.class || operandParam.getType() == File[].class)) {
            sawFile |= !this.operands.isEmpty();
            for (String operandValue : this.operands) {
                File operandFile = new File(operandValue);
                sawDirectory |= operandFile.isDirectory();
                sawUploadableFile |= operandFile.isFile();
            }
        }
        if (sawFile) {
            this.logger.finer("Saw a file parameter");
            String upString = this.getOption("upload");
            if (RemoteRestAdminCommand.ok(upString)) {
                this.doUpload = Boolean.parseBoolean(upString);
            } else {
                boolean bl = this.doUpload = !RemoteRestAdminCommand.isLocal(this.host) && sawUploadableFile;
            }
            if (this.prohibitDirectoryUploads && sawDirectory && this.doUpload) {
                this.logger.finer("--upload=" + upString + ", doUpload=" + this.doUpload);
                throw new CommandException(strings.get("CantUploadDirectory"));
            }
        }
        if (this.addedUploadOption) {
            this.logger.finer("removing --upload option");
            ParameterMap noptions = new ParameterMap();
            for (Map.Entry e : this.options.entrySet()) {
                if (((String)e.getKey()).equals("upload")) continue;
                noptions.set(e.getKey(), (Collection)e.getValue());
            }
            this.options = noptions;
        }
        this.logger.finer("doUpload set to " + this.doUpload);
    }

    private static boolean isLocal(String hostname) {
        if (hostname.equalsIgnoreCase("localhost")) {
            return true;
        }
        try {
            InetAddress ia = InetAddress.getByName(hostname);
            return NetUtils.isLocal((String)ia.getHostAddress());
        }
        catch (UnknownHostException ex) {
            return false;
        }
    }

    private CommandModel.ParamModel getOperandModel() {
        for (CommandModel.ParamModel pm : this.commandModel.getParameters()) {
            if (!pm.getParam().primary()) continue;
            return pm;
        }
        return null;
    }

    private String getOption(String name) {
        String def;
        CommandModel.ParamModel opt;
        String val = (String)this.options.getOne((Object)name);
        if (val == null) {
            val = this.getFromEnvironment(name);
        }
        if (val == null && (opt = this.commandModel.getModelFor(name)) != null && RemoteRestAdminCommand.ok(def = opt.getParam().defaultValue())) {
            val = def;
        }
        return val;
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    public static void preinit() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Client c = RemoteRestAdminCommand.createClient();
                    c.target("http://localhost:4848");
                }
                catch (Throwable th) {
                    // empty catch block
                }
                try {
                    RemoteRestAdminCommand.createStandardSslContext(System.console() != null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    static {
        Metrix.event("Initialize system properties");
        String rt = System.getProperty(READ_TIMEOUT);
        if (rt == null) {
            rt = System.getenv(READ_TIMEOUT);
        }
        defaultReadTimeout = rt != null ? Integer.parseInt(rt) : 600000;
    }
}

