/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote.sse;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import org.glassfish.jersey.message.MessageBodyWorkers;

public class GfSseInboundEvent {
    private String name = null;
    private String id = null;
    private ByteArrayOutputStream data = null;
    private final MessageBodyWorkers messageBodyWorkers;
    private final Annotation[] annotations;
    private final MediaType mediaType;
    private final MultivaluedMap<String, String> headers;

    GfSseInboundEvent(MessageBodyWorkers messageBodyWorkers, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers) {
        this.messageBodyWorkers = messageBodyWorkers;
        this.annotations = annotations;
        this.mediaType = mediaType;
        this.headers = headers;
    }

    void setName(String name) {
        this.name = name;
    }

    void setId(String id) {
        this.id = id;
    }

    void addData(byte[] data) {
        if (this.data == null) {
            this.data = new ByteArrayOutputStream();
        }
        try {
            this.data.write(data);
        }
        catch (IOException e) {
            this.data = null;
        }
    }

    boolean isEmpty() {
        return this.data == null;
    }

    public String getName() {
        return this.name;
    }

    public <T> T getData(Class<T> messageType) throws IOException {
        return this.getData(messageType, null);
    }

    public <T> T getData(Class<T> messageType, MediaType mediaType) throws IOException {
        MessageBodyReader messageBodyReader = this.messageBodyWorkers.getMessageBodyReader(messageType, null, this.annotations, mediaType);
        return (T)messageBodyReader.readFrom(messageType, null, this.annotations, mediaType == null ? this.mediaType : mediaType, this.headers, (InputStream)new ByteArrayInputStream(this.stripLastLineBreak(this.data.toByteArray())));
    }

    public String getData() throws IOException {
        return this.getData(String.class);
    }

    public String toString() {
        String s;
        try {
            s = this.getData();
        }
        catch (IOException e) {
            s = "";
        }
        return "InboundEvent{name='" + this.name + '\'' + ", id='" + this.id + '\'' + ", data=" + s + '}';
    }

    private byte[] stripLastLineBreak(byte[] data) {
        if (data.length >= 1 && data[data.length - 1] == 10) {
            byte[] newArray = new byte[data.length - 1];
            System.arraycopy(data, 0, newArray, 0, data.length - 1);
            data = newArray;
        }
        return data;
    }
}

