/*
 * Copyright (c) 2012, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.enterprise.config.modularity.annotation;

import javax.inject.Qualifier;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Contract annotation to mark any config bean which accepts customization values during domain creation.
 * For example the com.sun.enterprise.connectors.jms.config.JmsService need a port number for the default JmsHost.
 * Although the JmsService or any other config bean of that sort will carry some default values for the port numbers
 * but this contract makes it easy to locate and query all config beans that has the accept customization during domain
 * creation to be located and later on queried for the SystemProperties they need.
 *
 * @author Masoud Kalali
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Qualifier
public @interface CustomConfiguration {

    String baseConfigurationFileName();

    boolean usesOnTheFlyConfigGeneration() default false;
}
