/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.jndi;

import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.glassfish.admin.monitor.MLogger;

public class JndiNameLookupHelper {
    private InitialContext context;
    private static final Logger logger = MLogger.getLogger();
    private static final StringManager sm = StringManager.getManager(JndiNameLookupHelper.class);
    private final String SYSTEM_SUBCONTEXT = "__SYSTEM";

    public JndiNameLookupHelper() {
        this.initialize();
    }

    void initialize() {
        try {
            this.context = new InitialContext();
        }
        catch (NamingException e) {
            logger.log(Level.WARNING, "MNTG0000", e);
        }
    }

    public ArrayList<String> getJndiEntriesByContextPath(String contextPath) throws NamingException {
        NamingEnumeration<NameClassPair> ee;
        if (contextPath == null) {
            contextPath = "";
        }
        try {
            ee = this.context.list(contextPath);
        }
        catch (NameNotFoundException e) {
            String msg = sm.getString("monitor.jndi.context_notfound", new Object[]{contextPath});
            logger.log(Level.WARNING, msg);
            throw new NamingException(msg);
        }
        ArrayList<String> names = this.toNameClassPairArray(ee);
        return names;
    }

    ArrayList<String> toNameClassPairArray(NamingEnumeration ee) throws NamingException {
        ArrayList<String> names = new ArrayList<String>();
        while (ee.hasMore()) {
            Object o = ee.next();
            if (o.toString().indexOf("__SYSTEM") != -1) continue;
            names.add(o.toString());
        }
        return names;
    }
}

