/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.inbound;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.inbound.ActiveInboundResourceAdapter;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.util.RARUtils;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.connectors.util.SetMethodAction;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.transaction.spi.RecoveryResourceHandler;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.transaction.xa.XAResource;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class InboundRecoveryHandler
implements RecoveryResourceHandler {
    @Inject
    private Applications deployedApplications;
    @Inject
    private ApplicationRegistry appsRegistry;
    @Inject
    private Habitat connectorRuntimeHabitat;
    private static Logger _logger = LogDomains.getLogger(InboundRecoveryHandler.class, (String)"javax.enterprise.resource.resourceadapter");

    public void loadXAResourcesAndItsConnections(List xaresList, List connList) {
        Vector<XAResource> xaResources = new Vector<XAResource>();
        this.recoverInboundTransactions(xaResources);
    }

    public void closeConnections(List connList) {
    }

    private void recoverInboundTransactions(List<XAResource> xaresList) {
        List applications = this.deployedApplications.getApplications();
        try {
            _logger.log(Level.INFO, "Recovery of Inbound Transactions started.");
            if (applications.size() == 0) {
                _logger.log(Level.FINE, "No applications deployed.");
                return;
            }
            ArrayList<EjbDescriptor> xaEnabledMDBList = new ArrayList<EjbDescriptor>();
            for (com.sun.enterprise.config.serverbeans.Application application : applications) {
                Vector ejbDescVec = this.getEjbDescriptors(application, this.appsRegistry);
                for (int j = 0; j < ejbDescVec.size(); ++j) {
                    EjbDescriptor desc = (EjbDescriptor)ejbDescVec.elementAt(j);
                    if (!(desc instanceof EjbMessageBeanDescriptor) || !desc.getTransactionType().equals("Container")) continue;
                    xaEnabledMDBList.add(desc);
                    _logger.log(Level.FINE, "Found a CMT MDB: " + desc.getEjbClassName());
                }
            }
            if (xaEnabledMDBList.size() == 0) {
                _logger.log(Level.FINE, "Found no CMT MDBs in all applications");
                return;
            }
            ConnectorRuntime cr = (ConnectorRuntime)this.connectorRuntimeHabitat.getComponent(ConnectorRuntime.class);
            ConnectorRegistry creg = ConnectorRegistry.getInstance();
            Map<String, List<EjbDescriptor>> mappings = this.createRAEjbMapping(xaEnabledMDBList);
            for (Map.Entry<String, List<EjbDescriptor>> entry : mappings.entrySet()) {
                List<EjbDescriptor> respectiveDesc;
                String raMid;
                block18: {
                    raMid = entry.getKey();
                    respectiveDesc = mappings.get(raMid);
                    try {
                        this.createActiveResourceAdapter(raMid);
                    }
                    catch (Exception ex) {
                        _logger.log(Level.SEVERE, "error.loading.connector.resources.during.recovery", raMid);
                        if (!_logger.isLoggable(Level.FINE)) break block18;
                        _logger.log(Level.FINE, ex.toString(), ex);
                    }
                }
                ActiveInboundResourceAdapter activeInboundRA = (ActiveInboundResourceAdapter)creg.getActiveResourceAdapter(raMid);
                boolean isSystemJmsRA = false;
                if (ConnectorsUtil.isJMSRA((String)activeInboundRA.getModuleName())) {
                    isSystemJmsRA = true;
                }
                ResourceAdapter resourceAdapter = activeInboundRA.getResourceAdapter();
                ArrayList<ActivationSpec> activationSpecList = new ArrayList<ActivationSpec>();
                try {
                    for (int i = 0; i < respectiveDesc.size(); ++i) {
                        try {
                            EjbMessageBeanDescriptor descriptor = (EjbMessageBeanDescriptor)respectiveDesc.get(i);
                            if (isSystemJmsRA) {
                                activeInboundRA.updateMDBRuntimeInfo(descriptor, null);
                            }
                            Set activationConfigProps = RARUtils.getMergedActivationConfigProperties((EjbMessageBeanDescriptor)descriptor);
                            String msgListenerType = descriptor.getMessageListenerType();
                            ActivationSpec aspec = (ActivationSpec)Class.forName(cr.getActivationSpecClass(raMid, msgListenerType), false, resourceAdapter.getClass().getClassLoader()).newInstance();
                            aspec.setResourceAdapter(resourceAdapter);
                            SetMethodAction sma = new SetMethodAction((Object)aspec, activationConfigProps);
                            sma.run();
                            activationSpecList.add(aspec);
                            continue;
                        }
                        catch (Exception e) {
                            _logger.log(Level.WARNING, "error.creating.activationspec", e.getMessage());
                            if (!_logger.isLoggable(Level.FINE)) continue;
                            _logger.log(Level.FINE, e.toString(), e);
                        }
                    }
                    ActivationSpec[] activationSpecArray = activationSpecList.toArray(new ActivationSpec[activationSpecList.size()]);
                    XAResource[] xar = resourceAdapter.getXAResources(activationSpecArray);
                    if (xar == null) continue;
                    for (int p = 0; p < xar.length; ++p) {
                        xaresList.add(xar[p]);
                    }
                }
                catch (UnsupportedOperationException uoex) {
                    _logger.log(Level.FINE, uoex.getMessage());
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, "exception.during.inbound.resource.acqusition", e);
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "exception.during.inbound.recovery", e);
        }
    }

    private Vector getEjbDescriptors(com.sun.enterprise.config.serverbeans.Application application, ApplicationRegistry appsRegistry) {
        Vector<EjbDescriptor> ejbDescriptors = new Vector<EjbDescriptor>();
        if (ResourcesUtil.createInstance().isEnabled(application)) {
            ApplicationInfo appInfo = appsRegistry.get(application.getName());
            if (appInfo != null) {
                Application app = (Application)appInfo.getMetaData(Application.class);
                Set descriptors = app.getBundleDescriptors();
                for (BundleDescriptor descriptor : descriptors) {
                    if (!(descriptor instanceof EjbBundleDescriptor)) continue;
                    EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)descriptor;
                    Set ejbDescriptorsSet = ejbBundleDescriptor.getEjbs();
                    for (EjbDescriptor ejbDescriptor : ejbDescriptorsSet) {
                        ejbDescriptors.add(ejbDescriptor);
                    }
                }
            } else {
                _logger.log(Level.WARNING, "application.not.started.skipping.recovery", application.getName());
            }
        }
        return ejbDescriptors;
    }

    private Map<String, List<EjbDescriptor>> createRAEjbMapping(List<EjbDescriptor> ejbDescriptors) {
        HashMap<String, List<EjbDescriptor>> map = new HashMap<String, List<EjbDescriptor>>();
        for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
            List<Object> ejbmdbd = new ArrayList<EjbDescriptor>();
            String ramid = ((EjbMessageBeanDescriptor)ejbDescriptor).getResourceAdapterMid();
            if (ramid == null || ramid.equalsIgnoreCase("")) {
                ramid = "jmsra";
            }
            if (map.containsKey(ramid)) {
                ejbmdbd = (List)map.get(ramid);
                map.remove(ramid);
            }
            ejbmdbd.add(ejbDescriptor);
            map.put(ramid, ejbmdbd);
        }
        return map;
    }

    private void createActiveResourceAdapter(String rarModuleName) throws ConnectorRuntimeException {
        ConnectorRuntime cr = (ConnectorRuntime)this.connectorRuntimeHabitat.getComponent(ConnectorRuntime.class);
        ConnectorRegistry creg = ConnectorRegistry.getInstance();
        if (creg.isRegistered(rarModuleName)) {
            return;
        }
        if (ConnectorAdminServiceUtils.isEmbeddedConnectorModule((String)rarModuleName)) {
            cr.createActiveResourceAdapterForEmbeddedRar(rarModuleName);
        } else {
            String moduleDir = ConnectorsUtil.belongsToSystemRA((String)rarModuleName) ? ConnectorsUtil.getSystemModuleLocation((String)rarModuleName) : ConfigBeansUtilities.getLocation((String)rarModuleName);
            ClassLoader loader = cr.createConnectorClassLoader(moduleDir, null, rarModuleName);
            cr.createActiveResourceAdapter(moduleDir, rarModuleName, loader);
        }
    }
}

