/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.connectors.internal.api;

import com.sun.appserv.connectors.internal.api.AppSpecificConnectorClassLoaderUtil;
import com.sun.appserv.connectors.internal.api.ConnectorClassFinder;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.ConnectorClassLoaderService;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.jvnet.hk2.annotations.Service;

@Service
public class ConnectorClassLoaderServiceImpl
implements ConnectorClassLoaderService {
    private DelegatingClassLoader globalConnectorCL;
    @Inject
    private AppSpecificConnectorClassLoaderUtil appsSpecificCCLUtil;
    @Inject
    private Provider<ClassLoaderHierarchy> classLoaderHierarchyProvider;
    private Logger logger = LogDomains.getLogger(ConnectorClassLoaderServiceImpl.class, (String)"javax.enterprise.resource.resourceadapter");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public DelegatingClassLoader getConnectorClassLoader(String appName) {
        DelegatingClassLoader loader = null;
        if (this.globalConnectorCL == null) {
            Class<ConnectorClassLoaderServiceImpl> clazz = ConnectorClassLoaderServiceImpl.class;
            // MONITORENTER : com.sun.appserv.connectors.internal.api.ConnectorClassLoaderServiceImpl.class
            if (this.globalConnectorCL == null) {
                final ClassLoader parent = this.getCommonClassLoader();
                this.globalConnectorCL = AccessController.doPrivileged(new PrivilegedAction<DelegatingClassLoader>(){

                    @Override
                    public DelegatingClassLoader run() {
                        DelegatingClassLoader dcl = new DelegatingClassLoader(parent);
                        for (ConnectorClassFinder cf : ConnectorClassLoaderServiceImpl.this.appsSpecificCCLUtil.getSystemRARClassLoaders()) {
                            dcl.addDelegate((DelegatingClassLoader.ClassFinder)cf);
                        }
                        return dcl;
                    }
                });
                for (ConnectorClassFinder cf : this.appsSpecificCCLUtil.getSystemRARClassLoaders()) {
                    this.globalConnectorCL.addDelegate((DelegatingClassLoader.ClassFinder)cf);
                }
            }
            // MONITOREXIT : clazz
        }
        if (!this.hasGlobalAccessForRARs(appName)) {
            this.appsSpecificCCLUtil.detectReferredRARs(appName);
            return this.createConnectorClassLoaderForApplication(appName);
        }
        if ($assertionsDisabled) return this.globalConnectorCL;
        if (this.globalConnectorCL != null) return this.globalConnectorCL;
        throw new AssertionError();
    }

    private boolean hasGlobalAccessForRARs(String appName) {
        return appName == null || this.appsSpecificCCLUtil.useGlobalConnectorClassLoader() || this.appsSpecificCCLUtil.getRequiredResourceAdapters(appName).contains("*");
    }

    private ClassLoader getCommonClassLoader() {
        return ((ClassLoaderHierarchy)this.classLoaderHierarchyProvider.get()).getCommonClassLoader();
    }

    private DelegatingClassLoader createConnectorClassLoaderForApplication(String appName) {
        DelegatingClassLoader appSpecificConnectorClassLoader = new DelegatingClassLoader(this.getCommonClassLoader());
        for (ConnectorClassFinder cf : this.appsSpecificCCLUtil.getSystemRARClassLoaders()) {
            appSpecificConnectorClassLoader.addDelegate((DelegatingClassLoader.ClassFinder)cf);
        }
        for (String raName : this.appsSpecificCCLUtil.getRARsReferredByApplication(appName)) {
            this.addRarClassLoader(appName, appSpecificConnectorClassLoader, raName);
        }
        for (String raName : this.appsSpecificCCLUtil.getRequiredResourceAdapters(appName)) {
            this.addRarClassLoader(appName, appSpecificConnectorClassLoader, raName);
        }
        return appSpecificConnectorClassLoader;
    }

    private void addRarClassLoader(String appName, DelegatingClassLoader appSpecificConnectorClassLoader, String raName) {
        DelegatingClassLoader.ClassFinder cf;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("raName for app [ " + appName + " ] : " + raName);
        }
        if ((cf = this.getClassFinder(raName)) != null) {
            appSpecificConnectorClassLoader.addDelegate(cf);
        }
    }

    private DelegatingClassLoader.ClassFinder getClassFinder(String raName) {
        List delegates = this.globalConnectorCL.getDelegates();
        DelegatingClassLoader.ClassFinder classFinder = null;
        for (DelegatingClassLoader.ClassFinder cf : delegates) {
            if (!raName.equals(((ConnectorClassFinder)cf).getResourceAdapterName())) continue;
            classFinder = cf;
            break;
        }
        return classFinder;
    }
}

