/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.connectors.internal.api;

import com.sun.appserv.connectors.internal.api.ConnectorClassFinder;
import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.loader.ASURLClassLoader;
import com.sun.logging.LogDomains;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class ConnectorsClassLoaderUtil {
    @Inject
    private ClassLoaderHierarchy clh;
    private Logger _logger = LogDomains.getLogger(ConnectorRuntime.class, (String)"javax.enterprise.resource.resourceadapter");
    @Inject
    private ServerEnvironment env;
    @Inject
    private ProcessEnvironment processEnv;
    @Inject
    Events events;
    private boolean rarsInitializedInEmbeddedServerMode;

    public ConnectorClassFinder createRARClassLoader(String moduleDir, ClassLoader deploymentParent, String moduleName, List<URI> appLibs) throws ConnectorRuntimeException {
        ClassLoader parent = null;
        parent = deploymentParent == null ? this.clh.getCommonClassLoader() : deploymentParent;
        return this.createRARClassLoader(parent, moduleDir, moduleName, appLibs);
    }

    private DelegatingClassLoader.ClassFinder getLibrariesClassLoader(final List<URI> appLibs) throws MalformedURLException, ConnectorRuntimeException {
        try {
            return (DelegatingClassLoader.ClassFinder)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ConnectorsClassLoaderUtil.this.clh.getAppLibClassFinder(appLibs);
                }
            });
        }
        catch (PrivilegedActionException e) {
            this._logger.log(Level.SEVERE, "error.creating.libraries.classloader", e);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause(e);
            throw cre;
        }
    }

    private ConnectorClassFinder createRARClassLoader(final ClassLoader parent, String moduleDir, final String moduleName, List<URI> appLibs) throws ConnectorRuntimeException {
        ConnectorClassFinder cl = null;
        try {
            final DelegatingClassLoader.ClassFinder librariesCL = this.getLibrariesClassLoader(appLibs);
            cl = (ConnectorClassFinder)((Object)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    final ConnectorClassFinder ccf = new ConnectorClassFinder(parent, moduleName, librariesCL);
                    if (ConnectorsClassLoaderUtil.this.processEnv.getProcessType().isEmbedded()) {
                        ConnectorsClassLoaderUtil.this.events.register(new EventListener(){

                            public void event(EventListener.Event event) {
                                if (event.is(EventTypes.PREPARE_SHUTDOWN)) {
                                    ccf.done();
                                }
                            }
                        });
                    }
                    return ccf;
                }
            }));
        }
        catch (Exception ex) {
            this._logger.log(Level.SEVERE, "error.creating.connector.classloader", ex);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(ex.getMessage());
            cre.initCause(ex);
            throw cre;
        }
        File file = new File(moduleDir);
        try {
            cl.appendURL(file.toURI().toURL());
            this.appendJars(file, cl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return cl;
    }

    private boolean extractRar(String rarName, String destination) {
        String rarFileName = rarName + ".rar";
        return ConnectorsUtil.extractRar(destination + rarFileName, rarFileName, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Collection<ConnectorClassFinder> getSystemRARClassLoaders() throws ConnectorRuntimeException {
        if (this.processEnv.getProcessType().isEmbedded() && !this.rarsInitializedInEmbeddedServerMode) {
            Class<ConnectorsClassLoaderUtil> clazz = ConnectorsClassLoaderUtil.class;
            // MONITORENTER : com.sun.appserv.connectors.internal.api.ConnectorsClassLoaderUtil.class
            if (!this.rarsInitializedInEmbeddedServerMode) {
                String installDir = System.getProperty("com.sun.aas.installRoot") + File.separator;
                for (String jdbcRarName : ConnectorConstants.jdbcSystemRarNames) {
                    String rarPath = ConnectorsUtil.getSystemModuleLocation(jdbcRarName);
                    File rarDir = new File(rarPath);
                    if (rarDir.exists()) continue;
                    this.extractRar(jdbcRarName, installDir);
                }
                this.rarsInitializedInEmbeddedServerMode = true;
            }
            // MONITOREXIT : clazz
        }
        ArrayList<ConnectorClassFinder> classLoaders = new ArrayList<ConnectorClassFinder>();
        Iterator<String> i$ = ConnectorsUtil.getSystemRARs().iterator();
        while (i$.hasNext()) {
            String rarName = i$.next();
            String location = ConnectorsUtil.getSystemModuleLocation(rarName);
            List<Object> libraries = this.processEnv.getProcessType().isEmbedded() ? new ArrayList() : ConnectorsUtil.getInstalledLibrariesFromManifest(location, this.env);
            ConnectorClassFinder ccf = this.createRARClassLoader(location, null, rarName, libraries);
            classLoaders.add(ccf);
        }
        return classLoaders;
    }

    public ConnectorClassFinder getSystemRARClassLoader(String rarName) throws ConnectorRuntimeException {
        if (ConnectorsUtil.belongsToSystemRA(rarName)) {
            DelegatingClassLoader dch = this.clh.getConnectorClassLoader(null);
            for (DelegatingClassLoader.ClassFinder cf : dch.getDelegates()) {
                if (!(cf instanceof ConnectorClassFinder) || !rarName.equals(((ConnectorClassFinder)cf).getResourceAdapterName())) continue;
                return (ConnectorClassFinder)cf;
            }
        }
        throw new ConnectorRuntimeException("No Classloader found for RA [ " + rarName + " ]");
    }

    private void appendJars(File moduleDir, ASURLClassLoader cl) throws MalformedURLException {
        if (moduleDir.isDirectory()) {
            for (File file : moduleDir.listFiles()) {
                if (file.getName().toUpperCase(Locale.getDefault()).endsWith(".JAR")) {
                    cl.appendURL(file.toURI().toURL());
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.appendJars(file, cl);
            }
        }
    }
}

