/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.connectors.ConnectionManagerImpl;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.LazyAssociatableConnectionManagerImpl;
import com.sun.enterprise.connectors.LazyEnlistableConnectionManagerImpl;
import com.sun.enterprise.connectors.PoolMetaData;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ConnectionManager;
import org.glassfish.resources.api.PoolInfo;
import org.glassfish.resources.api.ResourceInfo;

public class ConnectionManagerFactory {
    public static ConnectionManager getAvailableConnectionManager(PoolInfo poolInfo, boolean forceNoLazyAssoc, ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        ConnectorRegistry registry = ConnectorRegistry.getInstance();
        PoolMetaData pmd = registry.getPoolMetaData(poolInfo);
        boolean isLazyEnlist = pmd.isLazyEnlistable();
        boolean isLazyAssoc = pmd.isLazyAssociatable();
        ConnectionManagerImpl mgr = null;
        if (isLazyAssoc && !forceNoLazyAssoc) {
            ConnectionManagerFactory.logFine("Creating LazyAssociatableConnectionManager");
            mgr = new LazyAssociatableConnectionManagerImpl(poolInfo, resourceInfo);
        } else if (isLazyEnlist) {
            ConnectionManagerFactory.logFine("Creating LazyEnlistableConnectionManager");
            mgr = new LazyEnlistableConnectionManagerImpl(poolInfo, resourceInfo);
        } else {
            ConnectionManagerFactory.logFine("Creating plain ConnectionManager");
            mgr = new ConnectionManagerImpl(poolInfo, resourceInfo);
        }
        return mgr;
    }

    private static void logFine(String message) {
        Logger _logger = LogDomains.getLogger(ConnectionManagerFactory.class, (String)"javax.enterprise.resource.resourceadapter");
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(message);
        }
    }
}

