/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.deployment.annotation.handlers;

import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.annotation.context.RarBundleContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import javax.resource.spi.ConnectionDefinition;
import javax.resource.spi.ManagedConnectionFactory;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@AnnotationHandlerFor(value=ConnectionDefinition.class)
public class ConnectionDefinitionHandler
extends AbstractHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConnectionDefinitionHandler.class);

    public void processAnnotation(AnnotationInfo element, ConnectionDefinition defn) throws AnnotationProcessorException {
        AnnotatedElementHandler aeHandler = element.getProcessingContext().getHandler();
        this.handleAnnotation(aeHandler, defn, element);
    }

    public HandlerProcessingResult processAnnotation(AnnotationInfo element) throws AnnotationProcessorException {
        AnnotatedElementHandler aeHandler = element.getProcessingContext().getHandler();
        ConnectionDefinition connDefn = (ConnectionDefinition)element.getAnnotation();
        if (aeHandler instanceof RarBundleContext) {
            this.handleAnnotation(aeHandler, connDefn, element);
        } else {
            this.getFailureResult(element, "not a rar bundle context", true);
        }
        return this.getDefaultProcessedResult();
    }

    private void handleAnnotation(AnnotatedElementHandler aeHandler, ConnectionDefinition connDefn, AnnotationInfo element) {
        RarBundleContext rarContext = (RarBundleContext)aeHandler;
        ConnectorDescriptor desc = rarContext.getDescriptor();
        Class c = (Class)element.getAnnotatedElement();
        String targetClassName = c.getName();
        if (ManagedConnectionFactory.class.isAssignableFrom(c)) {
            OutboundResourceAdapter ora;
            if (!desc.getOutBoundDefined()) {
                ora = new OutboundResourceAdapter();
                desc.setOutboundResourceAdapter(ora);
            }
            if (!(ora = desc.getOutboundResourceAdapter()).hasConnectionDefDescriptor(connDefn.connectionFactory().getName())) {
                ConnectionDefDescriptor cdd = new ConnectionDefDescriptor();
                cdd.setConnectionFactoryImpl(connDefn.connectionFactoryImpl().getName());
                cdd.setConnectionFactoryIntf(connDefn.connectionFactory().getName());
                cdd.setConnectionIntf(connDefn.connection().getName());
                cdd.setConnectionImpl(connDefn.connectionImpl().getName());
                cdd.setManagedConnectionFactoryImpl(targetClassName);
                ora.addConnectionDefDescriptor(cdd);
            }
        } else {
            this.getFailureResult(element, "Cant handle ConnectionDefinition annotation as the annotated class does notimplement ManagedConnectionFactory", true);
        }
    }

    protected HandlerProcessingResult getDefaultProcessedResult() {
        return HandlerProcessingResultImpl.getDefaultResult((Class)this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return null;
    }

    private HandlerProcessingResultImpl getFailureResult(AnnotationInfo element, String message, boolean doLog) {
        HandlerProcessingResultImpl result = new HandlerProcessingResultImpl();
        result.addResult(this.getAnnotationType(), ResultType.FAILED);
        if (doLog) {
            Class c = (Class)element.getAnnotatedElement();
            String className = c.getName();
            Object[] args = new Object[]{element.getAnnotation(), className, message};
            String localString = localStrings.getLocalString("enterprise.deployment.annotation.handlers.connectorannotationfailure", "failed to handle annotation [ {0} ] on class [ {1} ], reason : {2}", args);
            this.logger.log(Level.WARNING, localString);
        }
        return result;
    }
}

