/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.service;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.DeferredResourceConfig;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.util.ConnectorDDTransformUtils;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.resources.api.PoolInfo;

public class ConnectorService
implements ConnectorConstants {
    protected static final Logger _logger = LogDomains.getLogger(ConnectorService.class, (String)"javax.enterprise.resource.resourceadapter");
    protected static final ConnectorRegistry _registry = ConnectorRegistry.getInstance();
    protected ConnectorRuntime _runtime = ConnectorRuntime.getRuntime();
    private ResourcesUtil resourcesUtil;

    public ResourcesUtil getResourcesUtil() {
        if (this.resourcesUtil == null) {
            this.resourcesUtil = ResourcesUtil.createInstance();
        }
        return this.resourcesUtil;
    }

    public String getDefaultPoolName(String moduleName, String connectionDefName) {
        return moduleName + "#" + connectionDefName;
    }

    public String getDefaultResourceName(String moduleName, String connectionDefName) {
        String resourceJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForResource(moduleName);
        return resourceJNDIName + "#" + connectionDefName;
    }

    public boolean checkAndLoadResource(Object resource, Object pool, String resourceType, String resourceName, String raName) throws ConnectorRuntimeException {
        String resname = ConnectorAdminServiceUtils.getOriginalResourceName(resourceName);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ConnectorService :: checkAndLoadResource resolved to load " + resname);
        }
        DeferredResourceConfig defResConfig = this.getResourcesUtil().getDeferredResourceConfig(resource, pool, resourceType, raName);
        return this.loadResourcesAndItsRar(defResConfig);
    }

    public boolean loadResourcesAndItsRar(DeferredResourceConfig defResConfig) {
        if (defResConfig != null) {
            try {
                this.loadDeferredResources((Resource[])defResConfig.getResourceAdapterConfig());
                final String rarName = defResConfig.getRarName();
                this.loadDeferredResourceAdapter(rarName);
                final Resource[] resToLoad = defResConfig.getResourcesToLoad();
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            ConnectorService.this.loadDeferredResources(resToLoad);
                        }
                        catch (Exception ex) {
                            Object[] params = new Object[]{rarName, ex};
                            _logger.log(Level.SEVERE, "failed.to.load.deferred.resources", params);
                        }
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                Object[] params = new Object[]{defResConfig.getRarName(), ex};
                _logger.log(Level.SEVERE, "failed.to.load.deferred.ra", params);
                return false;
            }
            return true;
        }
        return false;
    }

    public void loadDeferredResourceAdapter(String rarModuleName) throws ConnectorRuntimeException {
        if (_registry.getActiveResourceAdapter(rarModuleName) == null) {
            try {
                if (ConnectorsUtil.belongsToSystemRA((String)rarModuleName)) {
                    String systemModuleLocation = ConnectorsUtil.getSystemModuleLocation((String)rarModuleName);
                    if (this._runtime.isServer()) {
                        this._runtime.getMonitoringBootstrap().registerProbes(rarModuleName, new File(systemModuleLocation), this._runtime.getSystemRARClassLoader(rarModuleName));
                    }
                    this._runtime.createActiveResourceAdapter(systemModuleLocation, rarModuleName, null);
                }
            }
            catch (Exception e) {
                ConnectorRuntimeException ce = new ConnectorRuntimeException(e.getMessage());
                ce.initCause((Throwable)e);
                throw ce;
            }
        }
    }

    public void createActiveResourceAdapterForEmbeddedRar(String rarModuleName) throws ConnectorRuntimeException {
        ConnectorDescriptor cdesc = this.loadConnectorDescriptorForEmbeddedRAR(rarModuleName);
        String appName = ConnectorAdminServiceUtils.getApplicationName(rarModuleName);
        String rarFileName = ConnectorAdminServiceUtils.getConnectorModuleName(rarModuleName) + ".rar";
        String loc = this.getResourcesUtil().getApplicationDeployLocation(appName);
        loc = loc + File.separator + FileUtils.makeFriendlyFilename((String)rarFileName);
        String path = null;
        try {
            URI uri = new URI(loc);
            path = uri.getPath();
        }
        catch (URISyntaxException use) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Invalid path [ " + use.getMessage() + " ]");
            cre.setStackTrace(use.getStackTrace());
            _logger.log(Level.WARNING, cre.getMessage(), cre);
            throw cre;
        }
        this._runtime.createActiveResourceAdapter(cdesc, rarModuleName, path);
    }

    public void loadDeferredResources(Resource[] resourcesToLoad) throws Exception {
        if (resourcesToLoad == null || resourcesToLoad.length == 0) {
            return;
        }
        for (Resource resource : resourcesToLoad) {
            if (resource == null || !this.getResourcesUtil().isEnabled(resource)) continue;
            try {
                this._runtime.getResourceDeployer(resource).deployResource((Object)resource);
            }
            catch (Exception e) {
                ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
                cre.initCause((Throwable)e);
                throw cre;
            }
        }
    }

    public ConnectorDescriptor getConnectorDescriptor(String rarName) throws ConnectorRuntimeException {
        String moduleDir;
        if (rarName == null) {
            return null;
        }
        ConnectorDescriptor desc = null;
        desc = _registry.getDescriptor(rarName);
        if (desc != null) {
            return desc;
        }
        if (rarName.indexOf("#") != -1) {
            desc = this.loadConnectorDescriptorForEmbeddedRAR(rarName);
            if (desc != null) {
                return desc;
            }
        }
        if ((moduleDir = ConnectorsUtil.belongsToSystemRA((String)rarName) ? ConnectorsUtil.getSystemModuleLocation((String)rarName) : ConnectorsUtil.getLocation((String)rarName)) != null) {
            desc = ConnectorDDTransformUtils.getConnectorDescriptor(moduleDir, rarName);
        } else {
            _logger.log(Level.SEVERE, "rardeployment.no_module_deployed", rarName);
        }
        return desc;
    }

    public void switchOnMatching(String rarName, PoolInfo poolInfo) {
        PoolManager poolMgr;
        boolean result;
        if ((rarName.equals("__ds_jdbc_ra") || rarName.equals("__cp_jdbc_ra") || rarName.equals("__xa_jdbc_ra")) && !(result = (poolMgr = this._runtime.getPoolManager()).switchOnMatching(poolInfo))) {
            try {
                this._runtime.switchOnMatchingInJndi(poolInfo);
            }
            catch (ConnectorRuntimeException cre) {
                // empty catch block
            }
        }
    }

    public boolean checkAndLoadPool(PoolInfo poolInfo) {
        boolean status = false;
        try {
            ResourcePool pool = this._runtime.getConnectionPoolConfig(poolInfo);
            DeferredResourceConfig defResConfig = this.getResourcesUtil().getDeferredResourceConfig(null, pool, null, null);
            status = this.loadResourcesAndItsRar(defResConfig);
        }
        catch (ConnectorRuntimeException cre) {
            Object[] params = new Object[]{poolInfo, cre};
            _logger.log(Level.WARNING, "unable.to.load.connection.pool", params);
        }
        return status;
    }

    public void ifSystemRarLoad(String rarName) throws ConnectorRuntimeException {
        if (ConnectorsUtil.belongsToSystemRA((String)rarName)) {
            this.loadDeferredResourceAdapter(rarName);
        }
    }

    private ConnectorDescriptor loadConnectorDescriptorForEmbeddedRAR(String rarName) throws ConnectorRuntimeException {
        ResourcesUtil resutil = ResourcesUtil.createInstance();
        String rarFileName = ConnectorAdminServiceUtils.getConnectorModuleName(rarName) + ".rar";
        return resutil.getConnectorDescriptorFromUri(rarName, rarFileName);
    }

    public boolean checkAccessibility(String rarName, ClassLoader loader) {
        ClassLoader rarLoader;
        ActiveResourceAdapter ar = _registry.getActiveResourceAdapter(rarName);
        if (ar != null && loader != null && (rarLoader = ar.getClassLoader()) != null && ConnectorAdminServiceUtils.isEmbeddedConnectorModule(rarName)) {
            ClassLoader rarLoaderParent = rarLoader.getParent();
            ClassLoader parent = loader;
            while (true) {
                if (parent.equals(rarLoaderParent)) {
                    return true;
                }
                final ClassLoader temp = parent;
                Object obj = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return temp.getParent();
                    }
                });
                if (obj == null) break;
                parent = (ClassLoader)obj;
            }
            return false;
        }
        return true;
    }
}

