/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.WorkContextHandler;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkContext;
import javax.resource.spi.work.WorkManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.internal.api.Globals;
import org.glassfish.server.ServerEnvironmentImpl;

public final class BootstrapContextImpl
implements BootstrapContext,
Serializable {
    public static final int MAX_INSTANCE_LENGTH = 24;
    private static final long serialVersionUID = -8449694716854376406L;
    private String poolId;
    private transient WorkManager wm;
    private XATerminator xa;
    private String moduleName;
    private String threadPoolId;
    private ClassLoader rarCL;
    private String instanceName;
    private ProcessEnvironment.ProcessType processType;
    private static final Logger logger = LogDomains.getLogger(BootstrapContextImpl.class, (String)"javax.enterprise.resource.resourceadapter");

    public BootstrapContextImpl(String moduleName) throws ConnectorRuntimeException {
        this.moduleName = moduleName;
        this.initializeWorkManager();
    }

    public BootstrapContextImpl(String poolId, String moduleName, ClassLoader rarCL) throws ConnectorRuntimeException {
        this.threadPoolId = poolId;
        this.moduleName = moduleName;
        this.rarCL = rarCL;
        this.initializeWorkManager();
    }

    public Timer createTimer() {
        return new Timer("connectors-runtime-context", true);
    }

    public boolean isContextSupported(Class<? extends WorkContext> aClass) {
        WorkContextHandler wch = ConnectorRuntime.getRuntime().getWorkContextHandler();
        wch.init(this.moduleName, this.rarCL);
        return wch.isContextSupported(true, aClass.getName());
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        try {
            InitialContext ic = new InitialContext();
            return (TransactionSynchronizationRegistry)ic.lookup("java:comp/TransactionSynchronizationRegistry");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "tx.sync.registry.lookup.failed", e);
            RuntimeException re = new RuntimeException("Transaction Synchronization Registry Unavailable");
            re.initCause(e);
            throw re;
        }
    }

    public WorkManager getWorkManager() {
        this.initializeWorkManager();
        return this.wm;
    }

    private void initializeWorkManager() {
        if (this.wm == null) {
            try {
                this.wm = ConnectorRuntime.getRuntime().getWorkManagerProxy(this.threadPoolId, this.moduleName, this.rarCL);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "workmanager.instantiation_error", e);
            }
        }
    }

    public XATerminator getXATerminator() {
        this.initializeXATerminator();
        return this.xa;
    }

    private void initializeXATerminator() {
        if (this.xa == null) {
            this.xa = ConnectorRuntime.getRuntime().getXATerminatorProxy(this.moduleName);
        }
    }

    public String getInstanceName() {
        if (this.processType == null) {
            ProcessEnvironment pe = (ProcessEnvironment)Globals.get(ProcessEnvironment.class);
            this.processType = pe.getProcessType();
            if (this.processType.isServer()) {
                ServerEnvironmentImpl env = (ServerEnvironmentImpl)Globals.get(ServerEnvironmentImpl.class);
                String instance = env.getInstanceName();
                Domain domain = (Domain)Globals.get(Domain.class);
                Server server = domain.getServerNamed(instance);
                Cluster cluster = server.getCluster();
                if (cluster != null) {
                    if (instance.length() > 24) {
                        String hashcode = Integer.toHexString(instance.hashCode());
                        String truncation = instance.substring(instance.length() - 16);
                        String compactedInstance = truncation + hashcode;
                        logger.log(Level.INFO, "The original instance name is: " + instance + ", because it is too long, compact it to: " + compactedInstance);
                    }
                    this.instanceName = instance;
                }
            }
        }
        return this.instanceName;
    }
}

