/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.deployment.annotation.handlers;

import com.sun.enterprise.deployment.ConnectorResourceDefinitionDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbBundleContext;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.EjbInterceptorContext;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentsContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.Interceptors;
import javax.resource.ConnectorResourceDefinition;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=ConnectorResourceDefinition.class)
public class ConnectorResourceDefinitionHandler
extends AbstractResourceHandler {
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        ConnectorResourceDefinition connectorResourceDefnAn = (ConnectorResourceDefinition)ainfo.getAnnotation();
        return this.processAnnotation(connectorResourceDefnAn, ainfo, rcContexts);
    }

    protected HandlerProcessingResult processAnnotation(ConnectorResourceDefinition connectorResourceDefnAn, AnnotationInfo aiInfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        Class annotatedClass = (Class)aiInfo.getAnnotatedElement();
        Annotation[] annotations = annotatedClass.getAnnotations();
        boolean warClass = this.isAWebComponentClass(annotations);
        boolean ejbClass = this.isAEjbComponentClass(annotations);
        for (ResourceContainerContext context : rcContexts) {
            ConnectorResourceDefinitionDescriptor desc;
            if (!this.canProcessAnnotation(annotatedClass, ejbClass, warClass, context)) {
                return this.getDefaultProcessedResult();
            }
            Set crdDescs = context.getResourceDescriptors(JavaEEResourceType.CRD);
            if (this.isDefinitionAlreadyPresent(crdDescs, desc = this.createDescriptor(connectorResourceDefnAn))) {
                this.merge(crdDescs, connectorResourceDefnAn);
                continue;
            }
            context.addResourceDescriptor((ResourceDescriptor)desc);
        }
        return this.getDefaultProcessedResult();
    }

    private boolean canProcessAnnotation(Class annotatedClass, boolean ejbClass, boolean warClass, ResourceContainerContext context) {
        if (ejbClass) {
            if (!(context instanceof EjbBundleContext || context instanceof EjbContext || context instanceof EjbInterceptorContext)) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.log(Level.FINEST, "Ignoring @ConnectorResourceDefinition annotation processing as the class isan EJB class and context is not one of EJBContext");
                }
                return false;
            }
        } else if (context instanceof EjbBundleContext) {
            EjbBundleContext ejbContext = (EjbBundleContext)context;
            EjbBundleDescriptor ejbBundleDescriptor = ejbContext.getDescriptor();
            EjbDescriptor[] ejbDescriptor = ejbBundleDescriptor.getEjbByClassName(annotatedClass.getName());
            if (ejbDescriptor == null || ejbDescriptor.length == 0) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.log(Level.FINEST, "Ignoring @ConnectorResourceDefinition annotation processing as the class [ " + annotatedClass + " ] is" + "not an EJB class and the context is EJBContext");
                }
                return false;
            }
        } else if (warClass) {
            if (!(context instanceof WebBundleContext || context instanceof WebComponentsContext || context instanceof WebComponentContext)) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.log(Level.FINEST, "Ignoring @ConnectorResourceDefinition annotation processing as the class isan Web class and context is not one of WebContext");
                }
                return false;
            }
        } else if (context instanceof WebBundleContext) {
            WebBundleContext webBundleContext = (WebBundleContext)context;
            WebBundleDescriptor webBundleDescriptor = webBundleContext.getDescriptor();
            Collection extDesc = webBundleDescriptor.getExtensionsDescriptors();
            for (RootDeploymentDescriptor desc : extDesc) {
                Method[] methods;
                if (!(desc instanceof EjbBundleDescriptor)) continue;
                EjbBundleDescriptor ejbBundleDesc = (EjbBundleDescriptor)desc;
                EjbDescriptor[] ejbDescs = ejbBundleDesc.getEjbByClassName(annotatedClass.getName());
                if (ejbDescs != null && ejbDescs.length > 0) {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.log(Level.FINEST, "Ignoring @ConnectorResourceDefinition annotation processing as the class [ " + annotatedClass + " ] is" + "not an Web class and the context is WebContext");
                    }
                    return false;
                }
                if (ejbBundleDesc.getInterceptorByClassName(annotatedClass.getName()) != null) {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.log(Level.FINEST, "Ignoring @ConnectorResourceDefinition annotation processing as the class [ " + annotatedClass + " ] is" + "not an Web class and the context is WebContext");
                    }
                    return false;
                }
                for (Method method : methods = annotatedClass.getDeclaredMethods()) {
                    Annotation[] annotations;
                    for (Annotation annotation : annotations = method.getAnnotations()) {
                        if (!annotation.annotationType().equals(AroundInvoke.class) && !annotation.annotationType().equals(AroundTimeout.class) && !annotation.annotationType().equals(Interceptors.class)) continue;
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.log(Level.FINEST, "Ignoring @ConnectorResourceDefinition annotation processing as the class [ " + annotatedClass + " ] is" + "not an Web class, an interceptor and the context is WebContext");
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean isDefinitionAlreadyPresent(Set<ResourceDescriptor> crdDescs, ConnectorResourceDefinitionDescriptor desc) {
        boolean result = false;
        for (ResourceDescriptor descriptor : crdDescs) {
            if (!descriptor.equals(desc)) continue;
            result = true;
            break;
        }
        return result;
    }

    private void merge(Set<ResourceDescriptor> crdDescs, ConnectorResourceDefinition defn) {
        for (ResourceDescriptor orgDesc : crdDescs) {
            ConnectorResourceDefinitionDescriptor desc = (ConnectorResourceDefinitionDescriptor)orgDesc;
            if (!desc.getName().equals(defn.name())) continue;
            if (desc.getClassName() == null) {
                desc.setClassName(defn.className());
            }
            if (desc.getDescription() == null && defn.description() != null && !defn.description().equals("")) {
                desc.setDescription(defn.description());
            }
            Properties properties = desc.getProperties();
            String[] defnProperties = defn.properties();
            if (defnProperties.length <= 0) break;
            for (String property : defnProperties) {
                int index = property.indexOf("=");
                if (index <= 0 || index >= property.length() - 1) continue;
                String name = property.substring(0, index);
                String value = property.substring(index + 1);
                if (properties.get(name) != null) continue;
                properties.put(name, value);
            }
        }
    }

    private ConnectorResourceDefinitionDescriptor createDescriptor(ConnectorResourceDefinition defn) {
        ConnectorResourceDefinitionDescriptor desc = new ConnectorResourceDefinitionDescriptor();
        desc.setMetadataSource(MetadataSource.ANNOTATION);
        desc.setName(defn.name());
        desc.setClassName(defn.className());
        if (defn.description() != null && !defn.description().equals("")) {
            desc.setDescription(defn.description());
        }
        if (defn.properties() != null) {
            Properties properties = desc.getProperties();
            String[] defnProperties = defn.properties();
            if (defnProperties.length > 0) {
                for (String property : defnProperties) {
                    int index = property.indexOf("=");
                    if (index <= 0 || index >= property.length() - 1) continue;
                    String name = property.substring(0, index);
                    String value = property.substring(index + 1);
                    properties.put(name.trim(), value.trim());
                }
            }
        }
        return desc;
    }
}

