/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.connector.module;

import com.sun.enterprise.connectors.connector.module.ConnectorSniffer;
import com.sun.enterprise.connectors.connector.module.RarType;
import com.sun.enterprise.deploy.shared.FileArchive;
import java.io.IOException;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.resource.spi.Connector;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.GenericAnnotationDetector;
import org.glassfish.hk2.Services;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service(name="rar")
@Scoped(value=Singleton.class)
public class RarDetector
implements ArchiveDetector {
    private static final Class[] connectorAnnotations = new Class[]{Connector.class};
    public static final String RAR_DETECTOR_RANK_PROP = "glassfish.rar.detector.rank";
    public static final int DEFAULT_RAR_DETECTOR_RANK = 300;
    public static final String ARCHIVE_TYPE = "rar";
    @Inject
    private RarType archiveType;
    @Inject
    private ConnectorSniffer sniffer;
    @Inject
    private Services services;
    private ArchiveHandler archiveHandler;
    private Logger logger = Logger.getLogger(this.getClass().getPackage().getName());

    public int rank() {
        return Integer.getInteger(RAR_DETECTOR_RANK_PROP, 300);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveHandler getArchiveHandler() {
        RarDetector rarDetector = this;
        synchronized (rarDetector) {
            if (this.archiveHandler == null) {
                try {
                    this.sniffer.setup(null, this.logger);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.archiveHandler = (ArchiveHandler)this.services.forContract(ArchiveHandler.class).named(ARCHIVE_TYPE).get();
            }
            return this.archiveHandler;
        }
    }

    public ArchiveType getArchiveType() {
        return this.archiveType;
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        boolean handles = DeploymentUtils.isRAR((ReadableArchive)archive);
        if (!handles && archive instanceof FileArchive) {
            GenericAnnotationDetector detector = new GenericAnnotationDetector(connectorAnnotations);
            handles = detector.hasAnnotationInArchive(archive);
        }
        return handles;
    }
}

