/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.corba.ee.spi.threadpool.WorkQueue;
import com.sun.enterprise.connectors.work.OneWork;
import com.sun.enterprise.connectors.work.context.WorkContextHandlerImpl;
import com.sun.enterprise.connectors.work.monitor.WorkManagementProbeProvider;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;

public final class WorkCoordinator {
    static final int WAIT_UNTIL_START = 1;
    static final int WAIT_UNTIL_FINISH = 2;
    static final int NO_WAIT = 3;
    static final int CREATED = 1;
    static final int STARTED = 2;
    static final int COMPLETED = 3;
    static final int TIMEDOUT = 4;
    private volatile int waitMode;
    private volatile int state = 1;
    private final boolean workIsBad = false;
    private final Work work;
    private final long timeout;
    private long startTime;
    private final ExecutionContext ec;
    private final WorkQueue queue;
    private final WorkListener listener;
    private volatile WorkException exception;
    private final Object lock;
    private static int seed;
    private final int id;
    private static final Logger logger;
    private WorkManagementProbeProvider probeProvider = null;
    private ConnectorRuntime runtime;
    private String raName = null;
    private WorkContextHandlerImpl contextHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkCoordinator(Work work, long timeout, ExecutionContext ec, WorkQueue queue, WorkListener listener, WorkManagementProbeProvider probeProvider, ConnectorRuntime runtime, String raName, WorkContextHandlerImpl handler) {
        this.work = work;
        this.timeout = timeout;
        this.ec = ec;
        this.queue = queue;
        this.listener = listener;
        Class<WorkCoordinator> clazz = WorkCoordinator.class;
        synchronized (WorkCoordinator.class) {
            this.id = ++seed;
            // ** MonitorExit[var11_10] (shouldn't be in output)
            this.runtime = runtime;
            this.lock = new Object();
            this.probeProvider = probeProvider;
            this.raName = raName;
            this.contextHandler = handler;
            return;
        }
    }

    public String getRAName() {
        return this.raName;
    }

    public void submitWork(int waitModeValue) {
        this.waitMode = waitModeValue;
        this.startTime = System.currentTimeMillis();
        if (this.listener != null) {
            this.listener.workAccepted(new WorkEvent((Object)this, 1, this.work, null));
        }
        if (this.probeProvider != null) {
            this.probeProvider.workSubmitted(this.raName);
            this.probeProvider.workQueued(this.raName);
        }
        this.queue.addWork((com.sun.corba.ee.spi.threadpool.Work)new OneWork(this.work, this, this.contextHandler, Thread.currentThread().getContextClassLoader()));
    }

    public void preInvoke() {
        if (this.waitMode == 3 && this.timeout > -1L) {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            if (this.probeProvider != null) {
                this.probeProvider.workWaitedFor(this.raName, elapsedTime);
            }
            if (elapsedTime > this.timeout) {
                this.workTimedOut();
            }
        }
        if (!this.proceed()) {
            if (this.probeProvider != null) {
                this.probeProvider.workDequeued(this.raName);
            }
            return;
        }
        if (this.probeProvider != null) {
            this.probeProvider.workProcessingStarted(this.raName);
            this.probeProvider.workDequeued(this.raName);
        }
        if (this.work instanceof ResourceAdapterAssociation) {
            try {
                this.runtime.associateResourceAdapter(this.raName, (ResourceAdapterAssociation)this.work);
            }
            catch (ResourceException re) {
                logger.log(Level.SEVERE, "rardeployment.assoc_failed", re);
            }
        }
        this.setState(2);
        if (this.waitMode == 1) {
            this.unLock();
        }
        if (this.listener != null) {
            this.listener.workStarted(new WorkEvent((Object)this, 3, this.work, null));
        }
        SecurityContext.setUnauthenticatedContext();
    }

    public void setupContext(OneWork oneWork) throws WorkException {
        this.contextHandler.setupContext(WorkCoordinator.getExecutionContext(this.ec, this.work), this, oneWork);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void postInvoke() {
        block25: {
            boolean txImported = WorkCoordinator.getExecutionContext(this.ec, this.work) != null && WorkCoordinator.getExecutionContext(this.ec, this.work).getXid() != null;
            try {
                block23: {
                    try {
                        JavaEETransactionManager tm = this.getTransactionManager();
                        if (!txImported) break block23;
                        tm.release(WorkCoordinator.getExecutionContext(this.ec, this.work).getXid());
                    }
                    catch (WorkException ex) {
                        this.setException(ex);
                        Object var4_5 = null;
                        try {}
                        catch (Throwable throwable) {
                            Object var7_12 = null;
                            SecurityContext.setUnauthenticatedContext();
                            throw throwable;
                        }
                        try {}
                        catch (Exception e) {
                            logger.log(Level.WARNING, e.getMessage());
                            Object var7_11 = null;
                            SecurityContext.setUnauthenticatedContext();
                            break block25;
                        }
                        if (!this.isTimedOut()) {
                            if (this.probeProvider != null) {
                                this.probeProvider.workProcessingCompleted(this.raName);
                                this.probeProvider.workProcessed(this.raName);
                            }
                            if (this.listener != null) {
                                this.listener.workCompleted(new WorkEvent((Object)this, 4, this.work, this.getException()));
                            }
                        }
                        if (txImported) {
                            this.getTransactionManager().clearThreadTx();
                        }
                        Object var7_10 = null;
                        SecurityContext.setUnauthenticatedContext();
                        break block25;
                    }
                }
                Object var4_4 = null;
                try {
                    block24: {
                        try {
                            if (!this.isTimedOut()) {
                                if (this.probeProvider != null) {
                                    this.probeProvider.workProcessingCompleted(this.raName);
                                    this.probeProvider.workProcessed(this.raName);
                                }
                                if (this.listener != null) {
                                    this.listener.workCompleted(new WorkEvent((Object)this, 4, this.work, this.getException()));
                                }
                            }
                            if (!txImported) break block24;
                            this.getTransactionManager().clearThreadTx();
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, e.getMessage());
                            Object var7_8 = null;
                            SecurityContext.setUnauthenticatedContext();
                        }
                    }
                    Object var7_7 = null;
                    SecurityContext.setUnauthenticatedContext();
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    SecurityContext.setUnauthenticatedContext();
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {}
                catch (Throwable throwable2) {
                    Object var7_15 = null;
                    SecurityContext.setUnauthenticatedContext();
                    throw throwable2;
                }
                try {}
                catch (Exception e) {
                    logger.log(Level.WARNING, e.getMessage());
                    Object var7_14 = null;
                    SecurityContext.setUnauthenticatedContext();
                    throw throwable;
                }
                if (!this.isTimedOut()) {
                    if (this.probeProvider != null) {
                        this.probeProvider.workProcessingCompleted(this.raName);
                        this.probeProvider.workProcessed(this.raName);
                    }
                    if (this.listener != null) {
                        this.listener.workCompleted(new WorkEvent((Object)this, 4, this.work, this.getException()));
                    }
                }
                if (txImported) {
                    this.getTransactionManager().clearThreadTx();
                }
                Object var7_13 = null;
                SecurityContext.setUnauthenticatedContext();
                throw throwable;
            }
        }
        this.setState(3);
        if (this.waitMode != 2) return;
        this.unLock();
    }

    private void workTimedOut() {
        this.setState(4);
        this.exception = new WorkRejectedException();
        this.exception.setErrorCode("1");
        if (this.listener != null) {
            this.listener.workRejected(new WorkEvent((Object)this, 2, this.work, this.exception));
        }
        if (this.probeProvider != null) {
            this.probeProvider.workTimedOut(this.raName);
        }
    }

    public boolean proceed() {
        return !this.isTimedOut() && this.exception == null;
    }

    public boolean isTimedOut() {
        return this.getState() == 4;
    }

    public WorkException getException() {
        return this.exception;
    }

    public void setException(Throwable e) {
        if (this.getState() < 2) {
            if (e instanceof WorkRejectedException) {
                this.exception = (WorkException)e;
            } else if (e instanceof WorkException) {
                WorkException we = (WorkException)e;
                this.exception = new WorkRejectedException((Throwable)we);
                this.exception.setErrorCode(we.getErrorCode());
            } else {
                this.exception = new WorkRejectedException(e);
                this.exception.setErrorCode("0");
            }
        } else if (e instanceof WorkCompletedException) {
            this.exception = (WorkException)e;
        } else if (e instanceof WorkException) {
            WorkException we = (WorkException)e;
            this.exception = new WorkCompletedException((Throwable)we);
            this.exception.setErrorCode(we.getErrorCode());
        } else {
            this.exception = new WorkCompletedException(e);
            this.exception.setErrorCode("0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        block14: {
            if (!this.lockRequired()) {
                return;
            }
            try {
                Object object = this.lock;
                synchronized (object) {
                    if (this.checkStateBeforeLocking()) {
                        if (this.timeout != -1L) {
                            this.lock.wait(this.timeout);
                        } else {
                            this.lock.wait();
                        }
                    }
                }
                if (this.getState() < 2) {
                    this.workTimedOut();
                }
                if (!this.lockRequired()) break block14;
                object = this.lock;
                synchronized (object) {
                    if (this.checkStateBeforeLocking()) {
                        this.lock.wait();
                    }
                }
            }
            catch (Exception e) {
                this.setException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unLock() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    public String toString() {
        return this.id + ":" + this.work;
    }

    public synchronized void setState(int state) {
        this.state = state;
    }

    public synchronized int getState() {
        return this.state;
    }

    private boolean lockRequired() {
        if (!this.proceed()) {
            return false;
        }
        if (this.waitMode == 3) {
            return false;
        }
        if (this.waitMode == 2) {
            return this.getState() < 3;
        }
        if (this.waitMode == 1) {
            return this.getState() < 2;
        }
        return false;
    }

    private boolean checkStateBeforeLocking() {
        if (this.waitMode == 2) {
            return this.state < 3;
        }
        if (this.waitMode == 1) {
            return this.state < 2;
        }
        return false;
    }

    private JavaEETransactionManager getTransactionManager() {
        return this.runtime.getTransactionManager();
    }

    public static ExecutionContext getExecutionContext(ExecutionContext ec, Work work) {
        if (ec == null) {
            return WorkContextHandlerImpl.getExecutionContext(work);
        }
        return ec;
    }

    static {
        logger = LogDomains.getLogger(WorkCoordinator.class, (String)"javax.enterprise.resource.resourceadapter");
    }
}

