/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work.context;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.WorkContextHandler;
import com.sun.enterprise.connectors.work.LogFacade;
import com.sun.enterprise.connectors.work.OneWork;
import com.sun.enterprise.connectors.work.WorkCoordinator;
import com.sun.enterprise.connectors.work.context.ConnectorCallbackHandler;
import com.sun.enterprise.connectors.work.context.CustomWorkContext_A;
import com.sun.enterprise.connectors.work.context.CustomWorkContext_B;
import com.sun.enterprise.connectors.work.context.CustomWorkContext_D;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.HintsContext;
import javax.resource.spi.work.SecurityContext;
import javax.resource.spi.work.TransactionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkContext;
import javax.resource.spi.work.WorkContextLifecycleListener;
import javax.resource.spi.work.WorkContextProvider;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkRejectedException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.connectors.config.GroupMap;
import org.glassfish.connectors.config.PrincipalMap;
import org.glassfish.connectors.config.WorkSecurityMap;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.PrincipalImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class WorkContextHandlerImpl
implements WorkContextHandler {
    private static final List<Class<? extends WorkContext>> containerSupportedContexts = new ArrayList<Class<? extends WorkContext>>();
    private static final Logger logger = LogFacade.getLogger();
    private static final Locale locale = Locale.getDefault();
    @Inject
    private ConnectorRuntime runtime;
    private ClassLoader rarCL;
    private Set<WorkContext> validContexts = new HashSet<WorkContext>();
    private static final String RAR_LOAD_WORK_CONTEXT_ERROR = "AS-RAR-05006";
    private static final String RAR_EXECUTION_CONTEXT_CONFLICT = "AS-RAR-05007";
    private static final String RAR_EXECUTION_CONTEXT_DUPLICATE = "AS-RAR-05008";
    private static final String RAR_EXECUTION_CONTEXT_NOT_SUPPORT = "AS-RAR-05009";
    private static final String RAR_USE_SUPER_WORK_CONTEXT = "AS-RAR-05010";
    private static final String RAR_SETUP_SECURITY_CONTEXT_ERROR = "AS-RAR-05011";

    public WorkContextHandlerImpl() {
    }

    public WorkContextHandlerImpl(ConnectorRuntime runtime, ClassLoader cl) {
        this.runtime = runtime;
        this.rarCL = cl;
    }

    public void init(String raName, ClassLoader cl) {
        this.rarCL = cl;
    }

    public boolean isContextSupported(boolean strict, String workContextClassName) {
        boolean result = false;
        result = strict ? this.canContainerHandleSameContextType(workContextClassName) : this.canContainerHandleContext(workContextClassName);
        return result;
    }

    private boolean canContainerHandleSameContextType(String workContextClassName) {
        boolean result = false;
        for (Class<? extends WorkContext> workContextClass : containerSupportedContexts) {
            Class clz = null;
            try {
                clz = this.loadClass(workContextClassName);
            }
            catch (ClassNotFoundException cnfe) {
                logger.log(Level.WARNING, RAR_LOAD_WORK_CONTEXT_ERROR, new Object[]{workContextClassName, cnfe});
                break;
            }
            if (!workContextClass.equals(clz)) continue;
            result = true;
            WorkContextHandlerImpl.debug("Container can handle the context [Strict] : " + workContextClassName);
            break;
        }
        return result;
    }

    public boolean canContainerHandleContext(String contextClassName) {
        boolean result = false;
        if (!this.canContainerHandleSameContextType(contextClassName)) {
            Class context = null;
            try {
                context = this.loadClass(contextClassName);
            }
            catch (ClassNotFoundException e) {
                WorkContextHandlerImpl.debug("Container cannot load the context class [isAssignable] : " + contextClassName + " ");
            }
            if (context != null) {
                for (Class<? extends WorkContext> workContextClass : containerSupportedContexts) {
                    if (!workContextClass.isAssignableFrom(context)) continue;
                    result = true;
                    WorkContextHandlerImpl.debug("Container can handle the context [isAssignable] : " + contextClassName);
                    break;
                }
            } else {
                logger.log(Level.WARNING, RAR_LOAD_WORK_CONTEXT_ERROR, contextClassName);
            }
        } else {
            result = true;
        }
        return result;
    }

    private Class loadClass(String contextClassName) throws ClassNotFoundException {
        return this.rarCL.loadClass(contextClassName);
    }

    public void validateWork(Work work, ExecutionContext ec) throws WorkCompletedException, WorkRejectedException {
        if (work instanceof WorkContextProvider) {
            WorkContextProvider icp = (WorkContextProvider)work;
            ExecutionContext transactionContext = WorkContextHandlerImpl.getExecutionContext(work);
            if (ec != null && transactionContext != ec) {
                WorkRejectedException wre = new WorkRejectedException();
                wre.setErrorCode("3");
                logger.log(Level.WARNING, RAR_EXECUTION_CONTEXT_CONFLICT, new Object[]{ec, transactionContext, work, wre});
                if (transactionContext instanceof WorkContext) {
                    WorkContextLifecycleListener listener = this.getListener((WorkContext)transactionContext);
                    this.notifyContextSetupFailure(listener, "3");
                }
                throw wre;
            }
            List contexts = icp.getWorkContexts();
            if (contexts != null) {
                for (WorkContext ic : contexts) {
                    WorkContextLifecycleListener listener = this.getListener(ic);
                    if (this.isContextSupported(false, ic.getClass().getName())) {
                        if (this.isUniqueSubmission(ic, this.validContexts)) {
                            this.validContexts.add(ic);
                            continue;
                        }
                        WorkCompletedException wce = new WorkCompletedException();
                        wce.setErrorCode("2");
                        logger.log(Level.WARNING, RAR_EXECUTION_CONTEXT_DUPLICATE, new Object[]{ic.getClass().getName(), wce});
                        this.notifyContextSetupFailure(listener, "2");
                        throw wce;
                    }
                    WorkCompletedException wce = new WorkCompletedException();
                    wce.setErrorCode("1");
                    logger.log(Level.WARNING, RAR_EXECUTION_CONTEXT_NOT_SUPPORT, new Object[]{ic.getClass().getName(), wce});
                    this.notifyContextSetupFailure(listener, "1");
                    throw wce;
                }
            }
        }
    }

    private boolean isUniqueSubmission(WorkContext ic, Collection<WorkContext> supportedContexts) {
        for (WorkContext workContext : supportedContexts) {
            String icName;
            String workContextName = workContext.getClass().getName().toLowerCase(locale);
            if (!workContextName.equalsIgnoreCase(icName = ic.getClass().getName().toLowerCase(locale))) continue;
            WorkContextHandlerImpl.debug("Not a unique workContext submission : " + workContext.getClass().getName());
            return false;
        }
        return true;
    }

    public void setupContext(ExecutionContext ec, WorkCoordinator wc, OneWork work) throws WorkCompletedException {
        boolean useExecutionContext = true;
        for (WorkContext ic : this.validContexts) {
            WorkContextLifecycleListener listener = this.getListener(ic);
            if (ic instanceof TransactionContext) {
                useExecutionContext = false;
                this.setupTransactionWorkContext((TransactionContext)ic, listener);
                continue;
            }
            if (ic instanceof SecurityContext) {
                this.setupSecurityWorkContext((SecurityContext)ic, listener, wc.getRAName());
                continue;
            }
            if (ic instanceof HintsContext) {
                this.setupHintsContext((HintsContext)ic, listener, work);
                continue;
            }
            Class<? extends WorkContext> claz = null;
            String className = ic.getClass().getName();
            if (!this.isContextSupported(true, className) && (claz = this.getMostSpecificWorkContextSupported(ic)) == null) {
                WorkContextHandlerImpl.debug("Cannot handle work context [ " + className + " ]");
                continue;
            }
            this.setupCustomWorkContext(ic, listener, claz);
        }
        if (useExecutionContext) {
            try {
                this.setupExecutionContext(ec);
            }
            catch (WorkException we) {
                wc.setException(we);
            }
            catch (Exception e) {
                wc.setException(e);
            }
        }
    }

    private void setupHintsContext(HintsContext ic, WorkContextLifecycleListener listener, OneWork work) {
        Map hints = ic.getHints();
        Object value = hints.get("javax.resource.Name");
        if (value != null) {
            work.setName(value.toString());
            this.notifyContextSetupComplete(listener);
        }
    }

    private WorkContextLifecycleListener getListener(WorkContext wc) {
        WorkContextLifecycleListener listener = null;
        if (wc instanceof WorkContextLifecycleListener) {
            listener = (WorkContextLifecycleListener)wc;
        }
        return listener;
    }

    private void setupCustomWorkContext(WorkContext ic, WorkContextLifecycleListener listener, Class<? extends WorkContext> claz) {
        if (claz != null) {
            Object[] params = new Object[]{ic.getClass().getName(), claz.getName()};
            logger.log(Level.INFO, RAR_USE_SUPER_WORK_CONTEXT, params);
        } else {
            WorkContextHandlerImpl.debug("setting exact customWorkContext for WorkContext [ " + ic.getClass().getName() + " ]  ");
        }
        this.notifyContextSetupComplete(listener);
    }

    private Class<? extends WorkContext> getMostSpecificWorkContextSupported(WorkContext ic) {
        List<Class> assignableClasses = new ArrayList<Class>();
        for (Class<? extends WorkContext> icClass : containerSupportedContexts) {
            if (!icClass.isAssignableFrom(ic.getClass())) continue;
            assignableClasses.add(icClass);
        }
        assignableClasses = this.sortBasedOnInheritence(assignableClasses);
        Object[] params = new Object[]{ic.getClass().getName(), assignableClasses.get(0).getName()};
        logger.log(Level.INFO, RAR_USE_SUPER_WORK_CONTEXT, params);
        return assignableClasses.get(0);
    }

    private List<Class> sortBasedOnInheritence(List<Class> assignableClasses) {
        int size = assignableClasses.size();
        Class[] sortedClassesArray = new Class[size];
        for (Class claz : assignableClasses) {
            int count = this.getNumberOfAssignableClasses(claz, assignableClasses);
            sortedClassesArray[count - 1] = claz;
        }
        return Arrays.asList(sortedClassesArray);
    }

    private int getNumberOfAssignableClasses(Class claz, List<Class> assignableClasses) {
        int count = 0;
        for (Class assignableClass : assignableClasses) {
            if (!claz.isAssignableFrom(assignableClass)) continue;
            ++count;
        }
        return count;
    }

    private void setupSecurityWorkContext(SecurityContext securityWorkContext, WorkContextLifecycleListener listener, String raName) throws WorkCompletedException {
        try {
            Subject executionSubject = new Subject();
            Subject serviceSubject = new Subject();
            Map securityMap = this.getWorkContextMap(raName);
            ConnectorCallbackHandler handler = new ConnectorCallbackHandler(executionSubject, this.runtime.getCallbackHandler(), securityMap);
            securityWorkContext.setupSecurityContext((CallbackHandler)handler, executionSubject, serviceSubject);
            this.notifyContextSetupComplete(listener);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, RAR_SETUP_SECURITY_CONTEXT_ERROR, e);
            this.notifyContextSetupFailure(listener, "3");
            WorkCompletedException wce = new WorkCompletedException(e.getMessage());
            wce.initCause((Throwable)e);
            throw wce;
        }
    }

    private Map getWorkContextMap(String raName) {
        List maps = this.runtime.getWorkSecurityMap(raName);
        List<PrincipalMap> principalsMap = this.getPrincipalsMap(maps);
        List<GroupMap> groupsMap = this.getGroupsMap(maps);
        HashMap<Object, Object> eisASMap = new HashMap<Object, Object>();
        for (PrincipalMap principalMap : principalsMap) {
            eisASMap.put(new PrincipalImpl(principalMap.getEisPrincipal()), new PrincipalImpl(principalMap.getMappedPrincipal()));
        }
        for (GroupMap groupMap : groupsMap) {
            eisASMap.put(new Group(groupMap.getEisGroup()), new Group(groupMap.getMappedGroup()));
        }
        return eisASMap;
    }

    private List<PrincipalMap> getPrincipalsMap(List<WorkSecurityMap> maps) {
        ArrayList<PrincipalMap> principalsMap = new ArrayList<PrincipalMap>();
        for (WorkSecurityMap map : maps) {
            List principalMap = map.getPrincipalMap();
            if (principalMap == null || principalMap.size() <= 0) continue;
            principalsMap.addAll(principalMap);
        }
        return principalsMap;
    }

    private List<GroupMap> getGroupsMap(List<WorkSecurityMap> maps) {
        ArrayList<GroupMap> groupsMap = new ArrayList<GroupMap>();
        for (WorkSecurityMap map : maps) {
            List groupMap = map.getGroupMap();
            if (groupMap == null || groupMap.size() <= 0) continue;
            groupsMap.addAll(groupMap);
        }
        return groupsMap;
    }

    private void notifyContextSetupFailure(WorkContextLifecycleListener listener, String errorCode) {
        if (listener != null) {
            WorkContextHandlerImpl.debug("notifying context setup failure");
            listener.contextSetupFailed(errorCode);
        }
    }

    private void notifyContextSetupComplete(WorkContextLifecycleListener listener) {
        if (listener != null) {
            WorkContextHandlerImpl.debug("notifying context setup complete");
            listener.contextSetupComplete();
        }
    }

    private void setupTransactionWorkContext(TransactionContext tic, WorkContextLifecycleListener listener) throws WorkCompletedException {
        try {
            this.setupExecutionContext((ExecutionContext)tic);
            this.notifyContextSetupComplete(listener);
        }
        catch (Exception e) {
            this.notifyContextSetupFailure(listener, "3");
            WorkCompletedException wce = new WorkCompletedException(e.getMessage());
            wce.initCause((Throwable)e);
            throw wce;
        }
    }

    private void setupExecutionContext(ExecutionContext ec) throws WorkException {
        JavaEETransactionManager tm = this.runtime.getTransactionManager();
        if (ec != null && ec.getXid() != null) {
            tm.recreate(ec.getXid(), ec.getTransactionTimeout());
        }
    }

    public static void debug(String message) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, message);
        }
    }

    public static ExecutionContext getExecutionContext(Work work) {
        WorkContextProvider icp;
        List icList;
        TransactionContext ec = null;
        if (work instanceof WorkContextProvider && (icList = (icp = (WorkContextProvider)work).getWorkContexts()) != null) {
            for (WorkContext ic : icList) {
                if (!(ic instanceof TransactionContext)) continue;
                ec = (TransactionContext)ic;
                break;
            }
        }
        return ec;
    }

    public boolean isContextSupported(Class contextClass) {
        return this.canContainerHandleSameContextType(contextClass.getClass().getName());
    }

    static {
        containerSupportedContexts.add(TransactionContext.class);
        containerSupportedContexts.add(SecurityContext.class);
        containerSupportedContexts.add(HintsContext.class);
        containerSupportedContexts.add(CustomWorkContext_A.class);
        containerSupportedContexts.add(CustomWorkContext_B.class);
        containerSupportedContexts.add(CustomWorkContext_D.class);
    }
}

