/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.introspection;

import com.sun.enterprise.deployment.annotation.introspection.ConstantPoolInfo;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ClassFile {
    ByteBuffer header = ByteBuffer.allocate(12000);
    ConstantPoolInfo constantPoolInfo;
    public short majorVersion;
    public short minorVersion;
    public ConstantPoolInfo[] constantPool;
    public short accessFlags;
    public ConstantPoolInfo thisClass;
    public ConstantPoolInfo superClass;
    public ConstantPoolInfo[] interfaces;
    boolean isValidClass = false;
    private static final int magic = -889275714;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_THREADSAFE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;

    public ClassFile(ConstantPoolInfo poolInfo) {
        this.constantPoolInfo = poolInfo;
    }

    public boolean containsAnnotation(ReadableByteChannel in, long size) throws IOException {
        this.header.clear();
        if (size != -1L && size > (long)this.header.capacity()) {
            this.header = ByteBuffer.allocate((int)size);
        }
        long read = in.read(this.header);
        if (size != -1L && read != size) {
            return false;
        }
        this.header.rewind();
        return this.containsAnnotation(this.header);
    }

    public boolean containsAnnotation(byte[] bytecode) throws IOException {
        ByteBuffer wrappedHeader = ByteBuffer.wrap(bytecode);
        return this.containsAnnotation(wrappedHeader);
    }

    private boolean containsAnnotation(ByteBuffer headerBuffer) throws IOException {
        if (headerBuffer.getInt() != -889275714) {
            return false;
        }
        this.majorVersion = headerBuffer.getShort();
        this.minorVersion = headerBuffer.getShort();
        short constantPoolSize = headerBuffer.getShort();
        return this.constantPoolInfo.containsAnnotation(constantPoolSize, headerBuffer);
    }
}

