/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.interfaces.MailResourceIntf;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.repository.ResourceProperty;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MailConfiguration
implements Serializable {
    private static String PROTOCOL_TYPE_IMAP = "imap";
    private static String PROTOCOL_TYPE_POP3 = "pop3";
    private static String PROTOCOL_TYPE_SMTP = "smtp";
    private static String PROP_NAME_PREFIX_LEGACY = "mail-";
    private static char PROP_NAME_DELIM_LEGACY = (char)45;
    private static String DEF_VAL_STORE_PROTOCOL = PROTOCOL_TYPE_IMAP;
    private static String DEF_VAL_STORE_PROTOCOL_CLASS = "com.sun.mail.imap.IMAPStore";
    private static String DEF_VAL_TRANSPORT_PROTOCOL = PROTOCOL_TYPE_SMTP;
    private static String DEF_VAL_TRANSPORT_PROTOCOL_CLASS = "com.sun.mail.smtp.SMTPTransport";
    private static String DEF_VAL_HOST = "localhost";
    private static String DEF_VAL_USER = "user.name";
    private static String DEF_VAL_FROM = "username@host";
    private static boolean DEF_VAL_DEBUG = false;
    private static String MAIL_STORE_PROTOCOL = "mail.store.protocol";
    private static String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    private static String MAIL_HOST = "mail.host";
    private static String MAIL_USER = "mail.user";
    private static String MAIL_FROM = "mail.from";
    private static String MAIL_DEBUG = "mail.debug";
    private static String MAIL_PREFIX = "mail.";
    private static String MAIL_SUFFIX_CLASS = ".class";
    private static String MAIL_SUFFIX_HOST = ".host";
    private static String MAIL_SUFFIX_USER = ".user";
    private static char MAIL_DELIM = (char)46;
    private String description = "";
    private String jndiName = "";
    private boolean enabled = false;
    private String storeProtocol = DEF_VAL_STORE_PROTOCOL;
    private String storeProtocolClass = DEF_VAL_STORE_PROTOCOL_CLASS;
    private String transportProtocol = DEF_VAL_TRANSPORT_PROTOCOL;
    private String transportProtocolClass = DEF_VAL_TRANSPORT_PROTOCOL_CLASS;
    private String mailHost = DEF_VAL_HOST;
    private String username = DEF_VAL_USER;
    private String mailFrom = DEF_VAL_FROM;
    private boolean debug = DEF_VAL_DEBUG;
    private Properties mailProperties = new Properties();
    static Logger _logger = DOLUtils.getDefaultLogger();

    public MailConfiguration(String username, String mailFrom) {
        this.username = username;
        this.mailFrom = mailFrom;
        this.mailHost = "";
        this.mailProperties.put(MAIL_FROM, this.getMailFrom());
        this.mailProperties.put(MAIL_USER, this.getUsername());
        this.mailProperties.put(MAIL_HOST, this.getMailHost());
    }

    public MailConfiguration(String username, String mailFrom, String mailHost) {
        this.username = username;
        this.mailFrom = mailFrom;
        this.mailHost = mailHost;
        this.mailProperties.put(MAIL_FROM, this.getMailFrom());
        this.mailProperties.put(MAIL_USER, this.getUsername());
        this.mailProperties.put(MAIL_HOST, this.getMailHost());
    }

    public MailConfiguration(MailResourceIntf mailRes) {
        try {
            this.loadMailResources(mailRes);
        }
        catch (Exception ce) {
            _logger.log(Level.INFO, "enterprise.deployment_mail_cfgexcp", ce);
        }
    }

    private void loadMailResources(MailResourceIntf mailResource) throws Exception {
        if (mailResource == null) {
            _logger.log(Level.FINE, "MailConfiguration: no MailResource object. mailResource=null");
            return;
        }
        this.jndiName = mailResource.getName();
        this.description = mailResource.getDescription();
        this.enabled = mailResource.isEnabled();
        this.storeProtocol = mailResource.getStoreProtocol();
        this.storeProtocolClass = mailResource.getStoreProtocolClass();
        this.transportProtocol = mailResource.getTransportProtocol();
        this.transportProtocolClass = mailResource.getTransportProtocolClass();
        this.mailHost = mailResource.getMailHost();
        this.username = mailResource.getUsername();
        this.mailFrom = mailResource.getMailFrom();
        this.debug = mailResource.isDebug();
        String storeProtocolClassName = MAIL_PREFIX + this.storeProtocol + MAIL_SUFFIX_CLASS;
        String transportProtocolClassName = MAIL_PREFIX + this.transportProtocol + MAIL_SUFFIX_CLASS;
        this.mailProperties.put(MAIL_STORE_PROTOCOL, this.storeProtocol);
        this.mailProperties.put(MAIL_TRANSPORT_PROTOCOL, this.transportProtocol);
        this.mailProperties.put(storeProtocolClassName, this.storeProtocolClass);
        this.mailProperties.put(transportProtocolClassName, this.transportProtocolClass);
        this.mailProperties.put(MAIL_FROM, this.mailFrom);
        this.mailProperties.put(MAIL_DEBUG, this.debug ? "true" : "false");
        Set properties = mailResource.getProperties();
        ResourceProperty property2 = null;
        String name = null;
        String value = null;
        String protRelatedHostName = MAIL_PREFIX + this.storeProtocol + MAIL_SUFFIX_HOST;
        String protRelatedUserName = MAIL_PREFIX + this.storeProtocol + MAIL_SUFFIX_USER;
        for (ResourceProperty property2 : properties) {
            name = property2.getName();
            value = (String)property2.getValue();
            if (name.startsWith(PROP_NAME_PREFIX_LEGACY)) {
                name = name.replace(PROP_NAME_DELIM_LEGACY, MAIL_DELIM);
            }
            if (!name.startsWith(MAIL_PREFIX)) continue;
            if (name.equals(protRelatedHostName)) {
                this.mailHost = value;
            } else if (name.equals(protRelatedUserName)) {
                this.username = value;
            }
            this.mailProperties.put(name, value);
        }
        this.mailProperties.put(MAIL_HOST, this.mailHost);
        this.mailProperties.put(MAIL_USER, this.username);
    }

    public String getUsername() {
        return this.username;
    }

    public String getMailFrom() {
        return this.mailFrom;
    }

    public String getMailHost() {
        return this.mailHost;
    }

    public String getMailStoreProtocol() {
        return this.storeProtocol;
    }

    public String getMailTransportProtocol() {
        return this.transportProtocol;
    }

    public String getMailStoreProtocolClass() {
        return this.storeProtocolClass;
    }

    public String getMailTransportProtocolClass() {
        return this.transportProtocolClass;
    }

    public boolean getMailDebug() {
        return this.debug;
    }

    public String getDescription() {
        return this.description;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public Properties getMailProperties() {
        return this.mailProperties;
    }

    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("MailConfiguration: [");
        toStringBuffer.append("description=").append(this.description);
        toStringBuffer.append(", jndiName=").append(this.jndiName);
        toStringBuffer.append(", enabled=").append(this.enabled);
        toStringBuffer.append(", storeProtocol=").append(this.storeProtocol);
        toStringBuffer.append(", transportProtocol=").append(this.transportProtocol);
        toStringBuffer.append(", storeProtocolClass=").append(this.storeProtocolClass);
        toStringBuffer.append(", transportProtocolClass=").append(this.transportProtocolClass);
        toStringBuffer.append(", mailHost=").append(this.mailHost);
        toStringBuffer.append(", username=").append(this.username);
        toStringBuffer.append(", mailFrom=").append(this.mailFrom);
        toStringBuffer.append(", debug=").append(this.debug);
        toStringBuffer.append(", mailProperties: [");
        Enumeration<?> e = this.mailProperties.propertyNames();
        boolean isFirst = true;
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.mailProperties.getProperty(name);
            if (isFirst) {
                toStringBuffer.append(name).append("=").append(value);
                isFirst = false;
                continue;
            }
            toStringBuffer.append(", ").append(name).append("=").append(value);
        }
        toStringBuffer.append("]]");
    }
}

