/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.spi.distributed;

import com.sun.ejb.spi.distributed.DistributedReadOnlyBeanNotifier;
import com.sun.ejb.spi.distributed.DistributedReadOnlyBeanService;
import com.sun.ejb.spi.distributed.ReadOnlyBeanRefreshEventHandler;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class DistributedReadOnlyBeanServiceImpl
implements DistributedReadOnlyBeanService {
    private Logger _logger = LogDomains.getLogger(DistributedReadOnlyBeanServiceImpl.class, "javax.enterprise.system.container.ejb");
    private ConcurrentHashMap<Long, ReadOnlyBeanRefreshHandlerInfo> refreshHandlers = new ConcurrentHashMap();
    private DistributedReadOnlyBeanNotifier robNotifier;

    DistributedReadOnlyBeanServiceImpl() {
    }

    public void setDistributedReadOnlyBeanNotifier(DistributedReadOnlyBeanNotifier notifier) {
        this.robNotifier = notifier;
        this._logger.log(Level.INFO, "Registered ReadOnlyBeanNotifier: " + notifier);
    }

    public void addReadOnlyBeanRefreshEventHandler(long ejbID, ClassLoader loader, ReadOnlyBeanRefreshEventHandler handler) {
        this.refreshHandlers.put(ejbID, new ReadOnlyBeanRefreshHandlerInfo(ejbID, loader, handler));
        this._logger.log(Level.INFO, "Registered ReadOnlyBeanRefreshEventHandler: " + ejbID + "; " + handler);
    }

    public void removeReadOnlyBeanRefreshEventHandler(long ejbID) {
        this.refreshHandlers.remove(ejbID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void notifyRefresh(long ejbID, Object pk) {
        block20: {
            block21: {
                IOException ioEx222;
                ObjectOutputStream oos;
                ByteArrayOutputStream bos;
                block18: {
                    if (this.robNotifier == null) break block21;
                    byte[] pkData = null;
                    bos = null;
                    oos = null;
                    bos = new ByteArrayOutputStream();
                    oos = new ObjectOutputStream(bos);
                    oos.writeObject(pk);
                    oos.flush();
                    bos.flush();
                    pkData = bos.toByteArray();
                    this.robNotifier.notifyRefresh(ejbID, pkData);
                    Object var9_6 = null;
                    if (oos == null) break block18;
                    try {
                        oos.close();
                    }
                    catch (IOException ioEx222) {
                        // empty catch block
                    }
                }
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException ioEx222) {}
                }
                break block20;
                {
                    catch (Exception ex) {
                        IOException ioEx222;
                        this._logger.log(Level.WARNING, "Error during notifyRefresh", ex);
                        Object var9_7 = null;
                        if (oos != null) {
                            try {
                                oos.close();
                            }
                            catch (IOException ioEx222) {
                                // empty catch block
                            }
                        }
                        if (bos != null) {
                            try {
                                bos.close();
                            }
                            catch (IOException ioEx222) {}
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    IOException ioEx222;
                    Object var9_8 = null;
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (IOException ioEx222) {
                            // empty catch block
                        }
                    }
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException ioEx222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "DistributedReadOnlyBeanService ignoring request for notifyRefresh: " + ejbID);
            }
        }
    }

    public void notifyRefreshAll(long ejbID) {
        if (this.robNotifier != null) {
            this.robNotifier.notifyRefreshAll(ejbID);
        } else if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "DistributedReadOnlyBeanService ignoring request for notifyRefreshAll: " + ejbID);
        }
    }

    public void handleRefreshRequest(long ejbID, byte[] pkData) {
        this.refreshRequestReceived(false, ejbID, pkData);
    }

    public void handleRefreshAllRequest(long ejbID) {
        this.refreshRequestReceived(true, ejbID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void refreshRequestReceived(boolean refreshAll, long ejbID, byte[] pkData) {
        block41: {
            ClassLoader prevClassLoader;
            Thread currentThread;
            block40: {
                ReadOnlyBeanRefreshHandlerInfo info;
                block42: {
                    Serializable pk;
                    block38: {
                        IOException ioEx2222;
                        ObjectInputStream ois;
                        ByteArrayInputStream bis;
                        block36: {
                            info = this.refreshHandlers.get(ejbID);
                            if (info == null) {
                                return;
                            }
                            currentThread = Thread.currentThread();
                            prevClassLoader = currentThread.getContextClassLoader();
                            if (System.getSecurityManager() == null) {
                                currentThread.setContextClassLoader(info.loader);
                            } else {
                                AccessController.doPrivileged(new PrivilegedAction(){

                                    public Object run() {
                                        currentThread.setContextClassLoader(info.loader);
                                        return null;
                                    }
                                });
                            }
                            if (refreshAll) break block42;
                            bis = null;
                            ois = null;
                            pk = null;
                            bis = new ByteArrayInputStream(pkData);
                            ois = new ObjectInputStream(bis);
                            pk = (Serializable)ois.readObject();
                            Object var13_11 = null;
                            if (ois == null) break block36;
                            try {
                                ois.close();
                            }
                            catch (IOException ioEx2222) {
                                this._logger.log(Level.WARNING, "Error while closing object stream", ioEx2222);
                            }
                        }
                        if (bis != null) {
                            try {
                                bis.close();
                            }
                            catch (IOException ioEx2222) {
                                this._logger.log(Level.WARNING, "Error while closing byte stream", ioEx2222);
                            }
                        }
                        break block38;
                        {
                            catch (IOException ioEx3) {
                                IOException ioEx2222;
                                this._logger.log(Level.WARNING, "Error during refresh", ioEx3);
                                Object var13_12 = null;
                                if (ois != null) {
                                    try {
                                        ois.close();
                                    }
                                    catch (IOException ioEx2222) {
                                        this._logger.log(Level.WARNING, "Error while closing object stream", ioEx2222);
                                    }
                                }
                                if (bis != null) {
                                    try {
                                        bis.close();
                                    }
                                    catch (IOException ioEx2222) {
                                        this._logger.log(Level.WARNING, "Error while closing byte stream", ioEx2222);
                                    }
                                }
                                break block38;
                            }
                            catch (ClassNotFoundException cnfEx) {
                                IOException ioEx2222;
                                this._logger.log(Level.WARNING, "Error during refresh", cnfEx);
                                Object var13_13 = null;
                                if (ois != null) {
                                    try {
                                        ois.close();
                                    }
                                    catch (IOException ioEx2222) {
                                        this._logger.log(Level.WARNING, "Error while closing object stream", ioEx2222);
                                    }
                                }
                                if (bis != null) {
                                    try {
                                        bis.close();
                                    }
                                    catch (IOException ioEx2222) {
                                        this._logger.log(Level.WARNING, "Error while closing byte stream", ioEx2222);
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            IOException ioEx2222;
                            Object var13_14 = null;
                            if (ois != null) {
                                try {
                                    ois.close();
                                }
                                catch (IOException ioEx2222) {
                                    this._logger.log(Level.WARNING, "Error while closing object stream", ioEx2222);
                                }
                            }
                            if (bis != null) {
                                try {
                                    bis.close();
                                }
                                catch (IOException ioEx2222) {
                                    this._logger.log(Level.WARNING, "Error while closing byte stream", ioEx2222);
                                }
                            }
                            throw throwable;
                        }
                    }
                    if (pk != null) {
                        info.handler.handleRefreshRequest(pk);
                    }
                    break block40;
                }
                info.handler.handleRefreshAllRequest();
            }
            Object var16_22 = null;
            if (System.getSecurityManager() == null) {
                currentThread.setContextClassLoader(prevClassLoader);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(currentThread, prevClassLoader){
                    final /* synthetic */ Thread val$currentThread;
                    final /* synthetic */ ClassLoader val$prevClassLoader;
                    {
                        this.val$currentThread = thread;
                        this.val$prevClassLoader = classLoader;
                    }

                    public Object run() {
                        this.val$currentThread.setContextClassLoader(this.val$prevClassLoader);
                        return null;
                    }
                });
                {
                    break block41;
                    catch (Exception ex) {
                        this._logger.log(Level.WARNING, "Error during refresh", ex);
                        Object var16_23 = null;
                        if (System.getSecurityManager() == null) {
                            currentThread.setContextClassLoader(prevClassLoader);
                        } else {
                            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var16_24 = null;
                    if (System.getSecurityManager() == null) {
                        currentThread.setContextClassLoader(prevClassLoader);
                    } else {
                        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                    }
                    throw throwable;
                }
            }
        }
    }

    private static class ReadOnlyBeanRefreshHandlerInfo {
        public long ejbId;
        public ClassLoader loader;
        public ReadOnlyBeanRefreshEventHandler handler;

        public ReadOnlyBeanRefreshHandlerInfo(long ejbId, ClassLoader loader, ReadOnlyBeanRefreshEventHandler handler) {
            this.ejbId = ejbId;
            this.loader = loader;
            this.handler = handler;
        }
    }
}

