/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.HostAndPort;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_change-master-password-das")
@Scoped(value=PerLookup.class)
public class ChangeMasterPasswordCommandDAS
extends LocalDomainCommand {
    @Param(name="domain", primary=true, optional=true)
    protected String domainName0;
    @Param(name="savemasterpassword", optional=true, defaultValue="false")
    protected boolean savemp;
    private static final LocalStringsImpl strings = new LocalStringsImpl(ChangeMasterPasswordCommandDAS.class);

    protected void validate() throws CommandException {
        String dName = this.domainName0 != null ? this.domainName0 : this.getDomainName();
        this.setDomainName(dName);
        super.validate();
    }

    public int execute(String ... argv) throws CommandException {
        return super.execute(argv);
    }

    protected int executeCommand() throws CommandException {
        try {
            HostAndPort adminAddress = this.getAdminAddress();
            if (this.isRunning(adminAddress.getHost(), adminAddress.getPort())) {
                throw new CommandException(strings.get("domain.is.running", this.getDomainName(), this.getDomainRootDir()));
            }
            DomainConfig domainConfig = new DomainConfig(this.getDomainName(), this.getDomainsDir().getAbsolutePath());
            PEDomainsManager manager = new PEDomainsManager();
            String mp = super.readFromMasterPasswordFile();
            if (mp == null && (mp = (String)this.passwords.get("AS_ADMIN_MASTERPASSWORD")) == null) {
                mp = super.readPassword(strings.get("current.mp"));
            }
            if (mp == null) {
                throw new CommandException(strings.get("no.console"));
            }
            if (!super.verifyMasterPassword(mp)) {
                throw new CommandException(strings.get("incorrect.mp"));
            }
            CommandModelData.ParamModelData nmpo = new CommandModelData.ParamModelData("AS_ADMIN_NEWMASTERPASSWORD", String.class, false, null);
            nmpo.description = strings.get("new.mp");
            nmpo.param._password = true;
            String nmp = super.getPassword(nmpo, null, true);
            if (nmp == null) {
                throw new CommandException(strings.get("no.console"));
            }
            domainConfig.put("domain.masterPassword", mp);
            domainConfig.put("domain.newMasterPassword", nmp);
            domainConfig.put("domain.saveMasterPassword", this.savemp);
            manager.changeMasterPassword(domainConfig);
            return 0;
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage(), e);
        }
    }
}

