/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.InterceptorDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.annotation.context.ManagedBeanContext;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.deployment.util.TypeUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.ManagedBean;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ProcessingContext;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ManagedBeanHandler
extends AbstractHandler {
    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return ManagedBean.class;
    }

    @Override
    public HandlerProcessingResult processAnnotation(AnnotationInfo element) throws AnnotationProcessorException {
        AnnotatedElementHandler aeHandler = element.getProcessingContext().getHandler();
        if (aeHandler instanceof ManagedBeanContext) {
            return this.getDefaultProcessedResult();
        }
        ManagedBeanDescriptor managedBeanDesc = new ManagedBeanDescriptor();
        ManagedBean resourceAn = (ManagedBean)element.getAnnotation();
        String logicalName = resourceAn.value();
        if (!logicalName.equals("")) {
            managedBeanDesc.setName(logicalName);
        }
        Class managedBeanClass = (Class)element.getAnnotatedElement();
        managedBeanDesc.setBeanClassName(managedBeanClass.getName());
        Class[] classInterceptors = null;
        HashMap<Method, Class[]> methodLevelInterceptors = new HashMap<Method, Class[]>();
        HashMap<String, InterceptorDescriptor> interceptorDescs = new HashMap<String, InterceptorDescriptor>();
        Annotation interceptorsAnn = this.getClassAnnotation(managedBeanClass, "javax.interceptor.Interceptors");
        if (interceptorsAnn != null) {
            try {
                Method m = interceptorsAnn.annotationType().getDeclaredMethod("value", new Class[0]);
                classInterceptors = (Class[])m.invoke((Object)interceptorsAnn, new Object[0]);
            }
            catch (Exception e) {
                AnnotationProcessorException ape = new AnnotationProcessorException(e.getMessage(), element);
                ape.initCause(e);
                throw ape;
            }
        }
        for (Class nextIntClass = managedBeanClass; nextIntClass != Object.class; nextIntClass = nextIntClass.getSuperclass()) {
            Method managedBeanAroundInvoke = this.getMethodForMethodAnnotation(nextIntClass, "javax.interceptor.AroundInvoke");
            if (managedBeanAroundInvoke == null || this.methodOverridden(managedBeanAroundInvoke, nextIntClass, managedBeanClass)) continue;
            LifecycleCallbackDescriptor desc = new LifecycleCallbackDescriptor();
            desc.setLifecycleCallbackClass(nextIntClass.getName());
            desc.setLifecycleCallbackMethod(managedBeanAroundInvoke.getName());
            managedBeanDesc.addAroundInvokeDescriptor(desc);
        }
        for (Method m : managedBeanClass.getMethods()) {
            boolean excludeClassInterceptors;
            Annotation ann = this.getMethodAnnotation(m, "javax.interceptor.Interceptors");
            if (ann != null) {
                try {
                    Method valueM = ann.annotationType().getDeclaredMethod("value", new Class[0]);
                    methodLevelInterceptors.put(m, (Class[])valueM.invoke((Object)ann, new Object[0]));
                    continue;
                }
                catch (Exception e) {
                    AnnotationProcessorException ape = new AnnotationProcessorException(e.getMessage(), element);
                    ape.initCause(e);
                    throw ape;
                }
            }
            boolean bl = excludeClassInterceptors = this.getMethodAnnotation(m, "javax.interceptor.ExcludeClassInterceptors") != null;
            if (!excludeClassInterceptors) continue;
            MethodDescriptor mDesc = new MethodDescriptor(m);
            managedBeanDesc.setMethodLevelInterceptorChain(mDesc, new LinkedList<InterceptorDescriptor>());
        }
        if (aeHandler instanceof ResourceContainerContext) {
            ((ResourceContainerContext)((Object)aeHandler)).addManagedBean(managedBeanDesc);
            ManagedBeanContext managedBeanContext = new ManagedBeanContext(managedBeanDesc);
            ProcessingContext procContext = element.getProcessingContext();
            procContext.pushHandler(managedBeanContext);
            procContext.getProcessor().process(procContext, new Class[]{managedBeanClass});
            LinkedList<InterceptorDescriptor> classInterceptorChain = new LinkedList<InterceptorDescriptor>();
            if (classInterceptors != null) {
                for (Class i : classInterceptors) {
                    InterceptorDescriptor nextInterceptor = this.processInterceptor(i, managedBeanContext, procContext);
                    classInterceptorChain.add(nextInterceptor);
                    interceptorDescs.put(i.getName(), nextInterceptor);
                }
                managedBeanDesc.setClassInterceptorChain(classInterceptorChain);
            }
            for (Map.Entry next : methodLevelInterceptors.entrySet()) {
                Method m = (Method)next.getKey();
                Class[] interceptors = (Class[])next.getValue();
                boolean excludeClassInterceptors = this.getMethodAnnotation(m, "javax.interceptor.ExcludeClassInterceptors") != null;
                LinkedList<InterceptorDescriptor> methodInterceptorChain = excludeClassInterceptors ? new LinkedList<InterceptorDescriptor>() : new LinkedList<InterceptorDescriptor>(classInterceptorChain);
                for (Class nextInterceptor : interceptors) {
                    InterceptorDescriptor interceptorDesc = (InterceptorDescriptor)interceptorDescs.get(nextInterceptor.getName());
                    if (interceptorDesc == null) {
                        interceptorDesc = this.processInterceptor(nextInterceptor, managedBeanContext, procContext);
                        interceptorDescs.put(nextInterceptor.getName(), interceptorDesc);
                    }
                    methodInterceptorChain.add(interceptorDesc);
                }
                MethodDescriptor mDesc = new MethodDescriptor(m);
                managedBeanDesc.setMethodLevelInterceptorChain(mDesc, methodInterceptorChain);
            }
        }
        return this.getDefaultProcessedResult();
    }

    private InterceptorDescriptor processInterceptor(Class interceptorClass, ManagedBeanContext managedBeanCtx, ProcessingContext procCtx) throws AnnotationProcessorException {
        InterceptorDescriptor interceptorDesc = new InterceptorDescriptor();
        interceptorDesc.setInterceptorClassName(interceptorClass.getName());
        managedBeanCtx.setInterceptorMode(interceptorDesc);
        procCtx.pushHandler(managedBeanCtx);
        procCtx.getProcessor().process(procCtx, new Class[]{interceptorClass});
        managedBeanCtx.unsetInterceptorMode();
        for (Class nextIntClass = interceptorClass; nextIntClass != Object.class; nextIntClass = nextIntClass.getSuperclass()) {
            Method interceptorAroundInvoke = this.getMethodForMethodAnnotation(nextIntClass, "javax.interceptor.AroundInvoke");
            if (interceptorAroundInvoke == null || this.methodOverridden(interceptorAroundInvoke, nextIntClass, interceptorClass)) continue;
            LifecycleCallbackDescriptor desc = new LifecycleCallbackDescriptor();
            desc.setLifecycleCallbackClass(nextIntClass.getName());
            desc.setLifecycleCallbackMethod(interceptorAroundInvoke.getName());
            interceptorDesc.addAroundInvokeDescriptor(desc);
        }
        return interceptorDesc;
    }

    private Annotation getClassAnnotation(Class c, String annotationClassName) {
        for (Annotation next : c.getDeclaredAnnotations()) {
            if (!next.annotationType().getName().equals(annotationClassName)) continue;
            return next;
        }
        return null;
    }

    private Method getMethodForMethodAnnotation(Class c, String annotationClassName) {
        for (Method m : c.getDeclaredMethods()) {
            for (Annotation next : m.getDeclaredAnnotations()) {
                if (!next.annotationType().getName().equals(annotationClassName)) continue;
                return m;
            }
        }
        return null;
    }

    private Annotation getMethodAnnotation(Method m, String annotationClassName) {
        for (Annotation next : m.getDeclaredAnnotations()) {
            if (!next.annotationType().getName().equals(annotationClassName)) continue;
            return next;
        }
        return null;
    }

    private boolean methodOverridden(Method m, Class declaringSuperClass, Class leafClass) {
        boolean overridden = false;
        if (Modifier.isPrivate(m.getModifiers())) {
            return false;
        }
        for (Class nextClass = leafClass; nextClass != declaringSuperClass && nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            for (Method nextMethod : nextClass.getDeclaredMethods()) {
                if (Modifier.isPrivate(nextMethod.getModifiers()) || !TypeUtil.sameMethodSignature(m, nextMethod)) continue;
                overridden = true;
                break;
            }
            if (overridden) break;
        }
        return overridden;
    }
}

