/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.osgi;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.glassfish.bootstrap.Constants;
import com.sun.enterprise.glassfish.bootstrap.osgi.BundleProvisioner;
import com.sun.enterprise.glassfish.bootstrap.osgi.OSGiFrameworkLauncher;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.embeddable.spi.RuntimeBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;

public final class OSGiGlassFishRuntimeBuilder
implements RuntimeBuilder {
    private Framework framework;
    private Properties properties;
    private Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
    private Properties oldProvisioningOptions;
    private Properties newProvisioningOptions;
    private OSGiFrameworkLauncher fwLauncher;

    public GlassFishRuntime build(BootstrapProperties bsProps) throws GlassFishException {
        try {
            ASMainHelper.buildStartupContext(bsProps.getProperties());
            this.properties = bsProps.getProperties();
            this.properties.setProperty("GlassFish.BUILDER_NAME", this.getClass().getName());
            long t0 = System.currentTimeMillis();
            this.fwLauncher = new OSGiFrameworkLauncher(this.properties);
            this.framework = this.fwLauncher.launchOSGiFrameWork();
            long t1 = System.currentTimeMillis();
            this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "build", "Launched {0}", new Object[]{this.framework});
            if (this.newFramework()) {
                this.storeProvisioningOptions();
            } else {
                this.reconfigure();
            }
            BundleProvisioner bundleProvisioner = new BundleProvisioner(this.framework.getBundleContext(), this.properties);
            List<Long> bundleIds = bundleProvisioner.installBundles();
            if (bundleProvisioner.hasAnyThingChanged()) {
                bundleProvisioner.refresh();
                this.deleteHK2Cache();
                this.storeBundleIds(bundleIds.toArray(new Long[bundleIds.size()]));
            }
            if (bundleProvisioner.isSystemBundleUpdationRequired()) {
                this.logger.logp(Level.INFO, "OSGiFrameworkLauncher", "launchOSGiFrameWork", "Updating system bundle");
                this.framework.update();
            }
            bundleProvisioner.startBundles();
            long t2 = System.currentTimeMillis();
            this.framework.start();
            long t3 = System.currentTimeMillis();
            this.printStats(bundleProvisioner, t0, t1, t2, t3);
            return this.getGlassFishRuntime();
        }
        catch (Exception e) {
            throw new GlassFishException(e);
        }
    }

    public boolean handles(BootstrapProperties bsProps) {
        String builderName = bsProps.getProperty("GlassFish.BUILDER_NAME");
        if (builderName != null && !builderName.equals(this.getClass().getName())) {
            return false;
        }
        String platformStr = bsProps.getProperty("GlassFish_Platform");
        if (platformStr != null && platformStr.trim().length() != 0) {
            try {
                Constants.Platform platform = Constants.Platform.valueOf(platformStr);
                switch (platform) {
                    case Felix: 
                    case Equinox: 
                    case Knopflerfish: {
                        return true;
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        return false;
    }

    private GlassFishRuntime getGlassFishRuntime() throws GlassFishException {
        ServiceReference reference = this.framework.getBundleContext().getServiceReference(GlassFishRuntime.class.getName());
        if (reference != null) {
            GlassFishRuntime gfr = (GlassFishRuntime)this.framework.getBundleContext().getService(reference);
            return gfr;
        }
        throw new GlassFishException("No GlassFishRuntime available");
    }

    private void deleteHK2Cache() {
        File inhabitantsCache;
        String cacheDir = this.properties.getProperty("com.sun.enterprise.hk2.cacheDir");
        if (cacheDir != null && (inhabitantsCache = new File(cacheDir, "inhabitants")).exists()) {
            inhabitantsCache.delete();
        }
    }

    private void printStats(BundleProvisioner bundleProvisioner, long t0, long t1, long t2, long t3) {
        this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "build", "installed = {0}, updated = {1}, uninstalled = {2}", new Object[]{bundleProvisioner.getNoOfInstalledBundles(), bundleProvisioner.getNoOfUpdatedBundles(), bundleProvisioner.getNoOfUninstalledBundles()});
        this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "build", "Total time taken (in ms) to initialize framework = {0}, to install/update/delete/start bundles = {1}, to start framework= {2}", new Object[]{t1 - t0, t2 - t1, t3 - t2});
    }

    private boolean newFramework() {
        return this.framework.getBundleContext().getBundles().length == 1;
    }

    private void reconfigure() throws Exception {
        if (this.hasBeenReconfigured()) {
            this.logger.logp(Level.INFO, "OSGiGlassFishRuntimeBuilder", "reconfigure", "Provisioning options have changed, recreating the framework");
            this.framework.stop();
            this.framework.waitForStop(0L);
            this.properties.setProperty("org.osgi.framework.storage.clean", "onFirstInit");
            this.fwLauncher = new OSGiFrameworkLauncher(this.properties);
            this.framework = this.fwLauncher.launchOSGiFrameWork();
            this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "reconfigure", "Launched {0}", new Object[]{this.framework});
            this.storeProvisioningOptions();
        }
    }

    private void uninstallOldBundles() {
        Long[] ids = this.readBundleIds();
        if (ids.length == 0) {
            for (Long l : this.framework.getBundleContext().getBundles()) {
                if (l == this.framework) continue;
                this.uninstallBundle((Bundle)l);
            }
        }
        for (Long l : ids) {
            this.uninstallBundle(l);
        }
    }

    private void uninstallBundle(Long id) {
        Bundle b = this.framework.getBundleContext().getBundle(id.longValue());
        if (b != null) {
            this.uninstallBundle(b);
        } else {
            this.logger.logp(Level.WARNING, "OSGiGlassFishRuntimeBuilder", "uninstallBundle", "Unable to locate bundle {0}", new Object[]{id});
        }
    }

    private void uninstallBundle(Bundle b) {
        try {
            b.uninstall();
            this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "uninstallBundle", "Uninstalled {0}", new Object[]{b});
        }
        catch (BundleException e) {
            e.printStackTrace();
        }
    }

    private boolean hasBeenReconfigured() {
        try {
            this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "hasBeenReconfigured", "oldProvisioningOptions = {0}", new Object[]{this.getOldProvisioningOptions()});
            this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "hasBeenReconfigured", "newProvisioningOptions = {0}", new Object[]{this.getNewProvisioningOptions()});
            return !this.getNewProvisioningOptions().equals(this.getOldProvisioningOptions());
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
    }

    private Properties getNewProvisioningOptions() {
        if (this.newProvisioningOptions == null) {
            Properties props = new Properties();
            for (String key : this.properties.stringPropertyNames()) {
                if (!key.equals("glassfish.osgi.auto.install") && !key.equals("glassfish.osgi.auto.start") && !key.startsWith("glassfish.osgi.auto.start.level")) continue;
                props.setProperty(key, this.properties.getProperty(key));
            }
            this.newProvisioningOptions = props;
        }
        return this.newProvisioningOptions;
    }

    private void storeBundleIds(Long[] bundleIds) {
        try {
            File f = this.framework.getBundleContext().getDataFile("glassfish.bundleids");
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(f));
            os.writeObject(bundleIds);
            os.flush();
            os.close();
            this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "storeBundleIds", "Stored bundle ids in {0}", new Object[]{f.getAbsolutePath()});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long[] readBundleIds() {
        try {
            Long[] result;
            File f = this.framework.getBundleContext().getDataFile("glassfish.bundleids");
            if (!f.exists()) {
                return new Long[0];
            }
            ObjectInputStream is = new ObjectInputStream(new FileInputStream(f));
            try {
                result = (Long[])is.readObject();
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                is.close();
                throw throwable;
            }
            is.close();
            this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "readBundleIds", "Read bundle ids from {0}", new Object[]{f.getAbsolutePath()});
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Long[0];
        }
    }

    private void storeProvisioningOptions() {
        try {
            File f = this.framework.getBundleContext().getDataFile("provisioning.properties");
            FileOutputStream os = new FileOutputStream(f);
            this.getNewProvisioningOptions().store(os, "");
            os.flush();
            os.close();
            this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "storeProvisioningOptions", "Stored provisioning options in {0}", new Object[]{f.getAbsolutePath()});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Properties getOldProvisioningOptions() throws IOException {
        if (this.oldProvisioningOptions == null) {
            Properties options = new Properties();
            try {
                File f = this.framework.getBundleContext().getDataFile("provisioning.properties");
                if (f.exists()) {
                    options.load(new FileInputStream(f));
                    this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "getOldProvisioningOptions", "Read provisioning options from {0}", new Object[]{f.getAbsolutePath()});
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.oldProvisioningOptions = options;
        }
        return this.oldProvisioningOptions;
    }
}

