/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.resource.common.PoolInfo;
import org.glassfish.resource.common.ResourceInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class JdbcResourceDeployer
implements ResourceDeployer {
    @Inject
    private ConnectorRuntime runtime;
    private static final StringManager localStrings = StringManager.getManager(JdbcResourceDeployer.class);
    private static Logger _logger = LogDomains.getLogger(JdbcResourceDeployer.class, "javax.enterprise.resource.resourceadapter");

    public synchronized void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        JdbcResource jdbcRes = (JdbcResource)resource;
        String jndiName = jdbcRes.getJndiName();
        String poolName = jdbcRes.getPoolName();
        PoolInfo poolInfo = new PoolInfo(poolName, applicationName, moduleName);
        ResourceInfo resourceInfo = new ResourceInfo(jndiName, applicationName, moduleName);
        if (ResourcesUtil.createInstance().isEnabled(jdbcRes, resourceInfo)) {
            this.runtime.createConnectorResource(resourceInfo, poolInfo, null);
            if (ConnectorsUtil.getValidSuffix(jndiName) == null) {
                ResourceInfo pmResourceInfo = new ResourceInfo(ConnectorsUtil.getPMJndiName(jndiName), resourceInfo.getApplicationName(), resourceInfo.getModuleName());
                this.runtime.createConnectorResource(pmResourceInfo, poolInfo, null);
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("deployed resource " + jndiName);
            }
        } else {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{jdbcRes.getJndiName(), "jdbc"});
        }
    }

    public void deployResource(Object resource) throws Exception {
        JdbcResource jdbcRes = (JdbcResource)resource;
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo(jdbcRes);
        this.deployResource(jdbcRes, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
    }

    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
        JdbcResource jdbcRes = (JdbcResource)resource;
        ResourceInfo resourceInfo = new ResourceInfo(jdbcRes.getJndiName(), applicationName, moduleName);
        this.deleteResource(jdbcRes, resourceInfo);
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        JdbcResource jdbcRes = (JdbcResource)resource;
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo(jdbcRes);
        this.deleteResource(jdbcRes, resourceInfo);
    }

    private void deleteResource(JdbcResource jdbcResource, ResourceInfo resourceInfo) throws Exception {
        if (ResourcesUtil.createInstance().isEnabled(jdbcResource, resourceInfo)) {
            this.runtime.deleteConnectorResource(resourceInfo);
            ConnectorRegistry.getInstance().removeResourceFactories(resourceInfo);
            if (ConnectorsUtil.getValidSuffix(resourceInfo.getName()) == null) {
                String pmJndiName = ConnectorsUtil.getPMJndiName(resourceInfo.getName());
                ResourceInfo pmResourceInfo = new ResourceInfo(pmJndiName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
                this.runtime.deleteConnectorResource(pmResourceInfo);
                ConnectorRegistry.getInstance().removeResourceFactories(pmResourceInfo);
            }
            this.checkAndDeletePool(jdbcResource);
        } else {
            _logger.log(Level.FINEST, "core.resource_disabled", new Object[]{jdbcResource.getJndiName(), "jdbc"});
        }
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public boolean handles(Object resource) {
        return resource instanceof JdbcResource;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    private void checkAndDeletePool(JdbcResource cr) throws Exception {
        String poolName = cr.getPoolName();
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo(cr);
        PoolInfo poolInfo = new PoolInfo(poolName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
        Resources resources = (Resources)cr.getParent();
        if (resources != null) {
            try {
                boolean poolReferred = ResourcesUtil.createInstance().isJdbcPoolReferredInServerInstance(poolInfo);
                if (!poolReferred) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("Deleting JDBC pool [" + poolName + " ] as there are no more " + "resource-refs to the pool in this server instance");
                    }
                    JdbcConnectionPool jcp = (JdbcConnectionPool)resources.getResourceByName(JdbcConnectionPool.class, poolName);
                    this.runtime.getResourceDeployer(jcp).undeployResource(jcp);
                }
            }
            catch (Exception ce) {
                _logger.warning(ce.getMessage());
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Exception while deleting pool [ " + poolName + " ] : " + ce);
                }
                throw ce;
            }
        }
    }
}

