/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.nonce;

import com.sun.enterprise.security.auth.nonce.DefaultNonceManager;
import com.sun.enterprise.security.auth.nonce.Nonce;
import com.sun.logging.LogDomains;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public abstract class NonceManager {
    private static Map<String, NonceManager> nonceMgrMap = null;
    private long maxNonceAge;
    private static final Logger logger = LogDomains.getLogger(NonceManager.class, "javax.enterprise.system.core.security");

    public long getMaxNonceAge() {
        return this.maxNonceAge;
    }

    public void setMaxNonceAge(long maxNonceAge) {
        this.maxNonceAge = maxNonceAge;
    }

    public abstract boolean validateNonce(Nonce var1) throws NonceException;

    public abstract boolean hasNonce(Nonce var1);

    public abstract boolean validateNonce(Nonce var1, String var2) throws NonceException;

    public static synchronized NonceManager getInstance(String id, long maxNonceAge) {
        if (nonceMgrMap == null) {
            nonceMgrMap = new HashMap<String, NonceManager>();
        }
        if (nonceMgrMap.get(id) != null) {
            return nonceMgrMap.get(id);
        }
        DefaultNonceManager nonceMgr = new DefaultNonceManager();
        nonceMgr.setMaxNonceAge(maxNonceAge);
        nonceMgrMap.put(id, nonceMgr);
        return nonceMgr;
    }

    public static synchronized NonceManager getInstance(String className, String id, long maxNonceAge) {
        try {
            if (nonceMgrMap == null) {
                nonceMgrMap = new HashMap<String, NonceManager>();
            }
            if (nonceMgrMap.get(id) != null) {
                return nonceMgrMap.get(id);
            }
            Class<?> nonceMgrClass = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                nonceMgrClass = classLoader.loadClass(className);
            }
            if (nonceMgrClass == null) {
                nonceMgrClass = Class.forName(className);
            }
            NonceManager nonceMgr = (NonceManager)nonceMgrClass.newInstance();
            nonceMgr.setMaxNonceAge(maxNonceAge);
            nonceMgrMap.put(id, nonceMgr);
            return nonceMgr;
        }
        catch (ClassNotFoundException x) {
            throw new RuntimeException("The NonceManager class: " + className + " specified was not found", x);
        }
        catch (Exception e) {
            throw new RuntimeException("The NonceManager class: " + className + " could not be instantiated ", e);
        }
    }

    public static Map getProperties(String value) {
        String[] values;
        HashMap<String, String> map = new HashMap<String, String>();
        String delim = "(\\s)*;(\\s)*";
        String localDelim = "(\\s)*,(\\s)*";
        String equalDelim = "(\\s)*=(\\s)*";
        String id = null;
        String nonceAge = null;
        for (String s : values = value.split(delim)) {
            String[] eachNonceProperty;
            for (String eachProperty : eachNonceProperty = s.split(localDelim)) {
                String[] nameValue = eachProperty.split(equalDelim);
                if (nameValue[0].equalsIgnoreCase("id")) {
                    id = nameValue[1];
                    continue;
                }
                if (!nameValue[0].equalsIgnoreCase("maxNonceAge")) continue;
                nonceAge = nameValue[1];
            }
            if (id == null || nonceAge == null) continue;
            map.put(id, nonceAge);
        }
        return map;
    }

    public static class NonceException
    extends SecurityException {
        public NonceException(String message) {
            super(message);
        }

        public NonceException(String message, Throwable cause) {
            super(message, cause);
        }

        public NonceException(Throwable cause) {
            super(cause);
        }
    }
}

