/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.certificate;

import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.auth.login.DistinguishedPrincipalCredential;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.IASRealm;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import org.glassfish.security.common.Group;
import org.jvnet.hk2.annotations.Service;
import sun.security.x509.X500Name;

@Service
public final class CertificateRealm
extends IASRealm {
    public static final String AUTH_TYPE = "certificate";
    private Vector<String> defaultGroups = new Vector();

    protected void init(Properties props) throws BadRealmException, NoSuchRealmException {
        String jaasCtx;
        super.init(props);
        String[] groups = this.addAssignGroups(null);
        if (groups != null && groups.length > 0) {
            for (String gp : groups) {
                this.defaultGroups.add(gp);
            }
        }
        if ((jaasCtx = props.getProperty("jaas-context")) != null) {
            this.setProperty("jaas-context", jaasCtx);
        }
    }

    public String getAuthType() {
        return AUTH_TYPE;
    }

    public Enumeration getGroupNames(String username) throws NoSuchUserException, InvalidOperationException {
        return this.defaultGroups.elements();
    }

    public void authenticate(Subject subject, X500Name x500name) {
        String name = x500name.getName();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Certificate realm setting up security context for: " + name);
        }
        if (this.defaultGroups != null) {
            Set<Principal> principalSet = subject.getPrincipals();
            Enumeration<String> e = this.defaultGroups.elements();
            while (e.hasMoreElements()) {
                principalSet.add(new Group(e.nextElement()));
            }
        }
        if (!subject.getPrincipals().isEmpty()) {
            DistinguishedPrincipalCredential dpc = new DistinguishedPrincipalCredential(x500name);
            subject.getPublicCredentials().add(dpc);
        }
        SecurityContext securityContext = new SecurityContext(name, subject);
        SecurityContext.setCurrent(securityContext);
    }

    public static final class AppContextCallback
    implements Callback {
        private String moduleID;

        public String getModuleID() {
            return this.moduleID;
        }

        public void setModuleID(String moduleID) {
            this.moduleID = moduleID;
        }
    }
}

