/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.cluster.windows.io;

import com.sun.enterprise.util.cluster.windows.process.WindowsCredentials;
import java.net.InetAddress;
import jcifs.smb.NtlmPasswordAuthentication;

public class WindowsRemoteFileSystem {
    private final String host;
    private final NtlmPasswordAuthentication authorization;

    public WindowsRemoteFileSystem(WindowsCredentials cr) {
        this.host = this.getIP(cr.getHost());
        this.authorization = new NtlmPasswordAuthentication(this.host, cr.getUser(), cr.getPassword());
    }

    public WindowsRemoteFileSystem(String hostname, NtlmPasswordAuthentication auth) {
        this.host = this.getIP(hostname);
        this.authorization = auth;
    }

    public WindowsRemoteFileSystem(String hostname, String username, String password) {
        this.host = this.getIP(hostname);
        this.authorization = new NtlmPasswordAuthentication(this.host, username, password);
    }

    public String getHost() {
        return this.host;
    }

    public NtlmPasswordAuthentication getAuthorization() {
        return this.authorization;
    }

    private String getIP(String hostname) {
        try {
            return InetAddress.getByName(hostname).getHostAddress();
        }
        catch (Exception e) {
            return hostname;
        }
    }
}

