/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster.dcom;

import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.cluster.RemoteType;
import com.sun.enterprise.v3.admin.cluster.CreateRemoteNodeCommand;
import com.sun.enterprise.v3.admin.cluster.dcom.Strings;
import java.util.List;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.cluster.ssh.util.DcomUtils;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="create-node-dcom")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
public class CreateNodeDcom
extends CreateRemoteNodeCommand {
    @Param(name="windowsuser", shortName="w", optional=true, defaultValue="${user.name}")
    private String windowsuser;
    @Param(name="windowspassword", optional=true, password=true)
    private String windowspassword;
    @Param(name="windowsdomain", shortName="d", optional=true)
    private String windowsdomain;

    @Override
    protected void initialize() {
        if (!StringUtils.ok(this.windowsdomain)) {
            this.windowsdomain = this.nodehost;
        }
    }

    @Override
    public final void execute(AdminCommandContext context) {
        this.executeInternal(context);
    }

    @Override
    protected void validate() throws CommandValidationException {
        if (!StringUtils.ok(this.windowspassword)) {
            throw new CommandValidationException(Strings.get("update.node.dcom.no.password"));
        }
    }

    @Override
    protected RemoteType getType() {
        return RemoteType.DCOM;
    }

    @Override
    protected final void checkDefaults() {
        super.checkDefaults();
        if (!StringUtils.ok(this.remotePort) || this.remotePort.equals("22")) {
            this.remotePort = "135";
        }
    }

    @Override
    protected final void populateBaseClass() {
        this.remotePort = "135";
        this.remoteUser = this.windowsuser;
        this.remotePassword = this.windowspassword;
    }

    @Override
    protected final void populateParameters(ParameterMap pmap) {
        pmap.add("windowsdomain", this.windowsdomain);
    }

    @Override
    protected final void populateCommandArgs(List<String> args) {
        args.add("--windowsuser");
        args.add(this.remoteUser);
        args.add("--windowsdomain");
        args.add(this.windowsdomain);
    }

    @Override
    protected List<String> getPasswords() {
        return DcomUtils.resolvePasswordToList(this.windowspassword);
    }

    @Override
    protected String getInstallNodeCommandName() {
        return "install-node-dcom";
    }
}

