/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ManagerProperties;
import com.sun.enterprise.config.serverbeans.SessionConfig;
import com.sun.enterprise.config.serverbeans.SessionManager;
import com.sun.enterprise.config.serverbeans.SessionProperties;
import com.sun.enterprise.config.serverbeans.StoreProperties;
import com.sun.enterprise.config.serverbeans.WebContainer;
import com.sun.enterprise.config.serverbeans.WebContainerAvailability;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.session.PersistenceType;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.types.Property;

@Service
@Scoped(value=PerLookup.class)
public class ServerConfigLookup {
    protected static final Logger _logger = LogDomains.getLogger(ServerConfigLookup.class, "javax.enterprise.system.container.web");
    @Inject(name="default-instance-name")
    private Config configBean;
    @Inject
    private ClassLoaderHierarchy clh;

    public SessionManager getInstanceSessionManager() {
        if (this.configBean == null) {
            return null;
        }
        WebContainer webContainerBean = this.configBean.getWebContainer();
        if (webContainerBean == null) {
            return null;
        }
        SessionConfig sessionConfigBean = webContainerBean.getSessionConfig();
        if (sessionConfigBean == null) {
            return null;
        }
        return sessionConfigBean.getSessionManager();
    }

    public ManagerProperties getInstanceSessionManagerManagerProperties() {
        SessionManager smBean = this.getInstanceSessionManager();
        if (smBean == null) {
            return null;
        }
        return smBean.getManagerProperties();
    }

    public StoreProperties getInstanceSessionManagerStoreProperties() {
        SessionManager smBean = this.getInstanceSessionManager();
        if (smBean == null) {
            return null;
        }
        return smBean.getStoreProperties();
    }

    public SessionProperties getInstanceSessionProperties() {
        if (this.configBean == null) {
            return null;
        }
        WebContainer webContainerBean = this.configBean.getWebContainer();
        if (webContainerBean == null) {
            return null;
        }
        SessionConfig sessionConfigBean = webContainerBean.getSessionConfig();
        if (sessionConfigBean == null) {
            return null;
        }
        return sessionConfigBean.getSessionProperties();
    }

    protected AvailabilityService getAvailabilityService() {
        return this.configBean.getAvailabilityService();
    }

    public boolean getAvailabilityEnabledFromConfig() {
        AvailabilityService as = this.getAvailabilityService();
        if (as == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("AvailabilityService was not defined - check domain.xml");
            }
            return false;
        }
        Boolean bool = this.toBoolean(as.getAvailabilityEnabled());
        if (bool == null) {
            return false;
        }
        return bool;
    }

    private WebContainerAvailability getWebContainerAvailability() {
        AvailabilityService as = this.getAvailabilityService();
        return as != null ? as.getWebContainerAvailability() : null;
    }

    protected String getWebContainerAvailabilityPropertyString(String propName) {
        return this.getWebContainerAvailabilityPropertyString(propName, null);
    }

    protected String getWebContainerAvailabilityPropertyString(String propName, String defaultValue) {
        WebContainerAvailability wcAvailabilityBean = this.getWebContainerAvailability();
        if (wcAvailabilityBean == null) {
            return defaultValue;
        }
        List<Property> props = wcAvailabilityBean.getProperty();
        if (props == null) {
            return defaultValue;
        }
        for (Property prop : props) {
            String name = prop.getName();
            String value = prop.getValue();
            if (!name.equalsIgnoreCase(propName)) continue;
            return value;
        }
        return defaultValue;
    }

    public boolean getWebContainerAvailabilityEnabledFromConfig() {
        boolean globalAvailabilityEnabled = this.getAvailabilityEnabledFromConfig();
        WebContainerAvailability was = this.getWebContainerAvailability();
        if (was == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("WebContainerAvailability not defined - check domain.xml");
            }
            return globalAvailabilityEnabled;
        }
        Boolean bool = this.toBoolean(was.getAvailabilityEnabled());
        if (bool == null) {
            return globalAvailabilityEnabled;
        }
        return bool;
    }

    public boolean isSsoFailoverEnabledFromConfig() {
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return false;
        }
        return this.toBoolean(webContainerAvailabilityBean.getSsoFailoverEnabled());
    }

    public boolean calculateWebAvailabilityEnabledFromConfig() {
        boolean globalAvailability = this.getAvailabilityEnabledFromConfig();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("globalAvailability = " + globalAvailability);
        }
        boolean webContainerAvailability = this.getWebContainerAvailabilityEnabledFromConfig();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("webContainerAvailability = " + webContainerAvailability);
        }
        return globalAvailability && webContainerAvailability;
    }

    public boolean calculateWebAvailabilityEnabledFromConfig(WebModule ctx) {
        DeployCommandParameters params;
        boolean waEnabled = this.calculateWebAvailabilityEnabledFromConfig();
        boolean webModuleAvailability = false;
        DeploymentContext dc = ctx.getWebModuleConfig().getDeploymentContext();
        if (dc != null && (params = dc.getCommandParameters(DeployCommandParameters.class)) != null) {
            webModuleAvailability = params.availabilityenabled;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("webModuleAvailability = " + webModuleAvailability);
        }
        return waEnabled && webModuleAvailability;
    }

    public boolean getAsyncReplicationFromConfig(WebModule ctx) {
        DeployCommandParameters params;
        boolean asyncReplication = true;
        DeploymentContext dc = ctx.getWebModuleConfig().getDeploymentContext();
        if (dc != null && (params = dc.getCommandParameters(DeployCommandParameters.class)) != null) {
            asyncReplication = params.asyncreplication;
        }
        return asyncReplication;
    }

    public PersistenceType getPersistenceTypeFromConfig() {
        String persistenceTypeString = null;
        PersistenceType persistenceType = null;
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return null;
        }
        persistenceTypeString = webContainerAvailabilityBean.getPersistenceType();
        if (persistenceTypeString != null) {
            persistenceType = PersistenceType.parseType(persistenceTypeString);
        }
        if (persistenceType != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("SERVER.XML persistenceType= " + persistenceType.getType());
            }
        } else if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("SERVER.XML persistenceType missing");
        }
        return persistenceType;
    }

    public String getPersistenceFrequencyFromConfig() {
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return null;
        }
        return webContainerAvailabilityBean.getPersistenceFrequency();
    }

    public String getPersistenceScopeFromConfig() {
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return null;
        }
        return webContainerAvailabilityBean.getPersistenceScope();
    }

    public boolean getDisableJreplicaFromConfig() {
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return false;
        }
        return this.toBoolean(webContainerAvailabilityBean.getDisableJreplica());
    }

    protected Boolean toBoolean(String value) {
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    Class loadClass(String className) throws Exception {
        return this.clh.getCommonClassLoader().loadClass(className);
    }
}

